$( document ).ready(function() {

// DATA
  var goodAnswerAudio = new Audio('../files/audio/ogolne/brawo.wav');
  var badAnswerAudio = new Audio('../files/audio/ogolne/sprobuj.wav');
  var questionAudio = new Audio('../files/audio/recykling/angielski/polecenie_1.wav');

  var questionNumber = 1;
  var roundNumber = 1;
  var noOfQuestions = [1,5,5];

  var answerAudios = {
    1: {
      0: [new Audio('../files/audio/recykling/angielski/paper.wav'),
          new Audio('../files/audio/recykling/angielski/plastic.wav'),
          new Audio('../files/audio/recykling/angielski/glass.wav'),
          new Audio('../files/audio/recykling/angielski/metal.wav'),
          new Audio('../files/audio/recykling/angielski/notebook.wav'),
          new Audio('../files/audio/recykling/angielski/book.wav')
        ],
      1: [new Audio('../files/audio/recykling/angielski/photo.wav'),
          new Audio('../files/audio/recykling/angielski/bottle.wav'),
          new Audio('../files/audio/recykling/angielski/mug.wav'),
          new Audio('../files/audio/recykling/angielski/bag.wav'),
          new Audio('../files/audio/recykling/angielski/jar.wav'),
          new Audio('../files/audio/recykling/angielski/glasses.wav')
        ],
      2: [new Audio('../files/audio/recykling/angielski/window.wav'),
          new Audio('../files/audio/recykling/angielski/can.wav'),
          new Audio('../files/audio/recykling/angielski/pot.wav'),
          new Audio('../files/audio/recykling/angielski/handle.wav')
        ]
    },
    2: [ new Audio('../files/audio/recykling/angielski/notebook.wav'),
         new Audio('../files/audio/recykling/angielski/bottle.wav'),
         new Audio('../files/audio/recykling/angielski/can.wav'),
         new Audio('../files/audio/recykling/angielski/book.wav'),
         new Audio('../files/audio/recykling/angielski/window.wav'),
         new Audio('../files/audio/recykling/angielski/handle.wav'),
         new Audio('../files/audio/recykling/angielski/mug.wav'),
         new Audio('../files/audio/recykling/angielski/jar.wav'),
         new Audio('../files/audio/recykling/angielski/photo.wav'),
         new Audio('../files/audio/recykling/angielski/pot.wav'),
         new Audio('../files/audio/recykling/angielski/glasses.wav'),
         new Audio('../files/audio/recykling/angielski/bag.wav'),
      ],
    3: [ new Audio('../files/audio/recykling/angielski/paper.wav'),
         new Audio('../files/audio/recykling/angielski/plastic.wav'),
         new Audio('../files/audio/recykling/angielski/glass.wav'),
         new Audio('../files/audio/recykling/angielski/metal.wav')
      ]
  }

  var round2Answers = {
    1: [1,4,9],
    2: [2,7,12],
    3: [5,8,11],
    4: [3,6,10]
  }

  var round2BadAnswers = []
  var round3BadAnswers = []

// MAIN LOGIC

  $('.next-round').on('click', function(){
    roundNumber += 1;
    $('.round-' + (roundNumber-1)).addClass('hidden')
    $('.round-' + roundNumber).removeClass('hidden')
    if(roundNumber == 3){
      $('.next-round').addClass('disabled')
    }
    $('.prev-round').removeClass('disabled')
    $( '.round-number' ).html( roundNumber );
    $('#round2EndedModal').modal('hide')
    questionNumber = 1;
    if(roundNumber == 2) {
      round2prepareCurrentQuestionData()
      questionAudio = new Audio('../files/audio/recykling/angielski/polecenie_2.wav');
    } else {
      if(roundNumber == 3){
        round3prepareCurrentQuestionData()
        questionAudio = new Audio('../files/audio/recykling/angielski/polecenie_3.wav');
      }
    }
  })

  $('.prev-round').on('click', function(){
    roundNumber -= 1;
    $('.round-' + (roundNumber+1)).addClass('hidden')
    $('.round-' + roundNumber).removeClass('hidden')

    if(roundNumber == 1){
      $('.prev-round').addClass('disabled')
    }
    $('.next-round').removeClass('disabled')
    $( '.round-number' ).html( roundNumber );
    questionNumber = 1;
    if(roundNumber == 2) {
      round2prepareCurrentQuestionData()
    } else {
      if(roundNumber == 3){
        round3prepareCurrentQuestionData()
        questionAudio = new Audio('../files/audio/recykling/angielski/polecenie_3.wav');
      }
    }
  })

  $('.read-question').on('click', function(event) {
    event.preventDefault()
    event.stopPropagation()
    questionAudio.play()
  })

// first round

  $('.answer-audio', '.answer-audios-1').on('click', function(event){
    event.preventDefault();
    event.stopPropagation();
    var answerNo = parseInt($(this).attr('data-answer-no'));
    answerAudios[1][0][answerNo-1].play();
  })

  $('.answer-audio', '.answer-audios-2').on('click', function(event){
    event.preventDefault();
    event.stopPropagation();
    var answerNo = parseInt($(this).attr('data-answer-no'));
    answerAudios[1][1][answerNo-1].play();
  })

  $('.answer-audio', '.answer-audios-3').on('click', function(event){
    event.preventDefault();
    event.stopPropagation();
    var answerNo = parseInt($(this).attr('data-answer-no'));
    answerAudios[1][2][answerNo-1].play();
  })


// second round
  var round2prepareCurrentQuestionData = function() {

  }


// ////////////////////////

  $('.answer-button', '.round-2 .people').on('click', function(event) {
    event.preventDefault()
    event.stopPropagation()
    if( $('.thumbnail', this).hasClass('selected') ){
      $('.thumbnail', this).removeClass('selected')
    } else {
      $('.thumbnail', '.people').removeClass('selected')
      $('.thumbnail', this).addClass('selected')
    }
    applyAnswerIfShould(null)
  })

  $('.answer-button', '.round-2 .possible-answers').not('.used').on('click', function(event) {
    event.preventDefault()
    event.stopPropagation()
    if( !$(this).hasClass('used') ){
      if( $('.thumbnail', this).hasClass('selected') ){
        $('.thumbnail', this).removeClass('selected')
      } else {
        $('.thumbnail', '.round-2 .possible-answers').removeClass('selected')
        $('.thumbnail', this).addClass('selected')
      }
      applyAnswerIfShould(answerAudios[2][parseInt($(this).attr('data-answer-no'))-1])
    }
  })

  applyAnswerIfShould = function(audioToPlay) {
    selectedPerson = $('.selected', '.round-2 .people')
    selectedAnswer = $('.selected', '.round-2 .possible-answers')
    if( selectedPerson.length > 0 && selectedAnswer.length > 0 ) {
      if ( round2Answers[ parseInt($(selectedPerson).parents('.answer-button').attr('data-answer-no')) ].indexOf( parseInt($(selectedAnswer).parents('.answer-button').attr('data-answer-no')) ) != -1 ) {
        $('.answers', $(selectedPerson).parents('.answer-container')).append('<div class="col-md-6 col-sm-6 col-xs-6 answered" data-answer-no="' + $(selectedAnswer).parents('.answer-button').attr('data-answer-no') + '"><div class="dummy"></div><div class="thumbnail"><img class="button-image" src="' + $('img', selectedAnswer).attr('src') + '" style="max-height: 100%;"></div></div>')
        $(selectedAnswer).parents('.answer-button').addClass('used').addClass('disabled')
        checkIfRound2Ended()
        if (audioToPlay) {
          goodAnswerAudio.play()
          setTimeout(function() {audioToPlay.play()}, 900)
        } else {
          goodAnswerAudio.play()
        }
      } else {
        round2BadAnswers.push ( $(selectedPerson).parents('.answer-button').attr('data-answer') + '-' + $(selectedAnswer).parents('.answer-button').attr('data-answer') )
        if (audioToPlay) {
          badAnswerAudio.play()
          setTimeout(function() {audioToPlay.play()}, 1700)
        } else {
          badAnswerAudio.play()
        }
      }
      $(selectedAnswer).removeClass('selected')
      $(selectedPerson).removeClass('selected')
    } else if (audioToPlay) {
      audioToPlay.play()
    }
  }

  checkIfRound2Ended = function() {
    if( $('.answer-button', '.round-2 .possible-answers').not('.used').length == 0 ){
      var answerCountsAreEqual = true
      var firstAnswersCount = null
      $('.answer-container', '.round-2 .people').each(function(index){
        answersCount = $('.answered', this).length
        if(index == 0){
          firstAnswersCount = answersCount
        }
        if(answersCount != firstAnswersCount){
          answerCountsAreEqual = false
        }
      })
      if( answerCountsAreEqual ) {
        $('.round-2-bad-answers', '#round2EndedModal').html(round2BadAnswers.join(', '))
        $('#round2EndedModal').modal('show')
      }
    }
  }

  $('.clear').on('click', function(event){
    event.preventDefault()
    $('#modalWrongAnswer').modal('hide')
    $('.answers').html('')
    $('.used').removeClass('used').removeClass('disabled')
  })

  showFinishModal = function() {
    var tableBodyHtml = '';
    for (var i=0; i<3; i++) {
      tableBodyHtml += '<tr><td>' + (i+1) + '</td><td>'
      tableBodyHtml += badAnswers[i].length
      tableBodyHtml += '</td><td>'
      if(checkedAnswers[i]){
        tableBodyHtml += 'TAK'
      } else {
        tableBodyHtml += 'NIE'
      }
      tableBodyHtml += '</td>'
    }
    $('tbody', '#allEndedModal').html(tableBodyHtml)
    $('#allEndedModal').modal('show')
  }

  showProperModal = function() {
    allCurrentAnsweredProperly = true;
    $('.picture', '.question-' + questionNumber).each(function(index){
      if( $(this).hasClass('is-correct') && !($(this).hasClass('correct-answer')) ){
        allCurrentAnsweredProperly = false;
      }
    })
    if( allCurrentAnsweredProperly ) {
      allAnsweredProperly = true;
      $('.picture.is-correct', '.possible-answers').each(function(index){
        if( !($(this).hasClass('correct-answer')) ){
          allAnsweredProperly = false;
        }
      })
      if( allAnsweredProperly ) {
        showFinishModal()
      } else {
        $('#modalCorrectAnswer').modal('show')
      }
    }
  }

// /////////////////////////



  $('.read-answer').on('click', function(event){
    event.preventDefault()
    answerAudios[roundNumber][questionNumber-1].play()
  })

  $( '.next-question', '.round-2' ).on('click', function(event){
    event.preventDefault()
    if($(this).parents('round-2')){
      if(questionNumber < noOfQuestions[1]){
        questionNumber++;
        round2prepareCurrentQuestionData()
        if(questionNumber == noOfQuestions[1]){
          $('.next-question', '.round-2').addClass('disabled')
        }
        $('.prev-question', '.round-2').removeClass('disabled')
      }
      $('#modalCorrectAnswer').modal('hide')
    }
  });

  $( '.prev-question', '.round-2' ).on('click', function(event){
    event.preventDefault()
    if(questionNumber > 1){
      questionNumber--;
      round2prepareCurrentQuestionData()
      if(questionNumber == 1){
        $('.prev-question', '.round-2').addClass('disabled')
      }
      $('.next-question', '.round-2').removeClass('disabled')
    }
  });


  $( '.round-number' ).html( roundNumber );

// third round

  var round3prepareCurrentQuestionData = function() {
  }

  $('.answer-button', '.round-3 .answer-handlers').on('click', function(event) {
    event.preventDefault()
    event.stopPropagation()
    if( $('.thumbnail', this).hasClass('selected') ){
      $('.thumbnail', this).removeClass('selected')
    } else {
      $('.thumbnail', '.round-3 .answer-handlers').removeClass('selected')
      $('.thumbnail', this).addClass('selected')
    }
    applyRound3AnswerIfShould(null)
  })

  $('.answer-button', '.round-3 .answers').not('.used').on('click', function(event) {
    event.preventDefault()
    event.stopPropagation()
    if( !$(this).hasClass('used') ){
      if( $('.thumbnail', this).hasClass('selected') ){
        $('.thumbnail', this).removeClass('selected')
      } else {
        $('.thumbnail', '.round-3 .answers').removeClass('selected')
        $('.thumbnail', this).addClass('selected')
      }
      applyRound3AnswerIfShould(answerAudios[3][parseInt($(this).attr('data-answer-no'))-1])
    }
  })

  applyRound3AnswerIfShould = function(audioToPlay) {
    selectedBasket = $('.selected', '.round-3 .answer-handlers')
    selectedAnswer = $('.selected', '.round-3 .answers')
    if( selectedBasket.length > 0 && selectedAnswer.length > 0 ) {
      if ( parseInt($(selectedBasket).parents('.answer-button').attr('data-answer-no')) == parseInt($(selectedAnswer).parents('.answer-button').attr('data-answer-no')) ) {

        $('.question-mark', '.round-3 .answered [data-answer-no=' + parseInt($(selectedBasket).parents('.answer-button').attr('data-answer-no')) + ']').addClass('hidden')
        $('.text', '.round-3 .answered [data-answer-no=' + parseInt($(selectedBasket).parents('.answer-button').attr('data-answer-no')) + ']').removeClass('hidden')
        $(selectedAnswer).parents('.answer-button').addClass('used').addClass('disabled')

        if (audioToPlay) {
          goodAnswerAudio.play()
          setTimeout(function() {audioToPlay.play()}, 900)
        } else {
          goodAnswerAudio.play()
        }
        checkIfRound3Ended()
      } else {
        round3BadAnswers.push ( $(selectedBasket).parents('.answer-button').attr('data-answer') + '-' + $('.text', selectedAnswer).text() )
        if (audioToPlay) {
          badAnswerAudio.play()
          setTimeout(function() {audioToPlay.play()}, 1700)
        } else {
          badAnswerAudio.play()
        }
      }
      $(selectedAnswer).removeClass('selected')
      $(selectedBasket).removeClass('selected')
    } else if (audioToPlay) {
      audioToPlay.play()
    }
  }

  var checkIfRound3Ended = function() {
    if ( $('.answer-button:not(.used)', '.round-3 .answers').length == 0 ) {
      $('.round-3-bad-answers', '#round3EndedModal').html(round3BadAnswers.join(', '))
      $('#round3EndedModal').modal('show')
    }
  }

  $('.check-answer', '.round-3').on('click', function(event) {
    event.preventDefault()
    event.stopPropagation()
    $('.answered').addClass('override-visible', 500).delay(500).removeClass('override-visible', 500).delay(500).addClass('override-visible', 500).delay(500).removeClass('override-visible', 500).delay(500).addClass('override-visible', 500).delay(500).removeClass('override-visible', 500).delay(500).addClass('override-visible', 500).delay(500).removeClass('override-visible', 500).delay(500).addClass('override-visible', 500).delay(500).removeClass('override-visible', 500)
  })

});
