$( document ).ready(function() {

  var goodAnswerAudio = new Audio('../files/audio/ogolne/brawo.wav');
  var badAnswerAudio = new Audio('../files/audio/ogolne/sprobuj.wav');
  var questionAudio = new Audio('../files/audio/uczenie-sie/dopasuj/polecenie.wav');

  var goodAnswers = {
    'left':  [1,2,5,6,9,11],
    'right': [3,4,7,8,10,12]
  }
  var badAnswersCount = 0
  var checkedAnswer = 'NIE'
  var selectedElement = null

  $('.read-question').on('click', function(event){
    event.preventDefault()
    questionAudio.play()
  })

  $('.check-answer').on('click', function(event){
    event.preventDefault()
    checkedAnswer = 'TAK'
    $('.answer-box.hidden').removeClass('hidden', 500).addClass('hidden', 500).removeClass('hidden', 500).addClass('hidden', 500).removeClass('hidden', 500).addClass('hidden', 500).removeClass('hidden', 500).addClass('hidden', 500).removeClass('hidden', 500).addClass('hidden', 500)
  })

  $('.brain').on('click', function(event) {
    event.preventDefault()
    if ( $('.brain.selected').length == 0 ) {
      $(this).addClass('selected')
    } else {
      $('.selected').removeClass('selected')
      $(this).addClass('selected')
    }
    checkAnswer()
  })

  $('.answer-box', '.possible-answers').on('click', function(event) {
    event.preventDefault()
    if (!$(this).hasClass('used')) {
      if ( $('.answer-box.selected', '.possible-answers').length == 0 ) {
        $(this).addClass('selected')
      } else {
        $('.selected').removeClass('selected')
        $(this).addClass('selected')
      }
      checkAnswer()
    }
  })

  checkAnswer = function() {
    answerObj = $('.answer-box.selected', '.possible-answers')
    brainObj = $('.brain.selected')
    if (answerObj.length > 0 && brainObj.length > 0) {
      if (goodAnswers[$(brainObj).attr('data-answer')].indexOf(parseInt($(answerObj).attr('data-answer-no'))) != -1) {
        badAnswerAudio.load()
        goodAnswerAudio.play()
        $('[data-answer-no=' + $(answerObj).attr('data-answer-no') + ']', '.brain-answer').removeClass('hidden').addClass('checked')
        $(answerObj).addClass('used')
        checkIfShouldEnd()
      } else {
        badAnswersCount  += 1
        goodAnswerAudio.load()
        badAnswerAudio.play()
      }
      $('.selected').removeClass('selected')
    }
  }

  checkIfShouldEnd = function() {
    if ($('.answer-box:not(.used)', '.possible-answers').length == 0)
      showFinishModal()
  }

  showFinishModal = function() {
    $('.bad-answer-count').text(badAnswersCount)
    $('.checked-answer').text(checkedAnswer)
    $('#allEndedModal').modal('show')
  }

})