$( document ).ready(function() {

  var goodAnswerAudio = new Audio('../files/audio/ogolne/brawo.wav');
  var badAnswerAudio = new Audio('../files/audio/ogolne/sprobuj.wav');
  var questionAudios = {
    1: new Audio('../files/audio/uczenie-sie/policz/polecenie_zolty.wav'),
    2: new Audio('../files/audio/uczenie-sie/policz/polecenie_czerwony.wav'),
    3: new Audio('../files/audio/uczenie-sie/policz/polecenie_zielony.wav'),
    4: new Audio('../files/audio/uczenie-sie/policz/polecenie_niebieski.wav'),
    5: new Audio('../files/audio/uczenie-sie/policz/polecenie_zolty.wav'),
    6: new Audio('../files/audio/uczenie-sie/policz/polecenie_czerwony.wav'),
    7: new Audio('../files/audio/uczenie-sie/policz/polecenie_zielony.wav'),
    8: new Audio('../files/audio/uczenie-sie/policz/polecenie_niebieski.wav')
  }


  var questionTexts = [
    'Policz i zapisz ile razy pojawiło się słowo żółty.',
    'Policz i zapisz ile razy pojawiło się słowo czerwony.',
    'Policz i zapisz ile razy pojawiło się słowo zielony.',
    'Policz i zapisz ile razy pojawiło się słowo niebieski.',
    'Policz i zapisz ile razy pojawiło się słowo żółty.',
    'Policz i zapisz ile razy pojawiło się słowo czerwony.',
    'Policz i zapisz ile razy pojawiło się słowo zielony.',
    'Policz i zapisz ile razy pojawiło się słowo niebieski.'
  ]

  var goodAnswers = [3,3,2,1,5,3,5,5]
  var questionNumber = 1
  var noOfQuestions = 8
  var answers = [ [], [], [], [], [], [], [], [] ]
  var checkedAnswers = [false, false, false, false, false, false, false, false]
  var interval = null
  var counter = 10

  handleIntervalEnd = function() {
    if (counter < 0) {
      clearInterval(interval)
      $('.normal', '.start').removeClass('hidden')
      $('.counter', '.start').addClass('hidden')
      $('.question-data').addClass('hidden')
      $('input', '.answer').val('')
      $('.answer').removeClass('hidden')
      $('input', '.answer').focus()
    }
  }

  $('.btn-policz.start').on('click', function(event){
    event.preventDefault();
    $('.answer').addClass('hidden')
    $('.question-data').addClass('hidden')
    $('.question-' + questionNumber + '-data').removeClass('hidden')
    $('.normal', '.start').addClass('hidden')
    $('.counter', '.start').removeClass('hidden')
    $('.counter', '.start').text(10)
    counter = 9
    interval = setInterval(function() {
      $('.counter', '.start').text(counter)
      counter -= 1
      handleIntervalEnd()
    }, 1000)
  })

  $('.btn-policz.stop').on('click', function(event){
    counter = -1
    handleIntervalEnd()
  })

  $('.check-answer').on('click', function(event){
    event.preventDefault()
    counter = -1
    handleIntervalEnd()
    $('.answer-count').val(goodAnswers[questionNumber-1])
    $('.check-my-answer').click()
    checkedAnswers[questionNumber-1] = true
  })

  $('.read-question').on('click', function(event){
    event.preventDefault()
    questionAudios[questionNumber].play()
  })

  $('.next-question').on('click', function(event){
    event.preventDefault();
    questionNumber+=1;
    $('.answer').addClass('hidden')
    if(noOfQuestions == questionNumber){
      $('.next-question').addClass('disabled');
    };
    $('.prev-question').removeClass('disabled');
    $('.question-number').html(questionNumber);
    $('#modalCorrectAnswer').modal('hide')
    if( answers[questionNumber-1] && answers[questionNumber-1].indexOf(goodAnswers[questionNumber-1]) == -1 ) {
    } else {
      $('.answer-count').val(goodAnswers[questionNumber-1])
    }
    $('.question-text').html(questionTexts[questionNumber-1])
  })

  $('.next-available-question').on('click', function(event){
    event.preventDefault();
    questionNumber = -1
    var i = 0
    _.each(answers, function(questionAnswers){
      if( questionNumber == -1 && questionAnswers.indexOf(goodAnswers[i]) == -1 ){
        questionNumber = i+1
      }
      i+=1;
    })
    $('.answer').addClass('hidden')
    if(noOfQuestions == questionNumber){
      $('.next-question').addClass('disabled');
    };
    $('.prev-question').removeClass('disabled');
    $('.question-number').html(questionNumber);
    $('#modalCorrectAnswer').modal('hide')
    if( answers[questionNumber-1] && answers[questionNumber-1].indexOf(goodAnswers[questionNumber-1]) == -1 ) {
    } else {
      $('.answer-count').val(goodAnswers[questionNumber-1])
    }
    $('.question-text').html(questionTexts[questionNumber-1])
  })

  $('.prev-question').on('click', function(event){
    event.preventDefault();
    questionNumber-=1;
    $('.answer').addClass('hidden')
    if(1 == questionNumber){
      $('.prev-question').addClass('disabled');
    };
    $('.next-question').removeClass('disabled');
    $('.question-number').html(questionNumber);
    $('#modalCorrectAnswer').modal('hide')
    if( answers[questionNumber-1] && answers[questionNumber-1].indexOf(goodAnswers[questionNumber-1]) == -1 ) {
    } else {
      $('.answer-count').val(goodAnswers[questionNumber-1])
    }
    $('.question-text').html(questionTexts[questionNumber-1])
  })

  $('.check-my-answer').on('click', function(event){
    event.preventDefault();
    answered = parseInt($('.answer-count').val())
    if( answered == goodAnswers[questionNumber-1] ) {
      badAnswerAudio.load();
      goodAnswerAudio.play();
      answers[questionNumber-1].push(answered)
      showProperModal()
    } else {
      goodAnswerAudio.load();
      badAnswerAudio.play();
      answers[questionNumber-1].push(answered)
    }
  })

  showFinishModal = function() {
    var tableBodyHtml = '';
    for (var i=0; i<10; i++) {
      tableBodyHtml += '<tr><td>' + (i+1) + '</td><td>'
      badAnswers = _.without(answers[i], goodAnswers[i])
      if(badAnswers.length > 0) {
        tableBodyHtml += badAnswers.length + ' (' + badAnswers.join(', ') + ')'
      } else {
        tableBodyHtml += '0'
      }
      tableBodyHtml += '</td><td>'
      if(checkedAnswers[i]){
        tableBodyHtml += 'TAK'
      } else {
        tableBodyHtml += 'NIE'
      }
      tableBodyHtml += '</td>'
    }
    $('tbody', '#countEndedModal').html(tableBodyHtml)
    $('#countEndedModal').modal('show')
  }

  showProperModal = function() {
    allAnsweredProperly = true;
    var i = 0;
    _.each(answers, function(questionAnswers){
      if( questionAnswers.indexOf(goodAnswers[i]) == -1 ){
        allAnsweredProperly = false;
      }
      i+=1;
    })
    if( allAnsweredProperly ) {
      showFinishModal()
    } else {
      $('#modalCorrectAnswer').modal('show')
    }
  }

  $('.question-number').html(questionNumber);
  $('.question-sum').html(noOfQuestions);
  $('.question-text').html(questionTexts[questionNumber-1])

})