$( document ).ready(function() {

// DATA
  var goodAnswerAudio = new Audio('../files/audio/ogolne/brawo.wav');
  var badAnswerAudio = new Audio('../files/audio/ogolne/sprobuj.wav');
  var questionAudio = new Audio('../files/audio/zywioly/quiz/polecenie_1.wav');

  var questionNumber = 1;
  var noOfQuestions = 11;

  var questionTypes = [
    'text',
    'text',
    'text',
    'text',
    'text',
    'text',
    'text',
    'text',
    'text',
    'text',
    'text'
  ]

  var questions = {
    1: "Żywioł to ...",
    2: "Ulewne deszcze mogą spowodować ...",
    3: "W lesie należy uważać z ogniem bo można wywołać ...",
    4: "W czasie burzy nie chowamy się pod ...",
    5: "W sytuacji zagrażającej życiu wzywamy pomoc pod numerem ...",
    6: "Trzęsienie ziemi mierzymy skalą ...",
    7: "Gdy woda wyleje się z koryta rzeki następuje ...",
    8: "Największy wulkan w Europie to ...",
    9: "Z kuchenki gazowej korzystamy pod kontrolą osoby ...",
    10: "Silny i porywisty wiatr to ...",
    11: "W czasie zagrożenia, pomocy udzieli nam ..."
  }

  var answers = {
    1: {
      0: ["woda", "ogień", "powietrze", "ziemia", "chmura"],
      1: ["woda.wav", "ogien.wav", "powietrze.wav", "ziemia.wav", "chmura.wav"]
    },
    2: {
      0: ["podtopienie", "zalanie", "suszę", "zaśmiecenie", "powódź"],
      1: ["podtopienie.wav", "zalanie.wav", "susze.wav", "zasmiecenie.wav", "powodz.wav"]
    },
    3: {
      0: ["zaśmiecenie", "wybuch", "zalanie", "pożar", "tornado"],
      1: ["zasmiecenie.wav", "wybuch.wav", "zalanie.wav", "pozar.wav", "tornado.wav"]
    },
    4: {
      0: ["drzewem", "słupem", "łóżkiem", "parasolem", "dachem"],
      1: ["drzewem.wav", "slupem.wav", "lozkiem.wav", "parasolem.wav", "dachem.wav"]
    },
    5: {
      0: ["112", "997", "999", "500", "998"],
      1: ["112.wav", "997.wav", "999.wav", "500.wav", "998.wav"]
    },
    6: {
      0: ["Celsjusza", "Richtera", "Ampera", "Geigera", "Kelwina"],
      1: ["celsjusza.wav", "richtera.wav", "ampera.wav", "geigera.wav", "kelwina.wav"]
    },
    7: {
      0: ["susza", "powódź", "ulewa", "pożar", "zaśmiecenie"],
      1: ["susza.wav", "powodz.wav", "ulewa.wav", "pozar.wav", "zasmiecenie.wav"]
    },
    8: {
      0: ["Etna", "Wezuwiusz", "K2", "Stromboli", "Kilimandżaro"],
      1: ["etna.wav", "wezuwiusz.wav", "k2.wav", "stromboli.wav", "kilimandzaro.wav"]
    },
    9: {
      0: ["silniejszej", "młodszej", "dorosłej", "wyższej", "niepełnoletniej"],
      1: ["silniejszej.wav", "mlodszej.wav", "doroslej.wav", "wyzszej.wav", "niepelnoletniej.wav"]
    },
    10: {
      0: ["wichura", "bryza", "fen", "huragan", "monsun"],
      1: ["wichura.wav", "bryza.wav", "fen.wav", "huragan.wav", "monsun.wav"]
    },
    11: {
      0: ["strażak", "ksiądz", "policjant", "lekarz", "polityk"],
      1: ["strazak.wav", "ksiadz.wav", "policjant.wav", "lekarz.wav", "polityk.wav"]
    }
  }

  var answerAudios = []

  var correctAnswerIndexes = {
    1: [1,2,3,4],
    2: [1,2,5],
    3: [4],
    4: [1,2],
    5: [1,2,3,5],
    6: [2],
    7: [2],
    8: [1],
    9: [3],
    10: [1,4],
    11: [1,3,4]
  }

  var questionsFinished = []

  var answered = {
    1: [],
    2: [],
    3: [],
    4: [],
    5: [],
    6: [],
    7: [],
    8: [],
    9: [],
    10: [],
    11: []
  }

// MAIN LOGIC

  $( '.question-number' ).html( questionNumber );
  $( '.question-sum' ).html( noOfQuestions );
  $( '.question-text' ).html( questions[questionNumber] );

  $( 'body' ).on('click', '.next-question', function(event){
    event.preventDefault()
    if(questionNumber < noOfQuestions){
      questionNumber++;
      setPageDataForQuestion()
    }
    $('#modalCorrectAnswer').modal('hide')
  });

  $( '.prev-question' ).on('click', function(event){
    event.preventDefault()
    if(questionNumber > 1){
      questionNumber--;
      setPageDataForQuestion()
    }
  });

  $('.answer-audio').on('click', function(event){
    event.preventDefault();
    event.stopPropagation();
    var answerNo = parseInt($(this).attr('data-answer-no'));
    answerAudios[answerNo-1].play();
  })

  $( '.answer-button' ).on('click', function(event) {
    event.preventDefault()
    $('.wrong-answer').removeClass('wrong-answer')
    $('.last-answer').removeClass('last-answer')
    $(this).addClass('last-answer')
    var answerNo = parseInt($(this).attr('data-answer-no'))
    answered[questionNumber].push(answerNo)
    if(correctAnswerIndexes[questionNumber].indexOf(answerNo) !== -1) {
      $(this).addClass('correct-answer')
      badAnswerAudio.load()
      goodAnswerAudio.play()

      if(_.uniq(_.intersection(correctAnswerIndexes[questionNumber], answered[questionNumber])).length == correctAnswerIndexes[questionNumber].length) {

        //all correct answers selected
        if(questionsFinished.indexOf(questionNumber) == -1){
          questionsFinished.push(questionNumber)
        }
        if(!(questionsFinished.length === noOfQuestions)){
          if(questionNumber < noOfQuestions){
            showCorrectAnswerModal()
          }
        } else {
          fillEndModalAndShowIt()
        }

      }
    } else {
      goodAnswerAudio.load()
      badAnswerAudio.play()
      $(this).addClass('wrong-answer')
    }
  });

  $('.read-question').on('click', function(event) {
    event.preventDefault()
    questionAudio.play()
  })

  $('.check-answer').on('click', function(event) {
    event.preventDefault()
    $('.is-correct').toggleClass('correct-answer', 500).delay(500).toggleClass('correct-answer', 500).delay(500).toggleClass('correct-answer', 500).delay(500).toggleClass('correct-answer', 500).delay(500).toggleClass('correct-answer', 500).delay(500).toggleClass('correct-answer', 500)
  })

  var setPageDataForQuestion = function() {
    $( '.question-number' ).html(questionNumber );
    $( '.question-text' ).html(questions[questionNumber] );
    $( '.question-image').html('')

    questionAudio = new Audio('../files/audio/zywioly/quiz/polecenie_' + questionNumber + '.wav');

    if(questionTypes[questionNumber-1] === 'image'){
      setAnswerButtonsForImage()
    } else if(questionTypes[questionNumber-1] === 'text') {
      setAnswerButtonsForText()
    } else if(questionTypes[questionNumber-1] === 'text-with-image') {
      setAnswerButtonsForText()
      setImageForQuestion()
    }
    setAnswerAudiosButtons()
    if(questionNumber == noOfQuestions) {
      $( '.next-question' ).addClass('disabled')
    } else {
      $( '.next-question' ).removeClass('disabled');
    };
    if(questionNumber == 1) {
      $( '.prev-question' ).addClass('disabled');
    } else {
      $( '.prev-question' ).removeClass('disabled');
    }
    $('.wrong-answer').removeClass('wrong-answer')
    $('.last-answer').removeClass('last-answer')
  }

  var setAnswerAudiosButtons = function() {
    for (i = 0; i < 7; i++) {
      button = $('.answer-audio.aa-' + (i+1), '.answer-audios')
      if(answers[questionNumber][0][i]){
        $(button).removeClass('hide')
      } else {
        $(button).addClass('hide')
      }
    }
  }

  var setAnswerButtonsForText = function() {
    $('.answer-buttons-img').hide();
    $('.answer-buttons-txt').show();
    $('.answer-button').removeClass('is-correct')

    for (i = 0; i < 7; i++) {
      button = $('.answer-button.ab-' + (i+1), '.answer-buttons-txt')

      if(correctAnswerIndexes[questionNumber].indexOf(i+1) != -1){
        $(button).addClass('is-correct')
      }

      if(answers[questionNumber][0][i]){
        $(button).removeClass('hide')
        if(answered[questionNumber].indexOf(i+1) !== -1 && correctAnswerIndexes[questionNumber].indexOf(i+1) !== -1) {
          $(button).addClass('correct-answer')
        } else {
          $(button).removeClass('correct-answer')
        }
        $( '.text', $('a', button) ).html(answers[questionNumber][0][i]);
      } else {
        $(button).addClass('hide')
      }
    }
    setAnswerAudios(1)
  }

  var setImageForQuestion = function () {
    $( '.question-image').html('<img src="../files/img/zywioly/quiz/' + answers[questionNumber][2] + '">')
  }

  var setAnswerButtonsForImage = function() {
    $('.answer-buttons-txt').hide();
    $('.answer-buttons-img').show();
    $('.answer-button').removeClass('is-correct')
    for (i = 0; i < 7; i++) {
      button = $('.answer-button.ab-' + (i+1), '.answer-buttons-img')

      if(correctAnswerIndexes[questionNumber].indexOf(i+1) != -1){
        $(button).addClass('is-correct')
      }

      if(answers[questionNumber][1][i]){
        $(button).removeClass('hide')
        if(answered[questionNumber].indexOf(i+1) !== -1 && correctAnswerIndexes[questionNumber].indexOf(i+1) !== -1) {
          $(button).addClass('correct-answer')
        } else {
          $(button).removeClass('correct-answer')
        }
        $( '.button-image', button ).attr('src', '../files/img/zywioly/quiz/' + answers[questionNumber][1][i]);
        $( '.button-footer', button ).text(answers[questionNumber][0][i]);
      } else {
        $(button).addClass('hide')
      }
    }
    setAnswerAudios(2)
  }

  var setAnswerAudios = function(index){
    answerAudios = []
    for (i = 0; i < answers[questionNumber][index].length; i++) {
      answerAudios.push(new Audio('../files/audio/zywioly/quiz/' + answers[questionNumber][index][i]))
    }
  }

  var fillEndModalAndShowIt = function() {
    var tableBodyHtml = '';
    var i = 1;
    _.each(answered, function(yourAnswers){
      var yourAnswerTexts = []
      _.each(yourAnswers, function(answer) {
        if(correctAnswerIndexes[i].indexOf(answer) != -1){
          yourAnswerTexts.push('<span class="text-success">' + answers[i][0][answer-1] + '</span>')
        } else {
          yourAnswerTexts.push('<span class="text-danger">' + answers[i][0][answer-1] + '</span>')
        }
      })
      tableBodyHtml+='<tr><td>' + i + '</td><td>' + yourAnswers.length + '</td><td>' + _.difference(yourAnswers, correctAnswerIndexes[i]).length + '</td><td>' + yourAnswerTexts.join(', ') + '</td></tr>'
      i+=1;
    })
    $('tbody', '#quizEndedModal').html(tableBodyHtml)
    $('#quizEndedModal').modal('show')
  }

  var showCorrectAnswerModal = function(){
    $('#modalCorrectAnswer').modal('show')
  }



  setPageDataForQuestion()

});
