$( document ).ready(function() {

  var goodAnswerAudio = new Audio('../files/audio/ogolne/brawo.wav');
  var badAnswerAudio = new Audio('../files/audio/ogolne/sprobuj.wav');
  var questionAudio = new Audio('../files/audio/woda/policz_2_figury/polecenie.wav');

  var worngAnswersCount = [0,0,0,0,0,0,0]
  var properAnswers = [false, false, false, false, false, false, false]
  var checkedAnswers = [false, false, false, false, false, false, false]
  var questionNumber = 1
  var noOfQuestions = 7
  var currentAnswerPosition = 1

  var answerData = [
    [
      ['kolo.png', 'szesciokat.png', 'kwadrat.png', 'trojkat_prostokatny.png'],
      ['kolo.png', 'strzalka_lewo.png']
    ],
    [
      ['szesciokat.png', 'strzalka_gora.png', 'romb.png', 'strzalka_lewo.png'],
      ['kolo.png', 'romb.png']
    ],
    [
      ['trojkat.png', 'prostokat.png', 'kwadrat.png', 'strzalka_gora.png'],
      ['kwadrat.png', 'kolo.png']
    ],
    [
      ['trojkat.png', 'kolo.png', 'szesciokat.png', 'trojkat_prostokatny.png'],
      ['kolo.png', 'romb.png']
    ],
    [
      ['kwadrat.png', 'trojkat.png', 'strzalka_gora.png', 'szesciokat.png'],
      ['kolo.png', 'strzalka_gora.png']
    ],
    [
      ['romb.png', 'trojkat.png', 'strzalka_lewo.png', 'szesciokat.png'],
      ['kwadrat.png', 'trojkat_prostokatny.png']
    ],
    [
      ['trojkat_prostokatny.png', 'kwadrat.png', 'kolo.png', 'prostokat.png'],
      ['kwadrat.png', 'kwadrat.png']
    ]
  ]

  $('.read-question').on('click', function(event){
    event.preventDefault()
    questionAudio.play()
  })

  $('.check-answer').on('click', function(e) {
    e.preventDefault()
    $('.answer').each(function(index) {
      $(this).attr('src', '../files/img/woda/figury/' + answerData[questionNumber-1][1][index])
    })
    $('.answer').removeClass('hidden', 500).addClass('hidden', 500).removeClass('hidden', 500).addClass('hidden', 500).removeClass('hidden', 500).addClass('hidden', 500)
    currentAnswerPosition = 1
    checkedAnswers[questionNumber-1] = true
  })

  $('a', '.answer-button').on('click', function(e) {
    e.preventDefault()
    $('img.answer-' + currentAnswerPosition).attr('src', $('img', this).attr('src')).removeClass('hidden')
    if (currentAnswerPosition == 2) {
      checkAnswer()
    } else {
      currentAnswerPosition += 1
    }
  })

  checkAnswer = function() {
    var isProperAnswer = true
    $('img.answer').each(function(index) {
      console.log (_.last($(this).attr('src').split('/')))
      console.log (answerData[questionNumber-1][1][index])
      if (_.last($(this).attr('src').split('/')) != answerData[questionNumber-1][1][index]){
        isProperAnswer = false
      }
    })
    if (isProperAnswer) {
      goodAnswerAudio.play()
      properAnswers[questionNumber-1] = true
      if (properAnswers.indexOf(false) == -1) {
        showEndModal()
      } else {
        showCorrectAnswerModal()
      }
    } else {
      badAnswerAudio.play()
      worngAnswersCount[questionNumber-1] += 1
      showBadAnswerModal()
    }
  }

  showBadAnswerModal = function () {
    $('#modalTryAgain').modal('show')
  }
  showCorrectAnswerModal = function () {
    $('#modalCorrectAnswer').modal('show')
  }
  showEndModal = function () {
    $('tbody', '#allEndedModal').html('')
    for(var i=1; i<=noOfQuestions; i++) {
      var podpowiedz = "NIE"
      if (checkedAnswers[i-1])
        podpowiedz = 'TAK'
      $('tbody', '#allEndedModal').append('<tr><td>' + i + '</td><td>' + podpowiedz + '</td><td>' + worngAnswersCount[i-1] + '</td></tr>')
    }
    $('#allEndedModal').modal('show')
  }

  $( 'body' ).on('click', '.next-question', function(event){
    event.preventDefault()
    if(questionNumber < noOfQuestions){
      questionNumber++;
      loadQuestionData()
    }
  });

  $( '.prev-question' ).on('click', function(event){
    event.preventDefault()
    if(questionNumber > 1){
      questionNumber--;
      loadQuestionData()
    }
  });

  $('.clear-answers').on('click', function(e) {
    e.preventDefault()
    loadQuestionData()
  })

  loadQuestionData = function () {
    $('#modalCorrectAnswer').modal('hide')
    $('#modalTryAgain').modal('hide')
    if(questionNumber == noOfQuestions) {
      $( '.next-question' ).addClass('disabled')
    } else {
      $( '.next-question' ).removeClass('disabled');
    };
    if(questionNumber == 1) {
      $( '.prev-question' ).addClass('disabled');
    } else {
      $( '.prev-question' ).removeClass('disabled');
    }

    $('.answer').attr('src', '').addClass('hidden')
    $('.operation-element').each(function(index) {
      $(this).attr('src', '../files/img/woda/figury/' + answerData[questionNumber-1][0][index])
    })
    currentAnswerPosition = 1
  }




})