$( document ).ready(function() {

// DATA
  var goodAnswerAudio = new Audio('../files/audio/ogolne/brawo.wav');
  var badAnswerAudio = new Audio('../files/audio/ogolne/sprobuj.wav');
  var questionAudio = new Audio('../files/audio/woda/quiz/1.wav');

  var questionNumber = 1;
  var noOfQuestions = 10;

  var questionTypes = [
    'text',
    'text',
    'text',
    'text',
    'text',
    'text',
    'text',
    'text',
    'text',
    'text'
  ]

  var questions = {
    1: "Ile to jest trzy litry plus sześć litrów?",
    2: "Ile to jest sześć litrów plus sześć litrów?",
    3: "Ile to jest pięć litrów plus osiem litrów?",
    4: "Ile to jest pięć litrów plus osiem litrów plus pięć litrów?",
    5: "Ile to jest siedem litrów plus dziesięć litrów plus siedem litrów?",
    6: "Ile to jest dziesięć litrów plus dziesięć litrów plus dwa litry?",
    7: "Ile to jest sześć litrów plus siedem litrów plus osiem litrów?",
    8: "Ile to jest sześć litrów plus sześć litrów plus jedenaście litrów?",
    9: "Ile to jest osiem litrów plus dziewięć litrów plus dwanaście litrów?",
    10: "Ile to jest trzynaście litrów plus dziewięć litrów plus siedem litrów?"
  }

  var answers = {
    1: {
      0: ["jedenaście litrów", "dziesięć litrów", "dziewięć litrów"],
      1: ['11l.wav', '10l.wav', '9l.wav']
    },
    2: {
      0: ["jedenaście litrów", "siedemnaś-<br>cie litrów", "dwanaście litrów"],
      1: ['11l.wav', '17l.wav', '12l.wav']
    },
    3: {
      0: ["jedenaście litrów", "trzynaście litrów", "osiemnaście litrów"],
      1: ['11l.wav', '13l.wav', '18l.wav']
    },
    4: {
      0: ["osiemnaście litrów", "dziesięć litrów", "dziewiętnaś-<br>cie litrów"],
      1: ['18l.wav', '10l.wav', '19l.wav']
    },
    5: {
      0: ["dwadzieścia cztery litry", "dziewiętnaś-<br>cie litrów", "dwadzieścia trzy litry"],
      1: ['24l.wav', '19l.wav', '23l.wav']
    },
    6: {
      0: ["dwadzieścia cztery litry", "dwadzieścia dwa litry", "dwadzieścia trzy litry"],
      1: ['24l.wav', '22l.wav', '23l.wav']
    },
    7: {
      0: ["dwadzieścia cztery litry", "dwadzieścia dwa litry", "dwadzieścia jeden litrów"],
      1: ['24l.wav', '22l.wav', '21l.wav']
    },
    8: {
      0: ["dwadzieścia cztery litry", "dwadzieścia dwa litry", "dwadzieścia trzy litry"],
      1: ['24l.wav', '22l.wav', '23l.wav']
    },
    9: {
      0: ["dwadzieścia dziewięć litrów", "dwadzieścia osiem litrów", "dwadzieścia trzy litry"],
      1: ['29l.wav', '28l.wav', '23l.wav']
    },
    10: {
      0: ["dwadzieścia dziewięć litrów", "dwadzieścia osiem litrów", "dwadzieścia trzy litry"],
      1: ['29l.wav', '28l.wav', '23l.wav']
    },

  }

  var answerAudios = []

  var correctAnswerIndexes = {
    1: [3],
    2: [3],
    3: [2],
    4: [1],
    5: [1],
    6: [2],
    7: [3],
    8: [3],
    9: [1],
    10: [1]
  }

  var questionsFinished = []

  var answered = {
    1: [],
    2: [],
    3: [],
    4: [],
    5: [],
    6: [],
    7: [],
    8: [],
    9: [],
    10: []
  }

// MAIN LOGIC

  $( '.question-number' ).html( questionNumber );
  $( '.question-sum' ).html( noOfQuestions );
  $( '.question-text' ).html( questions[questionNumber] );

  $( 'body' ).on('click', '.next-question', function(event){
    event.preventDefault()
    if(questionNumber < noOfQuestions){
      questionNumber++;
      setPageDataForQuestion()
    }
    $('#modalCorrectAnswer').modal('hide')
  });

  $( '.prev-question' ).on('click', function(event){
    event.preventDefault()
    if(questionNumber > 1){
      questionNumber--;
      setPageDataForQuestion()
    }
  });

  $('.answer-audio').on('click', function(event){
    event.preventDefault();
    event.stopPropagation();
    var answerNo = parseInt($(this).attr('data-answer-no'));
    answerAudios[answerNo-1].play();
  })

  $( '.answer-button' ).on('click', function(event) {
    event.preventDefault()
    $('.wrong-answer').removeClass('wrong-answer')
    $('.last-answer').removeClass('last-answer')
    $(this).addClass('last-answer')
    var answerNo = parseInt($(this).attr('data-answer-no'))
    answered[questionNumber].push(answerNo)
    if(correctAnswerIndexes[questionNumber].indexOf(answerNo) !== -1) {
      $(this).addClass('correct-answer')
      badAnswerAudio.load()
      goodAnswerAudio.play()

      if(_.uniq(_.intersection(correctAnswerIndexes[questionNumber], answered[questionNumber])).length == correctAnswerIndexes[questionNumber].length) {

        //all correct answers selected
        if(questionsFinished.indexOf(questionNumber) == -1){
          questionsFinished.push(questionNumber)
        }
        if(!(questionsFinished.length === noOfQuestions)){
          if(questionNumber < noOfQuestions){
            showCorrectAnswerModal()
          }
        } else {
          fillEndModalAndShowIt()
        }

      }
    } else {
      goodAnswerAudio.load()
      badAnswerAudio.play()
      $(this).addClass('wrong-answer')
    }
  });

  $('.read-question').on('click', function(event) {
    event.preventDefault()
    questionAudio.play()
  })

  $('.check-answer').on('click', function(event) {
    event.preventDefault()
    $('.is-correct').toggleClass('correct-answer', 500).delay(500).toggleClass('correct-answer', 500).delay(500).toggleClass('correct-answer', 500).delay(500).toggleClass('correct-answer', 500).delay(500).toggleClass('correct-answer', 500).delay(500).toggleClass('correct-answer', 500)
  })

  var setPageDataForQuestion = function() {
    $( '.question-number' ).html(questionNumber );
    $( '.question-text' ).html(questions[questionNumber] );
    $( '.question-image').html('')

    questionAudio = new Audio('../files/audio/woda/quiz/' + questionNumber + '.wav');

    if(questionTypes[questionNumber-1] === 'image'){
      setAnswerButtonsForImage()
    } else if(questionTypes[questionNumber-1] === 'text') {
      setAnswerButtonsForText()
    } else if(questionTypes[questionNumber-1] === 'text-with-image') {
      setAnswerButtonsForText()
      setImageForQuestion()
    }
    setAnswerAudiosButtons()
    if(questionNumber == noOfQuestions) {
      $( '.next-question' ).addClass('disabled')
    } else {
      $( '.next-question' ).removeClass('disabled');
    };
    if(questionNumber == 1) {
      $( '.prev-question' ).addClass('disabled');
    } else {
      $( '.prev-question' ).removeClass('disabled');
    }
    $('.wrong-answer').removeClass('wrong-answer')
    $('.last-answer').removeClass('last-answer')
  }

  var setAnswerAudiosButtons = function() {
    for (i = 0; i < 7; i++) {
      button = $('.answer-audio.aa-' + (i+1), '.answer-audios')
      if(answers[questionNumber][0][i]){
        $(button).removeClass('hide')
      } else {
        $(button).addClass('hide')
      }
    }
  }

  var setAnswerButtonsForText = function() {
    $('.answer-buttons-img').hide();
    $('.answer-buttons-txt').show();
    $('.answer-button').removeClass('is-correct')

    for (i = 0; i < 7; i++) {
      button = $('.answer-button.ab-' + (i+1), '.answer-buttons-txt')

      if(correctAnswerIndexes[questionNumber].indexOf(i+1) != -1){
        $(button).addClass('is-correct')
      }

      if(answers[questionNumber][0][i]){
        $(button).removeClass('hide')
        if(answered[questionNumber].indexOf(i+1) !== -1 && correctAnswerIndexes[questionNumber].indexOf(i+1) !== -1) {
          $(button).addClass('correct-answer')
        } else {
          $(button).removeClass('correct-answer')
        }
        $( '.text', $('a', button) ).html(answers[questionNumber][0][i]);
      } else {
        $(button).addClass('hide')
      }
    }
    setAnswerAudios(1)
  }

  var setImageForQuestion = function () {
    $( '.question-image').html('<img src="../files/img/woda/quiz/' + answers[questionNumber][2] + '">')
  }

  var setAnswerButtonsForImage = function() {
    $('.answer-buttons-txt').hide();
    $('.answer-buttons-img').show();
    $('.answer-button').removeClass('is-correct')
    for (i = 0; i < 7; i++) {
      button = $('.answer-button.ab-' + (i+1), '.answer-buttons-img')

      if(correctAnswerIndexes[questionNumber].indexOf(i+1) != -1){
        $(button).addClass('is-correct')
      }

      if(answers[questionNumber][1][i]){
        $(button).removeClass('hide')
        if(answered[questionNumber].indexOf(i+1) !== -1 && correctAnswerIndexes[questionNumber].indexOf(i+1) !== -1) {
          $(button).addClass('correct-answer')
        } else {
          $(button).removeClass('correct-answer')
        }
        $( '.button-image', button ).attr('src', '../files/img/woda/quiz/' + answers[questionNumber][1][i]);
        $( '.button-footer', button ).text(answers[questionNumber][0][i]);
      } else {
        $(button).addClass('hide')
      }
    }
    setAnswerAudios(2)
  }

  var setAnswerAudios = function(index){
    answerAudios = []
    if (questionNumber < 11) {
      for (i = 0; i < answers[questionNumber][index].length; i++) {
        answerAudios.push(new Audio('../files/audio/woda/quiz/' + answers[questionNumber][index][i]))
      }
    }
  }

  var fillEndModalAndShowIt = function() {
    var tableBodyHtml = '';
    var i = 1;
    _.each(answered, function(yourAnswers){
      var yourAnswerTexts = []
      _.each(yourAnswers, function(answer) {
        if(correctAnswerIndexes[i].indexOf(answer) != -1){
          yourAnswerTexts.push('<span class="text-success">' + answers[i][0][answer-1] + '</span>')
        } else {
          yourAnswerTexts.push('<span class="text-danger">' + answers[i][0][answer-1] + '</span>')
        }
      })
      tableBodyHtml+='<tr><td>' + i + '</td><td>' + yourAnswers.length + '</td><td>' + _.difference(yourAnswers, correctAnswerIndexes[i]).length + '</td><td>' + yourAnswerTexts.join(', ') + '</td></tr>'
      i+=1;
    })
    $('tbody', '#quizEndedModal').html(tableBodyHtml)
    $('#quizEndedModal').modal('show')
  }

  var showCorrectAnswerModal = function(){
    $('#modalCorrectAnswer').modal('show')
  }



  setPageDataForQuestion()

});
