$( document ).ready(function() {

// DATA
  var goodAnswerAudio = new Audio('../files/audio/ogolne/brawo.wav');
  var badAnswerAudio = new Audio('../files/audio/ogolne/sprobuj.wav');
  var questionAudio = new Audio('../files/audio/czas/angielski/polecenie_1.wav');

  var questionNumber = 1;
  var roundNumber = 1;
  var noOfQuestions = [1,5,5];
  var timeouts = []

  var round2part = 1
  var round3part = 1

  var round2BadAnswersCount = 0

  var round2CheckedAnswer = false

  var round3BadAnswersCount = 0

  var round3CheckedAnswer = false

// MAIN LOGIC

  $('.read-question').on('click', function(event) {
    event.preventDefault()
    questionAudio.play()
  })

  $('.next-round').on('click', function(){
    roundNumber += 1;
    $('.round-' + (roundNumber-1)).addClass('hidden')
    $('.round-' + roundNumber).removeClass('hidden')
    if(roundNumber == 3){
      $('.next-round').addClass('disabled')
    }
    $('.prev-round').removeClass('disabled')
    $( '.round-number' ).html( roundNumber );
    $('#round22EndedModal').modal('hide')
    $('#round21EndedModal').modal('hide')
    questionNumber = 1;
    if(roundNumber == 2) {
      round2prepareCurrentQuestionData()
      questionAudio = new Audio('../files/audio/czas/angielski/polecenie_2.wav');
    } else {
      if(roundNumber == 3){
        round3prepareCurrentQuestionData()
        questionAudio = new Audio('../files/audio/czas/angielski/polecenie_3.wav');
      }
    }
  })

  $('.prev-round').on('click', function(){
    roundNumber -= 1;
    $('.round-' + (roundNumber+1)).addClass('hidden')
    $('.round-' + roundNumber).removeClass('hidden')

    if(roundNumber == 1){
      $('.prev-round').addClass('disabled')
    }
    $('.next-round').removeClass('disabled')
    $( '.round-number' ).html( roundNumber );
    questionNumber = 1;
    if(roundNumber == 2) {
      round2prepareCurrentQuestionData()
    } else {
      if(roundNumber == 3){
        round3prepareCurrentQuestionData()
        questionAudio = new Audio('../files/audio/czas/angielski/polecenie_3.wav');
      }
    }
  })

  $('.round-2-next-part').on('click', function(event) {
    event.preventDefault()
    round2part += 1;
    $('#round22EndedModal').modal('hide')
    $('#round21EndedModal').modal('hide')
    $('.round-2-' + (round2part-1).toString()).addClass('hidden')
    $('.round-2-' + round2part.toString()).removeClass('hidden')
  })

  $('.round-3-next-part').on('click', function(event) {
    event.preventDefault()
    round3part += 1;
    $('#round32EndedModal').modal('hide')
    $('#round31EndedModal').modal('hide')
    $('.round-3-' + (round3part-1).toString()).addClass('hidden')
    $('.round-3-' + round3part.toString()).removeClass('hidden')
  })

// first round


  drawDropping = function(item, index){
    timeouts[index] = setTimeout(function(){
      $(item).addClass('bottom', 4500);
      audio = new Audio('../files/audio/czas/angielski/' + (index+1).toString() + '.wav')
      audioPL = new Audio('../files/audio/czas/angielski/' + (index+1).toString() + 'a.wav')
      audioPL.play();
      setTimeout(function() {
        audio.play()
      }, 1500)
    }, index*4500)
  }

  $('.btn-policz.start').on('click', function(event){
    event.preventDefault();
    $('.count-container', '.round-1').removeClass('bottom');
    $('.count-container', '.round-1').each(function(index){
      drawDropping(this, index)
    })
  })

  $('.btn-policz.stop').on('click', function(event){
    _.each(timeouts, function(item){
      clearTimeout(item)
    })
    $('.count-container', '.round-1').removeClass('bottom');
  })


// second round
  var selectedBtn = null

  round2prepareCurrentQuestionData = function () {
    selectedBtn = null
    $('.correct-answer-2', '.round-2').removeClass('correct-answer-2')
  }

  $('.answer-button', '.round-2').on('click', function(event) {
    event.preventDefault()
    if (selectedBtn) {
      if ( $(selectedBtn).hasClass('answer-button') ) {
        $(selectedBtn).removeClass('correct-answer-2')
        $(this).addClass('correct-answer-2')
        selectedBtn = this
      } else {
        processAnswer(this)
      }
    } else {
      $(this).addClass('correct-answer-2')
      selectedBtn = this
    }
  })

  $('.possible-answer-button', '.round-2').on('click', function(event) {
    event.preventDefault()
    if (selectedBtn) {
      if ( $(selectedBtn).hasClass('possible-answer-button') ) {
        $(selectedBtn).removeClass('correct-answer-2')
        $(this).addClass('correct-answer-2')
        selectedBtn = this
      } else {
        processAnswer(this)
      }
    } else {
      $(this).addClass('correct-answer-2')
      selectedBtn = this
    }
  })

  processAnswer = function (lastSelected) {
    if ( parseInt($(lastSelected).attr('data-answer-no')) == parseInt($(selectedBtn).attr('data-answer-no')) ) {
      badAnswerAudio.load()
      goodAnswerAudio.play()
      if ( $(selectedBtn).hasClass('answer-button') ) {
        $('p', selectedBtn).html($('p', lastSelected).html())
        $(selectedBtn).addClass('answered')
      } else {
        $('p', lastSelected).html($('p', selectedBtn).html())
        $(lastSelected).addClass('answered')
      }
      if (round2part==2 && $('.answer-button:not(".answered")', '.round-2-2').length == 0) {
        $('#round2BadAnswersCount').html(round2BadAnswersCount)
        if (round2CheckedAnswer) { ans = 'TAK' } else { ans = 'NIE' }
        $('#round2CheckedAnswer').html(ans)
        $('#round22EndedModal').modal('show')
      } else {
        if (round2part==1 && $('.answer-button:not(".answered")', '.round-2-1').length == 0) {
          $('#round21EndedModal').modal('show')
        }
      }
    } else {
      goodAnswerAudio.load()
      badAnswerAudio.play()
      round2BadAnswersCount += 1
    }
    $('.correct-answer-2', '.round-2').removeClass('correct-answer-2')
    selectedBtn = null
  }

  $('.read-answer').on('click', function(event){
    event.preventDefault()
    answerAudios[roundNumber][questionNumber-1].play()
  })

  $('.check-answer', '.round-2').on('click', function(event) {
    event.preventDefault()
    round2CheckedAnswer = true
    $('p', '.round-2 .answer-button').addClass('hidden')
    $('.proper', '.round-2 .answer-button').removeClass('hidden').addClass('hidden', 500).removeClass('hidden', 500).addClass('hidden', 500).removeClass('hidden', 500).addClass('hidden', 500)
    setTimeout(function() {
      $('p', '.round-2 .answer-button').removeClass('hidden')
    }, 2500)
  })

  $( '.round-number' ).html( roundNumber );

// third round

  var selectedBtnR3 = null

  round3prepareCurrentQuestionData = function () {
    selectedBtnR3 = null
    $('.correct-answer-2', '.round-3').removeClass('correct-answer-2')
  }

  $('.answer-button', '.round-3').on('click', function(event) {
    event.preventDefault()
    if (selectedBtnR3) {
      if ( $(selectedBtnR3).hasClass('answer-button') ) {
        $(selectedBtnR3).removeClass('correct-answer-2')
        $(this).addClass('correct-answer-2')
        selectedBtnR3 = this
      } else {
        processAnswerR3(this)
      }
    } else {
      $(this).addClass('correct-answer-2')
      selectedBtnR3 = this
    }
  })

  $('.possible-answer-button', '.round-3').on('click', function(event) {
    event.preventDefault()
    if (selectedBtnR3) {
      if ( $(selectedBtnR3).hasClass('possible-answer-button') ) {
        $(selectedBtnR3).removeClass('correct-answer-2')
        $(this).addClass('correct-answer-2')
        selectedBtnR3 = this
      } else {
        processAnswerR3(this)
      }
    } else {
      $(this).addClass('correct-answer-2')
      selectedBtnR3 = this
    }
  })

  processAnswerR3 = function (lastSelected) {
    if ( parseInt($(lastSelected).attr('data-answer-no')) == parseInt($(selectedBtnR3).attr('data-answer-no')) ) {
      badAnswerAudio.load()
      goodAnswerAudio.play()
      if ( $(selectedBtnR3).hasClass('answer-button') ) {
        $('p', selectedBtnR3).html($('p', lastSelected).html())
        $(selectedBtnR3).addClass('answered')
      } else {
        $('p', lastSelected).html($('p', selectedBtnR3).html())
        $(lastSelected).addClass('answered')
      }
      if (round3part==2 && $('.answer-button:not(".answered")', '.round-3-2').length == 0) {
        $('#round3BadAnswersCount').html(round3BadAnswersCount)
        if (round3CheckedAnswer) { ans = 'TAK' } else { ans = 'NIE' }
        $('#round3CheckedAnswer').html(ans)
        $('#round32EndedModal').modal('show')
      } else {
        if (round3part==1 && $('.answer-button:not(".answered")', '.round-3-1').length == 0) {
          $('#round31EndedModal').modal('show')
        }
      }
    } else {
      goodAnswerAudio.load()
      badAnswerAudio.play()
      round3BadAnswersCount += 1
    }
    $('.correct-answer-2', '.round-3').removeClass('correct-answer-2')
    selectedBtnR3 = null
  }

  $('.check-answer', '.round-3').on('click', function(event) {
    event.preventDefault()
    round3CheckedAnswer = true
    $('p', '.round-3 .answer-button').addClass('hidden')
    $('.proper', '.round-3 .answer-button').removeClass('hidden').addClass('hidden', 500).removeClass('hidden', 500).addClass('hidden', 500).removeClass('hidden', 500).addClass('hidden', 500)
    setTimeout(function() {
      $('p', '.round-3 .answer-button').removeClass('hidden')
    }, 2500)

  })


});
