$( document ).ready(function() {

  var goodAnswerAudio = new Audio('../files/audio/ogolne/brawo.wav');
  var badAnswerAudio = new Audio('../files/audio/ogolne/sprobuj.wav');
  var questionAudio = new Audio('../files/audio/czas/dopasuj/polecenie.wav');

  var goodAnswers = {
    1: [1,3,6],
    2: [4,8,12],
    3: [2,10,11],
    4: [5,7,9]
  }
  var badAnswersCount = 0

  $('.read-question').on('click', function(event){
    event.preventDefault()
    questionAudio.play()
  })

  $('.answer-button', '.people').on('click', function(event) {
    event.preventDefault()
    event.stopPropagation()
    if( $('.thumbnail', this).hasClass('selected') ){
      $('.thumbnail', this).removeClass('selected')
    } else {
      $('.thumbnail', '.people').removeClass('selected')
      $('.thumbnail', this).addClass('selected')
    }
    applyAnswerIfShould()
  })

  $('.answer-button', '.possible-answers').not('.used').on('click', function(event) {
    event.preventDefault()
    event.stopPropagation()
    if( !$(this).hasClass('used') ){
      if( $('.thumbnail', this).hasClass('selected') ){
        $('.thumbnail', this).removeClass('selected')
      } else {
        $('.thumbnail', '.possible-answers').removeClass('selected')
        $('.thumbnail', this).addClass('selected')
      }
      applyAnswerIfShould()
    }
  })

  applyAnswerIfShould = function() {
    selectedPerson = $('.selected', '.people')
    selectedAnswer = $('.selected', '.possible-answers')
    if( selectedPerson.length > 0 && selectedAnswer.length > 0 ) {
      $('.answers', $(selectedPerson).parents('.answer-container')).append('<div class="col-md-6 col-sm-6 col-xs-6 answered" data-answer-no="' + $(selectedAnswer).parents('.answer-button').attr('data-answer-no') + '"><div class="dummy"></div><div class="thumbnail"><img class="button-image" src="' + $('img', selectedAnswer).attr('src') + '" style="max-height: 100%;"></div></div>')
      $(selectedAnswer).parents('.answer-button').addClass('used').addClass('disabled')
      $(selectedAnswer).removeClass('selected')
      $(selectedPerson).removeClass('selected')
      checkIfEnded()
    }
  }

  checkIfEnded = function() {
    if( $('.answer-button', '.possible-answers').not('.used').length == 0 ){
      var answersAreOK = true
      $('.answer-container', '.people').each(function(index){
        answerIndex = parseInt($(this).attr('data-answer-no'))
        console.log (answerIndex)
        if ($('.answered', this).length != 3) {
          console.log ($('.answered', this).length)
          answersAreOK = false
        } else {
          $('.answered', this).each(function(index){
            console.log (parseInt($(this).attr('data-answer-no')))
            console.log (goodAnswers[answerIndex])
            if( goodAnswers[answerIndex].indexOf(parseInt($(this).attr('data-answer-no'))) == -1) {
              answersAreOK = false
            }
          })
        }
      })
      if( answersAreOK ) {
        badAnswerAudio.load()
        goodAnswerAudio.play()
        $('.bad-answer-count', '#allEndedModal').html(badAnswersCount)
        $('#allEndedModal').modal('show')
      } else {
        goodAnswerAudio.load()
        badAnswerAudio.play()
        badAnswersCount += 1
        $('#modalWrongAnswer').modal('show')
      }
    }
  }

  $('.clear').on('click', function(event){
    event.preventDefault()
    $('#modalWrongAnswer').modal('hide')
    $('.answers').html('')
    $('.used').removeClass('used').removeClass('disabled')
  })

  showFinishModal = function() {
    var tableBodyHtml = '';
    for (var i=0; i<3; i++) {
      tableBodyHtml += '<tr><td>' + (i+1) + '</td><td>'
      tableBodyHtml += badAnswers[i].length
      tableBodyHtml += '</td><td>'
      if(checkedAnswers[i]){
        tableBodyHtml += 'TAK'
      } else {
        tableBodyHtml += 'NIE'
      }
      tableBodyHtml += '</td>'
    }
    $('tbody', '#allEndedModal').html(tableBodyHtml)
    $('#allEndedModal').modal('show')
  }

  showProperModal = function() {
    allCurrentAnsweredProperly = true;
    $('.picture', '.question-' + questionNumber).each(function(index){
      if( $(this).hasClass('is-correct') && !($(this).hasClass('correct-answer')) ){
        allCurrentAnsweredProperly = false;
      }
    })
    if( allCurrentAnsweredProperly ) {
      allAnsweredProperly = true;
      $('.picture.is-correct', '.possible-answers').each(function(index){
        if( !($(this).hasClass('correct-answer')) ){
          allAnsweredProperly = false;
        }
      })
      if( allAnsweredProperly ) {
        showFinishModal()
      } else {
        $('#modalCorrectAnswer').modal('show')
      }
    }
  }

})