$( document ).ready(function() {

  var goodAnswerAudio = new Audio('../files/audio/ogolne/brawo.wav');
  var badAnswerAudio = new Audio('../files/audio/ogolne/sprobuj.wav');
  var questionAudios = [
    new Audio('../files/audio/czas/dopasuj/polecenie_1.wav'),
    new Audio('../files/audio/czas/dopasuj/polecenie_2.wav')
  ];

  var badAnswers = [0, 0]
  var goodAnswers = [ false, false ]
  var checkedAnswers = [ false, false ]

  questionNumber = 1
  noOfQuestions = 2

  var questionTexts = [
    'Uporządkuj na osi czasu czynności wykonywane w ciągu dnia.',
    'Uporządkuj wydarzenia na osi czasu.'
  ]

  var selectedItem = null

  $('.read-question').on('click', function(event){
    event.preventDefault()
    questionAudios[questionNumber-1].play()
  })

  $('.next-question').on('click', function(event){
    event.preventDefault();
    questionNumber+=1;
    prepareQuestionData()
  })

  $('.prev-question').on('click', function(event){
    event.preventDefault();
    questionNumber-=1;
    prepareQuestionData()
  })

  handlePartAnswer = function(selectedItem1, selectedItem2) {
    if (selectedItem1 && selectedItem2 && selectedItem1 != selectedItem2){
      if( $(selectedItem1).attr('data-answer') == $(selectedItem2).attr('data-answer') ) {
        $('.question',  '.round-' + questionNumber + ' .box-arrow[data-answer=' + $(selectedItem1).attr('data-answer') + ']').addClass('hidden')
        $('.button-image', '.round-' + questionNumber + ' .box-arrow[data-answer=' + $(selectedItem1).attr('data-answer') + ']').removeClass('hidden')
        $('p', '.round-' + questionNumber + ' .box-arrow[data-answer=' + $(selectedItem1).attr('data-answer') + ']').removeClass('hidden')
        badAnswerAudio.load()
        goodAnswerAudio.play()
      } else {
        goodAnswerAudio.load()
        badAnswers[questionNumber-1] += 1
        badAnswerAudio.play()
      }
      $(selectedItem1).removeClass('correct-answer-2')
      $(selectedItem2).removeClass('correct-answer-2')
      selectedItem = null
      if ($('.hidden:not(.question)', '.round-' + questionNumber + ' .box-arrow').length == 0)
        questionAnsweredProperly()

    } else {
      if (!selectedItem1 || selectedItem1 != selectedItem2){
        selectedItem = selectedItem2
      } else {
        selectedItem = null
      }
    }

  }

  $('.box-arrow:not(.time)').on('click', function(event){
    event.preventDefault();
    $(this).addClass('correct-answer-2')
    if (selectedItem == this) {
      selectedItem = null
      $(this).removeClass('correct-answer-2')
    } else {
      if( selectedItem && $(selectedItem).hasClass('box-arrow') ) {
        $(selectedItem).removeClass('correct-answer-2')
      } else {
        handlePartAnswer(selectedItem, this)
      }
    }
  })

  $('.answer-button').on('click', function(event){
    event.preventDefault();
    $(this).addClass('correct-answer-2')
    if (selectedItem == this) {
      selectedItem = null
      $(this).removeClass('correct-answer-2')
    } else {
      if( selectedItem && $(selectedItem).hasClass('answer-button') ) {
        $(selectedItem).removeClass('correct-answer-2')
      } else {
        handlePartAnswer(selectedItem, this)
      }
    }
  })

  $('.answer-button', '.answers').on('click', function(event) {
    event.preventDefault()
    img = $('img', this).attr('src')
    answerNo = parseInt($(this).attr('data-answer-no'))
    $('.selected-images').append('<div class="image-container" data-answer-no="' + answerNo + '"><img class="button-image" src="' + img + '"></div>&nbsp;')
    if($('img', '.selected-images').length >= properAnswers[questionNumber-1].length){
      checkYourAnswer()
    }
  })

  $('.clear').on('click', function(event){
    event.preventDefault()
    $('#modalWrongAnswer').modal('hide')
    $('.selected-images').html('')
  })

  $('.check-answer').on('click', function(event){
    event.preventDefault();
    event.stopImmediatePropagation();
    console.log ('haha')

    $('.question', '.round-' + questionNumber + ' .box-arrow:not(.time)').addClass('hidden')
    $('.proper-answer.hidden', '.round-' + questionNumber).addClass('will-hide')
    $('.proper-answer', '.round-' + questionNumber).removeClass('hidden', 500).addClass('hidden', 500).removeClass('hidden', 500).addClass('hidden', 500).removeClass('hidden', 500).addClass('hidden', 500).removeClass('hidden', 500)
    setTimeout(function() {
      $('.proper-answer.will-hide', '.round-' + questionNumber).addClass('hidden').removeClass('will-hide')
      $('.question', '.round-' + questionNumber + ' .box-arrow:not(.time)').removeClass('hidden')
    }, 4000)
  })

  questionAnsweredProperly = function() {
    if (questionNumber == noOfQuestions) {
      allAnsweredProperly()
    } else {
      $('#modalCorrectAnswer').modal('show')
    }
  }

  var allAnsweredProperly = function() {
    var tableBodyHtml = '';
    for (var i=0; i<noOfQuestions; i++) {
      tableBodyHtml += '<tr><td>' + (i+1) + '</td><td>'
      tableBodyHtml += badAnswers[i]
      tableBodyHtml += '</td><td>'
      if(checkedAnswers[i]){
        tableBodyHtml += 'TAK'
      } else {
        tableBodyHtml += 'NIE'
      }
      tableBodyHtml += '</td>'
    }
    $('tbody', '#allEndedModal').html(tableBodyHtml)
    $('#allEndedModal').modal('show')
  }

  var prepareQuestionData = function() {
    $('.question-number').html(questionNumber)
    if(noOfQuestions == questionNumber){
      $('.next-question').addClass('disabled');
    } else {
      $('.next-question').removeClass('disabled');
    }
    if(1 == questionNumber){
      $('.prev-question').addClass('disabled');
    } else {
      $('.prev-question').removeClass('disabled');
    }
    $('#modalCorrectAnswer').modal('hide')
    $('.question-text').html(questionTexts[questionNumber-1])
    $('.round-data').addClass('hidden')
    $('.round-' + questionNumber).removeClass('hidden')
    selectedItem = null

  }

  prepareQuestionData()
  $('.no-of-questions').html(noOfQuestions)

});