$( document ).ready(function() {

  var goodAnswerAudio = new Audio('../files/audio/ogolne/brawo.wav');
  var badAnswerAudio = new Audio('../files/audio/ogolne/sprobuj.wav');
  var questionAudio = new Audio('../files/audio/czas/pamiec/polecenie_roznice.wav');


  var questionNumber = 1
  var noOfQuestions = 3
  var wrongAnswersCounts = [0, 0, 0]
  var answeredProperly = [false, false, false]
  var checkedAnswers = [false, false, false]
  var interval = null
  var timeout = null

  $('.check-answer').on('click', function(event){
    event.preventDefault()
    if ($(this).hasClass('blocked')) {
      return
    }
    $('.area-inside', '.question-areas.area-' + questionNumber).addClass('visible', 400).removeClass('visible', 400).addClass('visible', 400).removeClass('visible', 400).addClass('visible', 400).removeClass('visible', 400)
    $('.check-my-answer').click()
    checkedAnswers[questionNumber-1] = true
  })

  $('.read-question').on('click', function(event){
    event.preventDefault()
    questionAudio.play()
  })

  $('.next-question').on('click', function(event){
    event.preventDefault();
    if ($(this).hasClass('blocked')) {
      return
    }
    questionNumber+=1;
    if(noOfQuestions == questionNumber){
      $('.next-question').addClass('disabled');
    };
    $('.prev-question').removeClass('disabled');
    $('.question-number').html(questionNumber);

    loadQuestionData()
  })

  $('.prev-question').on('click', function(event){
    event.preventDefault();
    if ($(this).hasClass('blocked')) {
      return
    }
    questionNumber-=1;
    if(1 == questionNumber){
      $('.prev-question').addClass('disabled');
    };
    $('.next-question').removeClass('disabled');
    $('.question-number').html(questionNumber);

    loadQuestionData()
  })

  loadQuestionData = function() {
    clearInterval(interval)
    clearTimeout(timeout)
    $('.question-areas').hide()

    if (answeredProperly[questionNumber-1] == true) {
      $('.roznica').show()
      $('.roznica').attr('src', '../files/img/czas/pamiec/roznice-' + (questionNumber+1) + '-1.png')
      $('.question-areas.area-' + questionNumber).show()
      $('.roznica').removeClass('no-handle')
    } else {
      $('.roznica').hide()
      $('.start-absolute').show()
      $('.roznica').addClass('no-handle')
    }
    $('#modalCorrectAnswer').modal('hide')
  }

  $('.btn-policz.start').on('click', function(event){
    event.preventDefault();
    $('.next-question').addClass('blocked')
    $('.prev-question').addClass('blocked')
    $('.check-answer').addClass('blocked')
    $('.roznica').attr('src', '../files/img/czas/pamiec/roznice-' + questionNumber + '-1.png')
    $('.start-absolute').hide()
    $('.roznica').show(300)
    timeout = setTimeout(function(){
      // $('.roznica').hide()
      $('.roznica').attr('src', '../files/img/czas/pamiec/roznice-' + questionNumber + '-2.png')
      $('.question-areas.area-' + questionNumber).show()
      $('.start-absolute').hide()
      $('.roznica').removeClass('no-handle')
      // $('.roznica').show()
      clearInterval(interval)
      $('i', '.btn-policz.start').addClass('fa-play').text('')
      $('.next-question').removeClass('blocked')
      $('.prev-question').removeClass('blocked')
      $('.check-answer').removeClass('blocked')
    }, 5000)
    var i = 5
    $('i', '.btn-policz.start').removeClass('fa-play').text(i)
    interval = setInterval(function() {
      i -= 1
      $('i', '.btn-policz.start').removeClass('fa-play').text(i)
    }, 1000)
  })

  $('.btn-policz.stop').on('click', function(event){
    event.preventDefault()
    clearInterval(interval)
    clearTimeout(timeout)
    $('i', '.btn-policz.start').addClass('fa-play').text('')
    $('.roznica').hide(300)
    $('.roznica').addClass('no-handle')
    $('question-areas').hide()
  })

  $('.diff-area').on('click', function(event){
    event.stopPropagation()
    event.preventDefault()
    answeredProperly[questionNumber-1] = true
    $('.correct-answer', '.question-areas.area-' + questionNumber).removeClass('correct-answer')
    $('.wrong-answer').removeClass('wrong-answer')
    $(this).addClass('correct-answer correct-answer-2')
    $('.diff-area', $(this).parents('.question-areas')).addClass('correct-answer-2')
    badAnswerAudio.load()
    goodAnswerAudio.play()
    showProperModal()
  })

  $('.roznica').on('click', function(event){
    event.preventDefault()
    if (!$(this).hasClass('no-handle')) {
      $('.correct-answer', '.question-areas.area-' + questionNumber).removeClass('correct-answer')
      $('.wrong-answer-container').addClass('wrong-answer')
      goodAnswerAudio.load()
      badAnswerAudio.play()
      wrongAnswersCounts[questionNumber-1] += 1
    }
  })

  showFinishModal = function() {
    var tableBodyHtml = '';
    for (var i=0; i<noOfQuestions; i++) {
      tableBodyHtml += '<tr><td>' + (i+1) + '</td><td>'
      tableBodyHtml += wrongAnswersCounts[i]
      tableBodyHtml += '</td><td>'
      if(checkedAnswers[i]){
        tableBodyHtml += 'TAK'
      } else {
        tableBodyHtml += 'NIE'
      }
      tableBodyHtml += '</td>'
    }
    $('tbody', '#countEndedModal').html(tableBodyHtml)
    $('#countEndedModal').modal('show')
  }

  showProperModal = function() {
    if ($('.correct-answer-2', '.area-' + questionNumber).length == $('.diff-area', '.area-' + questionNumber).length) {
      allAnsweredProperly = (answeredProperly.indexOf(false) == -1);
      if( allAnsweredProperly ) {
        showFinishModal()
      } else {
        $('#modalCorrectAnswer').modal('show')
      }
    }
  }

  $('.question-number').html(questionNumber);
  $('.question-sum').html(noOfQuestions);
  $('.question-text').html('Znajdź różnice');
  loadQuestionData()

})