$( document ).ready(function() {

// DATA
  var goodAnswerAudio = new Audio('../files/audio/ogolne/brawo.wav');
  var badAnswerAudio = new Audio('../files/audio/ogolne/sprobuj.wav');
  var questionAudio = new Audio('../files/audio/zawody/quiz/1/polecenie_1.wav');

  var questionNumber = 1;
  var noOfQuestions = 12;

  var questionTypes = [
    'image',
    'image',
    'image',
    'image',
    'image',
    'image',
    'image',
    'image',
    'image',
    'image',
    'image',
    'image'
  ]

  var questions = {
    1: "Którego z tych przedmiotów lekarz potrzebuje do pracy?",
    2: "Którego z tych przedmiotów sędzia potrzebuje do pracy?",
    3: "Którego z tych przedmiotów fryzjer nie potrzebuje do pracy?",
    4: "Którego z tych przedmiotów krawiec potrzebuje do pracy?",
    5: "Którego z tych przedmiotów policjant nie potrzebuje do pracy?",
    6: "Którego z tych przedmiotów piekarz nie potrzebuje do pracy?",
    7: "Którego z tych przedmiotów murarz potrzebuje do pracy?",
    8: "Którego z tych przedmiotów szewc potrzebuje do pracy?",
    9: "Którego z tych przedmiotów muzyk nie potrzebuje do pracy?",
    10: "Którego z tych przedmiotów piłkarz nie potrzebuje do pracy?",
    11: "Którego z tych przedmiotów weterynarz potrzebuje do pracy?",
    12: "Którego z tych przedmiotów nauczyciel nie potrzebuje do pracy?"
  }

// 1. Którego z tych przedmiotów lekarz potrzebuje do pracy?
// Obrazki: stetoskop, grzebień, nóż kuchenny
// 2. Którego z tych przedmiotów sędzia potrzebuje do pracy?
// Obrazki: kajdanki, młotek sędziowski, komputer
// 3. Którego z tych przedmiotów fryzjer nie potrzebuje do pracy?
// Obrazki: nożyczki, grzebień, pędzel malarski
// 4. Którego z tych przedmiotów krawiec potrzebuje do pracy?
// Obrazki: pędzel i paletę, buty, maszyna do szycia
// 5. Którego z tych przedmiotów policjant nie potrzebuje do pracy?
// Obrazki: młotek sędziowski, lizak, kajdanki
// 6. Którego z tych przedmiotów piekarz nie potrzebuje do pracy?
// Obrazki: piec, jajka, kalafior
// 7. Którego z tych przedmiotów murarz potrzebuje do pracy?
// Obrazki: paca, piłka , nożyczki
// 8. Którego z tych przedmiotów szewc potrzebuje do pracy?
// Obrazki: podeszwa, motek nitki, materiał
// 9. Którego z tych przedmiotów muzyk nie potrzebuje do pracy?
// Obrazki: mikrofon, ciasto, gitara
// 10. Którego z tych przedmiotów piłkarz nie potrzebuje do pracy?
// Obrazki: piłka, buty korki, hantle
// 11. Którego z tych przedmiotów weterynarz potrzebuje do pracy?
// Obrazki: strzykawki, mikser, widelec
// 12. Którego z tych przedmiotów nauczyciel nie potrzebuje do pracy?
// Obrazki: tablica i kreda, sala lekcyjna, suszarka do włosów

  var answers = {
    1: {
      0: ['stetoskop', 'grzebień', 'nóż kuchenny'],
      1: ['stetoskop.png', 'grzebien.png', 'noz_kuchenny.png'],
      2: ['stetoskop.wav', 'grzebien.wav', 'noz_kuchenny.wav']
    },
    2: {
      0: ['kajdanki', 'młotek sędziowski', 'komputer'],
      1: ['kajdanki.png', 'mlotek-sedziowski.png', 'komputer.png'],
      2: ['kajdanki.wav', 'mlotek_sedziowski.wav', 'komputer.wav']
    },
    3: {
      0: ['kajdanki', 'młotek sędziowski', 'komputer'],
      1: ['nozyczki.png', 'grzebien.png', 'pedzel-malarski.png'],
      2: ['nozyczki.wav', 'grzebien.wav', 'pedzel_malarski.wav']
    },
    4: {
      0: ['pędzel i paletę', 'buty', 'maszyna do szycia'],
      1: ['pedzel-i-paleta.png', 'buty.png', 'maszyna-do-szycia.png'],
      2: ['pedzel_paleta.wav', 'buty.wav', 'maszyna_do_szycia.wav']
    },
    5: {
      0: ['młotek sędziowski', 'lizak', 'kajdanki'],
      1: ['mlotek-sedziowski.png', 'lizak-policyjny.png', 'kajdanki.png'],
      2: ['mlotek_sedziowski.wav', 'lizak.wav', 'kajdanki.wav']
    },
    6: {
      0: ['piec', 'jajka', 'kalafior'],
      1: ['piec.png', 'jajka.png', 'kalafior.png'],
      2: ['piec.wav', 'jajka.wav', 'kalafior.wav']
    },
    7: {
      0: ['paca', 'piłka', 'nożyczki'],
      1: ['paca.png', 'pilka.png', 'nozyczki.png'],
      2: ['paca.wav', 'pilka.wav', 'nozyczki.wav']
    },
    8: {
      0: ['podeszwa', 'motek nitki', 'materiał'],
      1: ['podeszwa.png', 'motek-nitki.png', 'material.png'],
      2: ['podeszwa.wav', 'motek_nitki.wav', 'material.wav']
    },
    9: {
      0: ['mikrofon', 'ciasto', 'gitara'],
      1: ['mikrofon.png', 'ciasto.png', 'gitara.png'],
      2: ['mikrofon.wav', 'ciasto.wav', 'gitara.wav']
    },
    10: {
      0: ['piłka', 'buty korki', 'hantle'],
      1: ['pilka.png', 'buty-korki.png', 'hantle.png'],
      2: ['pilka.wav', 'buty_korki.wav', 'hantle.wav']
    },
    11: {
      0: ['strzykawki', 'mikser', 'widelec'],
      1: ['strzykawki.png', 'mikser.png', 'widelec.png'],
      2: ['strzykawki.wav', 'mikser.wav', 'widelec.wav']
    },
    12: {
      0: ['tablica i kreda', 'sala lekcyjna', 'suszarka do włosów'],
      1: ['tablica-i-kreda.png', 'sala-lekcyjna.png', 'suszarka.png'],
      2: ['tablica_kreda.wav', 'sala_lekcyjna.wav', 'suszarka.wav']
    }

  }

  var answerAudios = []

  var correctAnswerIndexes = {
    1: [1],
    2: [2],
    3: [3],
    4: [3],
    5: [1],
    6: [3],
    7: [1],
    8: [1],
    9: [2],
    10: [3],
    11: [1],
    12: [3]
  }

  var questionsFinished = []

  var answered = {
    1: [],
    2: [],
    3: [],
    4: [],
    5: [],
    6: [],
    7: [],
    8: [],
    9: [],
    10: [],
    11: [],
    12: []
  }

// MAIN LOGIC

  $( '.question-number' ).html( questionNumber );
  $( '.question-sum' ).html( noOfQuestions );
  $( '.question-text' ).html( questions[questionNumber] );

  $( 'body' ).on('click', '.next-question', function(event){
    event.preventDefault()
    if(questionNumber < noOfQuestions){
      questionNumber++;
      setPageDataForQuestion()
    }
    $('#modalCorrectAnswer').modal('hide')
  });

  $( '.prev-question' ).on('click', function(event){
    event.preventDefault()
    if(questionNumber > 1){
      questionNumber--;
      setPageDataForQuestion()
    }
  });

  $('.answer-audio').on('click', function(event){
    event.preventDefault();
    event.stopPropagation();
    var answerNo = parseInt($(this).attr('data-answer-no'));
    answerAudios[answerNo-1].play();
  })

  $( '.answer-button' ).on('click', function(event) {
    event.preventDefault()
    $('.wrong-answer').removeClass('wrong-answer')
    $('.last-answer').removeClass('last-answer')
    $(this).addClass('last-answer')
    var answerNo = parseInt($(this).attr('data-answer-no'))
    answered[questionNumber].push(answerNo)
    if(correctAnswerIndexes[questionNumber].indexOf(answerNo) !== -1) {
      $(this).addClass('correct-answer')
      badAnswerAudio.load()
      goodAnswerAudio.play()

      if(_.uniq(_.intersection(correctAnswerIndexes[questionNumber], answered[questionNumber])).length == correctAnswerIndexes[questionNumber].length) {

        //all correct answers selected
        if(questionsFinished.indexOf(questionNumber) == -1){
          questionsFinished.push(questionNumber)
        }
        if(!(questionsFinished.length === noOfQuestions)){
          if(questionNumber < noOfQuestions){
            showCorrectAnswerModal()
          }
        } else {
          fillEndModalAndShowIt()
        }

      }
    } else {
      goodAnswerAudio.load()
      badAnswerAudio.play()
      $(this).addClass('wrong-answer')
    }
  });

  $('.read-question').on('click', function(event) {
    event.preventDefault()
    questionAudio.play()
  })

  $('.check-answer').on('click', function(event) {
    event.preventDefault()
    $('.is-correct').toggleClass('correct-answer', 500).delay(500).toggleClass('correct-answer', 500).delay(500).toggleClass('correct-answer', 500).delay(500).toggleClass('correct-answer', 500).delay(500).toggleClass('correct-answer', 500).delay(500).toggleClass('correct-answer', 500)
  })

  var setPageDataForQuestion = function() {
    $( '.question-number' ).html(questionNumber );
    $( '.question-text' ).html(questions[questionNumber] );
    $( '.question-image').html('')

    questionAudio = new Audio('../files/audio/zawody/quiz/' + questionNumber + '/polecenie_' + questionNumber + '.wav');

    if(questionTypes[questionNumber-1] === 'image'){
      setAnswerButtonsForImage()
    } else if(questionTypes[questionNumber-1] === 'text') {
      setAnswerButtonsForText()
    } else if(questionTypes[questionNumber-1] === 'text-with-image') {
      setAnswerButtonsForText()
      setImageForQuestion()
    }
    setAnswerAudiosButtons()
    if(questionNumber == noOfQuestions) {
      $( '.next-question' ).addClass('disabled')
    } else {
      $( '.next-question' ).removeClass('disabled');
    };
    if(questionNumber == 1) {
      $( '.prev-question' ).addClass('disabled');
    } else {
      $( '.prev-question' ).removeClass('disabled');
    }
    $('.wrong-answer').removeClass('wrong-answer')
    $('.last-answer').removeClass('last-answer')
  }

  var setAnswerAudiosButtons = function() {
    for (i = 0; i < 7; i++) {
      button = $('.answer-audio.aa-' + (i+1), '.answer-audios')
      if(answers[questionNumber][0][i]){
        $(button).removeClass('hide')
      } else {
        $(button).addClass('hide')
      }
    }
  }

  var setAnswerButtonsForText = function() {
    $('.answer-buttons-img').hide();
    $('.answer-buttons-txt').show();
    $('.answer-button').removeClass('is-correct')

    for (i = 0; i < 7; i++) {
      button = $('.answer-button.ab-' + (i+1), '.answer-buttons-txt')

      if(correctAnswerIndexes[questionNumber].indexOf(i+1) != -1){
        $(button).addClass('is-correct')
      }

      if(answers[questionNumber][0][i]){
        $(button).removeClass('hide')
        if(answered[questionNumber].indexOf(i+1) !== -1 && correctAnswerIndexes[questionNumber].indexOf(i+1) !== -1) {
          $(button).addClass('correct-answer')
        } else {
          $(button).removeClass('correct-answer')
        }
        $( '.text', $('a', button) ).html(answers[questionNumber][0][i]);
      } else {
        $(button).addClass('hide')
      }
    }
    setAnswerAudios(1)
  }

  var setImageForQuestion = function () {
    $( '.question-image').html('<img src="../files/img/zawody/quiz/' + answers[questionNumber][2] + '">')
  }

  var setAnswerButtonsForImage = function() {
    $('.answer-buttons-txt').hide();
    $('.answer-buttons-img').show();
    $('.answer-button').removeClass('is-correct')
    for (i = 0; i < 7; i++) {
      button = $('.answer-button.ab-' + (i+1), '.answer-buttons-img')

      if(correctAnswerIndexes[questionNumber].indexOf(i+1) != -1){
        $(button).addClass('is-correct')
      }

      if(answers[questionNumber][1][i]){
        $(button).removeClass('hide')
        if(answered[questionNumber].indexOf(i+1) !== -1 && correctAnswerIndexes[questionNumber].indexOf(i+1) !== -1) {
          $(button).addClass('correct-answer')
        } else {
          $(button).removeClass('correct-answer')
        }
        $( '.button-image', button ).attr('src', '../files/img/zawody/quiz/' + answers[questionNumber][1][i]);
        $( '.button-footer', button ).text(answers[questionNumber][0][i]);
      } else {
        $(button).addClass('hide')
      }
    }
    setAnswerAudios(2)
  }

  var setAnswerAudios = function(index){
    answerAudios = []
    for (i = 0; i < answers[questionNumber][index].length; i++) {
      answerAudios.push(new Audio('../files/audio/zawody/quiz/' + questionNumber + '/' + answers[questionNumber][index][i]))
    }
  }

  var fillEndModalAndShowIt = function() {
    var tableBodyHtml = '';
    var i = 1;
    _.each(answered, function(yourAnswers){
      var yourAnswerTexts = []
      _.each(yourAnswers, function(answer) {
        if(correctAnswerIndexes[i].indexOf(answer) != -1){
          yourAnswerTexts.push('<span class="text-success">' + answers[i][0][answer-1] + '</span>')
        } else {
          yourAnswerTexts.push('<span class="text-danger">' + answers[i][0][answer-1] + '</span>')
        }
      })
      tableBodyHtml+='<tr><td>' + i + '</td><td>' + yourAnswers.length + '</td><td>' + _.difference(yourAnswers, correctAnswerIndexes[i]).length + '</td><td>' + yourAnswerTexts.join(', ') + '</td></tr>'
      i+=1;
    })
    $('tbody', '#quizEndedModal').html(tableBodyHtml)
    $('#quizEndedModal').modal('show')
  }

  var showCorrectAnswerModal = function(){
    $('#modalCorrectAnswer').modal('show')
  }



  setPageDataForQuestion()

});
