$( document ).ready(function() {

  var goodAnswerAudio = new Audio('../files/audio/ogolne/brawo.wav');
  var badAnswerAudio = new Audio('../files/audio/ogolne/sprobuj.wav');
  var questionAudio = new Audio('../files/audio/zawody/gra/polecenie.wav');

  var badAnswers = [0, 0, 0, 0, 0, 0]
  var checkedAnswers = [ false, false, false, false, false, false ]
  var properAnswers = [
    ['pie', 'karz'],
    ['le', 'karz'],
    ['kra', 'wiec'],
    ['pił', 'karz'],
    ['fry', 'zjer'],
    ['mu', 'rarz']
  ]
  var answerIndex = 0

  questionNumber = 1
  noOfQuestions = 6


  $('.read-question').on('click', function(event){
    event.preventDefault()
    questionAudio.play()
  })

  $('.next-question').on('click', function(event){
    event.preventDefault();
    questionNumber+=1;
    prepareQuestionData()
  })

  $('.prev-question').on('click', function(event){
    event.preventDefault();
    questionNumber-=1;
    prepareQuestionData()
  })

  $('.answer-button', '.answers').on('click', function(event) {
    if( properAnswers[questionNumber-1][answerIndex] == $('.thumbnail', this).text() ) {
      $('.answer-' + answerIndex).text($('.thumbnail', this).text())
      badAnswerAudio.load()
      goodAnswerAudio.play()
      if ( answerIndex == 0) {
        answerIndex += 1
      } else {
        if ( questionNumber == noOfQuestions ) {
          showEndModal()
        } else {
          $('#modalCorrectAnswer').modal('show')
        }
      }
    } else {
      goodAnswerAudio.load()
      badAnswerAudio.play()
      badAnswers[questionNumber-1] += 1
    }
  })

  $('.check-answer').on('click', function(event){
    event.preventDefault();
    checkedAnswers[questionNumber-1] = true
    $('.answer-data').addClass('hidden')
    $('.qa' + questionNumber).removeClass('hidden', 500).addClass('hidden', 500).removeClass('hidden', 500).addClass('hidden', 500).removeClass('hidden', 500).addClass('hidden', 500, function() {
      $('.answer-data').removeClass('hidden', 500)
    })

  })

  showEndModal = function () {
    var tableBodyHtml = '';
    for (var i=0; i<noOfQuestions; i++) {
      tableBodyHtml += '<tr><td>' + (i+1) + '</td><td>' + badAnswers[i] + '</td><td>'
      if(checkedAnswers[i]){
        tableBodyHtml += 'TAK'
      } else {
        tableBodyHtml += 'NIE'
      }
      tableBodyHtml += '</td></tr>'
    }
    $('tbody', '#allEndedModal').html(tableBodyHtml)
    $('#allEndedModal').modal('show')
  }

  var prepareQuestionData = function() {
    $('.question-number').html(questionNumber)
    if(noOfQuestions == questionNumber){
      $('.next-question').addClass('disabled');
    } else {
      $('.next-question').removeClass('disabled');
    }
    if(1 == questionNumber){
      $('.prev-question').addClass('disabled');
    } else {
      $('.prev-question').removeClass('disabled');
    }
    $('#modalCorrectAnswer').modal('hide')
    $('.question-data:not(.q' + questionNumber + ')').addClass('hidden')
    $('.q' + questionNumber).removeClass('hidden')
    $('.answer-data').text('?')
    answerIndex = 0
  }

  prepareQuestionData()
  $('.no-of-questions').html(noOfQuestions)

});