$( document ).ready(function() {

  var goodAnswerAudio = new Audio('../files/audio/ogolne/brawo.wav');
  var badAnswerAudio = new Audio('../files/audio/ogolne/sprobuj.wav');
  var questionAudio = new Audio('../files/audio/las/pamiec/polecenie.wav');

  questionNumber = 1
  noOfQuestions = 2

  var intervalCounter = null
  var startedTimeout = null
  var startBtnHtml = ''
  var badAnswers = [0, 0]
  var checkedAnswers = [false, false]

  $('.read-question').on('click', function(event){
    event.preventDefault()
    questionAudio.play()
  })

  $('.next-question').on('click', function(event){
    event.preventDefault();
    questionNumber+=1;
    prepareQuestionData()
  })

  $('.prev-question').on('click', function(event){
    event.preventDefault();
    questionNumber-=1;
    prepareQuestionData()
  })

  $('.check-answer').on('click', function(event) {
    event.preventDefault();
    checkedAnswers[questionNumber-1] = true
    $('.leaf').addClass('show-proper', 1000).delay(700).removeClass('show-proper', 1000)
  })

  var possibleClasses = ['bottom-left-4', 'top-right-3', 'bottom-right-3', 'top-left-3', 'bottom-right-4', 'top-left-4', 'top-right-4', 'bottom-left-3']



  $('.start').on('click', function(event){
    event.preventDefault()
    var nqd = $('.next-question').hasClass('disabled')
    var pqd = $('.prev-question').hasClass('disabled')

    $('.next-question').addClass('disabled')
    $('.prev-question').addClass('disabled')

    container = $('.question-' + questionNumber)
    _.each($('.leaf', container), function(element) {
      $(element).removeClass(possibleClasses.join(' ') + ' selected')
    })

    $('.container-tree').removeClass('hidden')

    var i = 5
    startBtnHtml = $('.start').html()
    $('.start').html('<div class="txt"></div>')
    $('.txt', '.start').text(i)
    intervalCounter = setInterval(function(){
      i-=1;
      $('.txt', '.start').text(i)
      checkIfShouldStopCounter(i);
    }, 1000)
    var checkIfShouldStopCounter = function(i){
      if(i==0){
        window.clearInterval(intervalCounter);
        $('.start').html(startBtnHtml)
      }
    }

    startedTimeout = setTimeout(function(){
      if(pqd == false){
        $('.prev-question').removeClass('disabled')
      }
      if(nqd == false){
        $('.next-question').removeClass('disabled')
      }
      shuffleLeafs()
    }, 5000)
  })

  $('.stop').on('click', function(event){
    event.preventDefault()
    $('.container-tree').addClass('hidden')
    if (intervalCounter) {
      clearInterval(intervalCounter);
      $('.start').html(startBtnHtml)
    }
  })

  shuffleLeafs = function () {
    shuffledClasses = _.compact(possibleClasses)
    container = $('.question-' + questionNumber)
    _.each($('.leaf', container), function(element) {
      $(element).addClass(shuffledClasses.shift())
    })
  }

  $('.leaf-handler').on('click', function(event) {
    event.preventDefault()
    $('.leaf').removeClass('selected')
    $('.leaf', this).addClass('selected')
    $('.leaf-container-handler').addClass('activated')
  })

  $('.leaf-container-handler').on('click', function(event) {
    event.preventDefault()
    if ($(this).hasClass('activated')) {
      if ( $(this).hasClass($('.leaf.selected').attr('data-container')) ) {
        goodAnswerAudio.play()
        $('.leaf.selected').removeClass(possibleClasses.join(' '), 200).addClass('placed')
        checkIfShouldEnd()
      } else {
        badAnswers[questionNumber-1] += 1
        badAnswerAudio.play()
      }
      $('.leaf-container-handler.activated').removeClass('activated')
      $('.leaf').removeClass('selected')
    }
  })

  $('.check-answer').on('click', function(event){
    event.preventDefault();
  })

  $('.go-to-unanswered').on('click', function(event) {
    event.preventDefault()
    questionNumber = parseInt($($('.leaf:not(.placed)')[0]).parents('.question-cont').attr('data-no'))
    prepareQuestionData()
  })

  checkIfShouldEnd = function () {
    if ( $('.leaf:not(.placed)', '.question-' + questionNumber).length == 0 ) {
      if ( $('.leaf:not(.placed)').length == 0 ) {
        allAnsweredProperly()
      } else {
        $('#modalCorrectAnswer').modal('show')
      }
    }
  }

  var allAnsweredProperly = function() {
    var tableBodyHtml = '';
    for (var i=0; i<noOfQuestions; i++) {
      tableBodyHtml += '<tr><td>' + (i+1) + '</td><td>'
      tableBodyHtml += badAnswers[i]
      tableBodyHtml += '</td><td>'
      if(checkedAnswers[i]){
        tableBodyHtml += 'TAK'
      } else {
        tableBodyHtml += 'NIE'
      }
      tableBodyHtml += '</td>'
    }
    $('tbody', '#allEndedModal').html(tableBodyHtml)
    $('#allEndedModal').modal('show')
  }

  prepareQuestionData = function() {
    $('#modalCorrectAnswer').modal('hide')
    $('.container-tree').addClass('hidden')
    $('.leaf-container-handler').removeClass('activated')
    $('.leaf').removeClass(possibleClasses.join(' ') + ' selected')
    $('.leaf', 'question-' + questionNumber).removeClass('placed')
    $('.question-cont:not(.question' + questionNumber + ')').addClass('hidden')
    $('.question-' + questionNumber).removeClass('hidden')
    $('.question-number').text(questionNumber)
    if (questionNumber == noOfQuestions) {
      $('.next-question').addClass('disabled')
    } else {
      $('.next-question').removeClass('disabled')
    }
    if (questionNumber == 1) {
      $('.prev-question').addClass('disabled')
    } else {
      $('.prev-question').removeClass('disabled')
    }
  }

  prepareQuestionData()

  $('.question-sum').html(noOfQuestions)
  $('.question-text').html('Zapamiętaj, a następnie przyporządkuj owoce i liście do odpowiednich drzew. ')

});