$( document ).ready(function() {

  var goodAnswerAudio = new Audio('../files/audio/ogolne/brawo.wav');
  var badAnswerAudio = new Audio('../files/audio/ogolne/sprobuj.wav');
  var questionAudio = new Audio('../files/audio/las/kolejnosc/polecenie.wav');

  var worngAnswerCount = 0
  var checkedAnswer = 'NIE'

  $('.read-question').on('click', function(event){
    event.preventDefault()
    questionAudio.play()
  })

  $('.check-answer').on('click', function(e) {
    e.preventDefault()
    $('img', '.box-arrow').each(function() {
      $(this).attr('src', '../files/img/las/kolejnosc/' + $(this).attr('data-proper-img'))
    })
    $('.question', '.box-arrow').addClass('hidden')
    $('img', '.box-arrow').removeClass('hidden')
    setTimeout(function() {
      $('.question', '.box-arrow').removeClass('hidden')
      $('img', '.box-arrow').addClass('hidden')
    }, 3000)
    checkedAnswer = 'TAK'
  })

  $('a', '.answer-button').on('click', function(e) {
    e.preventDefault()
    selectedAnswer = this
    selectedArrowBox = $('.box-arrow.selected')
    if (selectedArrowBox.length > 0) {
      setAnswer(selectedAnswer, selectedArrowBox)
    } else {
      $('.answer-button', '.answer-buttons').removeClass('selected')
      $(selectedAnswer).addClass('selected')
    }
  })

  $('.box-arrow').on('click', function(e) {
    e.preventDefault()
    selectedArrowBox = this
    selectedAnswer = $('a.selected', '.answer-button')
    if (selectedAnswer.length > 0) {
      setAnswer(selectedAnswer, selectedArrowBox)
    } else {
      $('.box-arrow').removeClass('selected')
      $(selectedArrowBox).addClass('selected')
    }
  })


  setAnswer = function (selectedAnswer, selectedArrowBox) {
    $('img', selectedArrowBox).attr('src', $('img', selectedAnswer).attr('src'))
    $(selectedArrowBox).attr('data-index', $(selectedAnswer).attr('data-answer-no'))
    $('.question', selectedArrowBox).addClass('hidden')
    $('img', selectedArrowBox).removeClass('hidden')
    $('.selected').removeClass('selected')
    checkIfEnded()
  }

  checkIfEnded = function() {
    allSelected = ($('.question:not(.hidden)', '.box-arrow').length == 0)
    if (allSelected) {
      allAnsweredProperly = true
      $('.box-arrow').each(function(index) {
        if (parseInt($(this).attr('data-index')) != parseInt($('img', this).attr('data-proper-index'))) {
          allAnsweredProperly = false
        }
      })
      if (allAnsweredProperly) {
        goodAnswerAudio.play()
        $('.bad-answer-count').text(worngAnswerCount)
        $('.checked-answer').text(checkedAnswer)
        $('#allEndedModal').modal('show')
      } else {
        badAnswerAudio.play()
        worngAnswerCount += 1
        $('#modalTryAgain').modal('show')
      }
    }
  }

  $('.close-me').on('click', function(e) {
    e.preventDefault()
    $(this).parents('.modal').modal('hide')
  })

  $('.clear-answers').on('click', function(e) {
    e.preventDefault()
    $(this).parents('.modal').modal('hide')
    $('.selected').removeClass('selected')
    $('img', '.box-arrow').addClass('hidden')
    $('.question', '.box-arrow').removeClass('hidden')
    $('.box-arrow').attr('data-index', null)
  })

})