$( document ).ready(function() {

  var goodAnswerAudio = new Audio('../files/audio/ogolne/brawo.wav');
  var badAnswerAudio = new Audio('../files/audio/ogolne/sprobuj.wav');
  var questionAudio = new Audio('../files/audio/las/policz/1.wav');

  var goodAnswers = [5,6,4,6,7,8,10,10]
  var noOfItems = [15, 19, 19, 18, 17, 14, 17, 14]
  var questionNumber = 1
  var noOfQuestions = 8
  var answers = [ [], [], [], [], [], [], [], [] ]
  var checkedAnswers = [false, false, false, false, false, false, false, false]
  var timeouts = []
  var questionTexts = [
    'Policz i zapisz ile spadło liści',
    'Policz i zapisz ile spadło żołędzi',
    'Policz i zapisz ile spadło szyszek',
    'Policz i zapisz ile spadło gałązek',
    'Policz i zapisz ile spadło liści i gałązek ',
    'Policz i zapisz ile spadło żołędzi i szyszek ',
    'Policz i zapisz ile spadło gałązek i szyszek ',
    'Policz i zapisz ile spadło liści, szyszek i gałązek'
  ]

  drawDropping = function(item, index){
    timeouts[index] = setTimeout(function(){
      $(item).addClass('bottom', 1800);
      if( index == noOfItems[questionNumber-1]-1 ){
        setTimeout(function(){
          $('.answer').removeClass('hidden');
          $('.answer-count').val('')
          $('.answer-count').focus()
          $('.answer').removeClass('correct-answer')
          $('.answer').removeClass('wrong-answer')
        }, 1800)
      }
    }, index*1800)
  }

  $('.btn-policz.start').on('click', function(event){
    event.preventDefault();
    $('.answer').addClass('hidden');
    $('.count-container').removeClass('bottom');
    $('.count-container.question-' + questionNumber).each(function(index){
      drawDropping(this, index)
    })
  })

  $('.btn-policz.stop').on('click', function(event){
    _.each(timeouts, function(item){
      clearTimeout(item)
    })
    $('.count-container').removeClass('bottom');
    $('.answer').removeClass('hidden');
    $('.answer-count').val('')
    $('.answer-count').focus()
    $('.answer').removeClass('correct-answer')
    $('.answer').removeClass('wrong-answer')
  })

  $('.check-answer').on('click', function(event){
    event.preventDefault()
    $('.answer-count').val(goodAnswers[questionNumber-1])
    $('.answer').removeClass('hidden')
    checkedAnswers[questionNumber-1] = true
    $('.check-my-answer').click()
  })

  $('.read-question').on('click', function(event){
    event.preventDefault()
    questionAudio.play()
  })

  $('.next-question').on('click', function(event){
    event.preventDefault();
    questionNumber+=1;
    if(noOfQuestions == questionNumber){
      $('.next-question').addClass('disabled');
    };
    $('.prev-question').removeClass('disabled');
    $('.question-number').html(questionNumber);
    $('.question-data:not(.question' + questionNumber + ')').hide()
    questionAudio = new Audio('../files/audio/las/policz/' + questionNumber + '.wav');
    $('.question-text').html(questionTexts[questionNumber-1]);
    $('.question-data.question' + questionNumber).show()
    if( answers[questionNumber-1] && answers[questionNumber-1].indexOf(goodAnswers[questionNumber-1]) == -1 ) {
      $('.answer').addClass('hidden')
      $('#modalCorrectAnswer').modal('hide')
    } else {
      $('.answer').removeClass('hidden').addClass('correct-answer')
      $('.answer-count').val(goodAnswers[questionNumber-1])
      $('#modalCorrectAnswer').modal('hide')
    }
  })

  $('.prev-question').on('click', function(event){
    event.preventDefault();
    questionNumber-=1;
    if(1 == questionNumber){
      $('.prev-question').addClass('disabled');
    };
    questionAudio = new Audio('../files/audio/las/policz/' + questionNumber + '.wav');
    $('.question-text').html(questionTexts[questionNumber-1]);
    $('.next-question').removeClass('disabled');
    $('.question-number').html(questionNumber);
    $('.question-data(not:.question' + questionNumber + ')').hide()
    $('.question-data.question' + questionNumber).show()
    $('.answer').addClass('hidden')
    $('#modalCorrectAnswer').modal('hide')
  })

  $('.check-my-answer').on('click', function(event){
    event.preventDefault();
    if( goodAnswers[questionNumber-1] == parseInt($('.answer-count').val()) ) {
      badAnswerAudio.load();
      goodAnswerAudio.play();
      $('.answer').addClass('correct-answer')
      $('.answer').removeClass('wrong-answer')
      answers[questionNumber-1].push(parseInt($('.answer-count').val()))
      showProperModal()
    } else {
      goodAnswerAudio.load();
      badAnswerAudio.play();
      $('.answer').addClass('wrong-answer')
      $('.answer').removeClass('correct-answer')
      answers[questionNumber-1].push(parseInt($('.answer-count').val()))
    }
  })

  showFinishModal = function() {
    var tableBodyHtml = '';
    for (var i=0; i<noOfQuestions; i++) {
      tableBodyHtml += '<tr><td>' + (i+1) + '</td><td>'

      badAnswers = _.filter(answers[i], function(answer) {
          return goodAnswers[i] != answer
        })

      if(badAnswers.length > 0) {
        tableBodyHtml += badAnswers.length + ' (' + badAnswers.join(' ; ') + ')'
      } else {
        tableBodyHtml += '0'
      }
      tableBodyHtml += '</td><td>'
      if(checkedAnswers[i]){
        tableBodyHtml += 'TAK'
      } else {
        tableBodyHtml += 'NIE'
      }
      tableBodyHtml += '</td>'
    }
    $('tbody', '#countEndedModal').html(tableBodyHtml)
    $('#countEndedModal').modal('show')
  }

  showProperModal = function() {
    console.log (goodAnswers)
    console.log (answers)
    allAnsweredProperly = true;
    var i = 0;
    _.each(answers, function(questionAnswers){
      thisAnswerIsOK = _.filter(questionAnswers, function(partAnswer) {
          return goodAnswers[i] == partAnswer
        }).length > 0
      if( !thisAnswerIsOK ){
        allAnsweredProperly = false;
      }
      i+=1;
    })
    if( allAnsweredProperly ) {
      showFinishModal()
    } else {
      $('#modalCorrectAnswer').modal('show')
    }
  }

  $('.question-number').html(questionNumber);
  $('.question-sum').html(noOfQuestions);
  $('.question-text').html(questionTexts[questionNumber-1]);
  $('.question-data:not(.question' + questionNumber + ')').hide()
  $('.question-data.question' + questionNumber).show()

})