$( document ).ready(function() {

  var goodAnswerAudio = new Audio('../files/audio/ogolne/brawo.wav');
  var badAnswerAudio = new Audio('../files/audio/ogolne/sprobuj.wav');
  var questionAudio = new Audio('../files/audio/las/gra/polecenie.wav');
  var images = ['dab', 'sosna', 'jarzebina', 'mech', 'brzoza', 'borowik', 'paproc', 'leszczyna']
  var goodAnswers = [1,1,2,3,1,3,3,2]
  var badAnswers = [0,0,0,0,0,0,0,0]
  var answered = [false, false, false, false, false, false, false, false]
  var checkedAnswers = [false, false, false, false, false, false, false, false]
  var questionNumber = 1
  var noOfQuestions = 8


  $('.answer-button', '.possible-answers').on('click', function(event){
    event.preventDefault()
    $('.wrong-answer').removeClass('wrong-answer')
    $('.correct-answer').removeClass('correct-answer')
    if (parseInt($(this).attr('data-answer-no')) == goodAnswers[questionNumber-1]) {
      badAnswerAudio.load()
      goodAnswerAudio.play()
      $(this).addClass('correct-answer')
      answered[questionNumber-1] = true
      if ( answered.indexOf(false) != -1 ) {
        $('#modalCorrectAnswer').modal('show')
      } else {
        allAnsweredProperly()
      }
    } else {
      goodAnswerAudio.load()
      badAnswerAudio.play()
      $(this).addClass('wrong-answer')
      badAnswers[questionNumber-1] += 1
    }
  })

  $('.read-question').on('click', function(event){
    event.preventDefault()
    questionAudio.play()
  })

  $('.check-answer').on('click', function(event){
    event.preventDefault()
    checkedAnswers[questionNumber-1] = true
    $('.answer-button[data-answer-no=' + goodAnswers[questionNumber-1] + ']').addClass('correct-answer-2', 500).delay(500).removeClass('correct-answer-2', 500).delay(500).addClass('correct-answer-2', 500).delay(500).removeClass('correct-answer-2', 500).delay(500).addClass('correct-answer-2', 500).delay(500).removeClass('correct-answer-2', 500)
  })

  var allAnsweredProperly = function() {
    var tableBodyHtml = '';
    for (var i=0; i<noOfQuestions; i++) {
      tableBodyHtml += '<tr><td>' + (i+1) + '</td><td>'
      tableBodyHtml += badAnswers[i]
      tableBodyHtml += '</td><td>'
      if(checkedAnswers[i]){
        tableBodyHtml += 'TAK'
      } else {
        tableBodyHtml += 'NIE'
      }
      tableBodyHtml += '</td>'
    }
    $('tbody', '#allEndedModal').html(tableBodyHtml)
    $('#allEndedModal').modal('show')
  }

  $( '.question-number' ).html(questionNumber);
  $( '.question-sum' ).html(noOfQuestions);
  $( '.question-text' ).html('Dopasuj obrazki do odpowiedniej warstwy lasu.');

  $('.next-question').on('click', function (event) {
    event.preventDefault()
    questionNumber += 1
    if (questionNumber == noOfQuestions) {
      $('.next-question').addClass('disabled')
    }
    $('.prev-question').removeClass('disabled')
    $( '.question-number' ).html(questionNumber);
    $('img.helper').attr('src', '../files/img/las/dopasuj/' + images[questionNumber-1] + '.png')
    $('#modalCorrectAnswer').modal('hide')
    $('.correct-answer').removeClass('correct-answer')
    $('.wrong-answer').removeClass('wrong-answer')
  })

  $('.next-unanswered-question').on('click', function (event) {
    event.preventDefault()
    questionNumber = answered.indexOf(false) + 1
    if (questionNumber == noOfQuestions) {
      $('.next-question').addClass('disabled')
    }
    $('.prev-question').removeClass('disabled')
    $( '.question-number' ).html(questionNumber);
    $('img.helper').attr('src', '../files/img/las/dopasuj/' + images[questionNumber-1] + '.png')
    $('#modalCorrectAnswer').modal('hide')
    $('.correct-answer').removeClass('correct-answer')
    $('.wrong-answer').removeClass('wrong-answer')
  })

  $('.prev-question').on('click', function (event) {
    event.preventDefault()
    questionNumber -= 1
    if (questionNumber == 1) {
      $('.prev-question').addClass('disabled')
    }
    $('.next-question').removeClass('disabled')
    $( '.question-number' ).html(questionNumber);
    $('img.helper').attr('src', '../files/img/las/dopasuj/' + images[questionNumber-1] + '.png')
    $('#modalCorrectAnswer').modal('hide')
    $('.correct-answer').removeClass('correct-answer')
    $('.wrong-answer').removeClass('wrong-answer')
  })

});