$( document ).ready(function() {

// DATA
  var goodAnswerAudio = new Audio('../files/audio/ogolne/brawo.wav');
  var badAnswerAudio = new Audio('../files/audio/ogolne/sprobuj.wav');
  var questionAudio = new Audio('../files/audio/las/quiz/1/polecenie.wav');

  var questionNumber = 1;
  var noOfQuestions = 10;

  var questionTypes = [
    'text',
    'text',
    'text',
    'text',
    'text',
    'text',
    'text',
    'text',
    'text',
    'text'
  ]

  var questions = {
    1: "Jak nazywamy górną część drzewa?",
    2: "Jak nazywa się owoc dębu?",
    3: "Jak nazywa się owoc leszczyny?",
    4: "Która z nazw określa warstwę lasu?",
    5: "Jakie rośliny znajdziemy w runie leśnym?",
    6: "Jakie rośliny rosną w podszycie?",
    7: "Które drzewo zaliczamy do warstwy drzew wysokich?",
    8: "Jakie owoce znajdziemy w lesie?",
    9: "Jak nazywa się człowiek pracujący w lesie?",
    10: "Które z drzew stroimy na Boże Narodzenie?"
  }

  var answers = {
    1: {
      0: ['kopuła', 'korona', 'kapelusz'],
      1: ['kopula.wav', 'korona.wav', 'kapelusz.wav']
    },
    2: {
      0: ['kasztan', 'żołądź', 'orzech'],
      1: ['kasztan.wav', 'zoladz.wav', 'orzech.wav']
    },
    3: {
      0: ['orzech', 'grono', 'żołądź'],
      1: ['orzech.wav', 'grono.wav', 'zoladz.wav']
    },
    4: {
      0: ['podszyt', 'podszył', 'poszedł'],
      1: ['podszyt.wav', 'podszyl.wav', 'poszedl.wav']
    },
    5: {
      0: ['zwiędłe liście', 'borowika', 'jarzębinę'],
      1: ['zwiedle_liscie.wav', 'borowika.wav', 'jarzebine.wav']
    },
    6: {
      0: ['maślaki', 'leszczyna', 'sosna'],
      1: ['maslaki.wav', 'leszczyna.wav', 'sosna.wav']
    },
    7: {
      0: ['jarzębinę', 'leszczynę', 'świerk'],
      1: ['jarzebine.wav', 'leszczyne.wav', 'swierk.wav']
    },
    8: {
      0: ['winogrono', 'jagody', 'brzoskwinie'],
      1: ['winogrono.wav', 'jagody.wav', 'brzoskwinie.wav']
    },
    9: {
      0: ['cześnik', 'leśnik', 'paśnik'],
      1: ['czesnik.wav', 'lesnik.wav', 'pasnik.wav']
    },
    10: {
      0: ['modrzew', 'świerk', 'cis'],
      1: ['modrzew.wav', 'swierk.wav', 'cis.wav']
    },

  }

  var answerAudios = []

  var correctAnswerIndexes = {
    1: [2],
    2: [2],
    3: [1],
    4: [1],
    5: [2],
    6: [2],
    7: [3],
    8: [2],
    9: [2],
    10: [2]
  }

  var questionsFinished = []

  var answered = {
    1: [],
    2: [],
    3: [],
    4: [],
    5: [],
    6: [],
    7: [],
    8: [],
    9: [],
    10: []
  }

// MAIN LOGIC

  $( '.question-number' ).html( questionNumber );
  $( '.question-sum' ).html( noOfQuestions );
  $( '.question-text' ).html( questions[questionNumber] );

  $( 'body' ).on('click', '.next-question', function(event){
    event.preventDefault()
    if(questionNumber < noOfQuestions){
      questionNumber++;
      setPageDataForQuestion()
    }
    $('#modalCorrectAnswer').modal('hide')
  });

  $( '.prev-question' ).on('click', function(event){
    event.preventDefault()
    if(questionNumber > 1){
      questionNumber--;
      setPageDataForQuestion()
    }
  });

  $('.answer-audio').on('click', function(event){
    event.preventDefault();
    event.stopPropagation();
    var answerNo = parseInt($(this).attr('data-answer-no'));
    answerAudios[answerNo-1].play();
  })

  $( '.answer-button' ).on('click', function(event) {
    event.preventDefault()
    $('.wrong-answer').removeClass('wrong-answer')
    $('.last-answer').removeClass('last-answer')
    $(this).addClass('last-answer')
    var answerNo = parseInt($(this).attr('data-answer-no'))
    answered[questionNumber].push(answerNo)
    if(correctAnswerIndexes[questionNumber].indexOf(answerNo) !== -1) {
      $(this).addClass('correct-answer')
      badAnswerAudio.load()
      goodAnswerAudio.play()

      if(_.uniq(_.intersection(correctAnswerIndexes[questionNumber], answered[questionNumber])).length == correctAnswerIndexes[questionNumber].length) {

        //all correct answers selected
        if(questionsFinished.indexOf(questionNumber) == -1){
          questionsFinished.push(questionNumber)
        }
        if(!(questionsFinished.length === noOfQuestions)){
          if(questionNumber < noOfQuestions){
            showCorrectAnswerModal()
          }
        } else {
          fillEndModalAndShowIt()
        }

      }
    } else {
      goodAnswerAudio.load()
      badAnswerAudio.play()
      $(this).addClass('wrong-answer')
    }
  });

  $('.read-question').on('click', function(event) {
    event.preventDefault()
    questionAudio.play()
  })

  $('.check-answer').on('click', function(event) {
    event.preventDefault()
    $('.is-correct').toggleClass('correct-answer', 500).delay(500).toggleClass('correct-answer', 500).delay(500).toggleClass('correct-answer', 500).delay(500).toggleClass('correct-answer', 500).delay(500).toggleClass('correct-answer', 500).delay(500).toggleClass('correct-answer', 500)
  })

  var setPageDataForQuestion = function() {
    $( '.question-number' ).html(questionNumber );
    $( '.question-text' ).html(questions[questionNumber] );
    $( '.question-image').html('')

    questionAudio = new Audio('../files/audio/las/quiz/' + questionNumber + '/polecenie.wav');

    if(questionTypes[questionNumber-1] === 'image'){
      setAnswerButtonsForImage()
    } else if(questionTypes[questionNumber-1] === 'text') {
      setAnswerButtonsForText()
    } else if(questionTypes[questionNumber-1] === 'text-with-image') {
      setAnswerButtonsForText()
      setImageForQuestion()
    }
    setAnswerAudiosButtons()
    if(questionNumber == noOfQuestions) {
      $( '.next-question' ).addClass('disabled')
    } else {
      $( '.next-question' ).removeClass('disabled');
    };
    if(questionNumber == 1) {
      $( '.prev-question' ).addClass('disabled');
    } else {
      $( '.prev-question' ).removeClass('disabled');
    }
    $('.wrong-answer').removeClass('wrong-answer')
    $('.last-answer').removeClass('last-answer')
  }

  var setAnswerAudiosButtons = function() {
    for (i = 0; i < 7; i++) {
      button = $('.answer-audio.aa-' + (i+1), '.answer-audios')
      if(answers[questionNumber][0][i] && questionNumber < 11){
        $(button).removeClass('hide')
      } else {
        $(button).addClass('hide')
      }
    }
  }

  var setAnswerButtonsForText = function() {
    $('.answer-buttons-img').hide();
    $('.answer-buttons-txt').show();
    $('.answer-button').removeClass('is-correct')

    for (i = 0; i < 7; i++) {
      button = $('.answer-button.ab-' + (i+1), '.answer-buttons-txt')

      if(correctAnswerIndexes[questionNumber].indexOf(i+1) != -1){
        $(button).addClass('is-correct')
      }

      if(answers[questionNumber][0][i]){
        $(button).removeClass('hide')
        if(answered[questionNumber].indexOf(i+1) !== -1 && correctAnswerIndexes[questionNumber].indexOf(i+1) !== -1) {
          $(button).addClass('correct-answer')
        } else {
          $(button).removeClass('correct-answer')
        }
        $( '.text', $('a', button) ).html(answers[questionNumber][0][i]);
      } else {
        $(button).addClass('hide')
      }
    }
    setAnswerAudios(1)
  }

  var setImageForQuestion = function () {
    $( '.question-image').html('<img src="../files/img/las/quiz/' + answers[questionNumber][2] + '">')
  }

  var setAnswerButtonsForImage = function() {
    $('.answer-buttons-txt').hide();
    $('.answer-buttons-img').show();
    $('.answer-button').removeClass('is-correct')
    for (i = 0; i < 7; i++) {
      button = $('.answer-button.ab-' + (i+1), '.answer-buttons-img')

      if(correctAnswerIndexes[questionNumber].indexOf(i+1) != -1){
        $(button).addClass('is-correct')
      }

      if(answers[questionNumber][1][i]){
        $(button).removeClass('hide')
        if(answered[questionNumber].indexOf(i+1) !== -1 && correctAnswerIndexes[questionNumber].indexOf(i+1) !== -1) {
          $(button).addClass('correct-answer')
        } else {
          $(button).removeClass('correct-answer')
        }
        $( '.button-image', button ).attr('src', '../files/img/las/quiz/' + answers[questionNumber][1][i]);
        $( '.button-footer', button ).text(answers[questionNumber][0][i]);
      } else {
        $(button).addClass('hide')
      }
    }
    setAnswerAudios(2)
  }

  var setAnswerAudios = function(index){
    answerAudios = []
    if (questionNumber < 11) {
      for (i = 0; i < answers[questionNumber][index].length; i++) {
        answerAudios.push(new Audio('../files/audio/las/quiz/' + questionNumber + '/' + answers[questionNumber][index][i]))
      }
    }
  }

  var fillEndModalAndShowIt = function() {
    var tableBodyHtml = '';
    var i = 1;
    _.each(answered, function(yourAnswers){
      var yourAnswerTexts = []
      _.each(yourAnswers, function(answer) {
        if(correctAnswerIndexes[i].indexOf(answer) != -1){
          yourAnswerTexts.push('<span class="text-success">' + answers[i][0][answer-1] + '</span>')
        } else {
          yourAnswerTexts.push('<span class="text-danger">' + answers[i][0][answer-1] + '</span>')
        }
      })
      tableBodyHtml+='<tr><td>' + i + '</td><td>' + yourAnswers.length + '</td><td>' + _.difference(yourAnswers, correctAnswerIndexes[i]).length + '</td><td>' + yourAnswerTexts.join(', ') + '</td></tr>'
      i+=1;
    })
    $('tbody', '#quizEndedModal').html(tableBodyHtml)
    $('#quizEndedModal').modal('show')
  }

  var showCorrectAnswerModal = function(){
    $('#modalCorrectAnswer').modal('show')
  }



  setPageDataForQuestion()

});
