$( document ).ready(function() {

// DATA
  var goodAnswerAudio = new Audio('../files/audio/ogolne/brawo.wav');
  var badAnswerAudio = new Audio('../files/audio/ogolne/sprobuj.wav');
  var questionAudio = new Audio('../files/audio/polska/angielski/polecenie_1.wav');

  var questionNumber = 1;
  var roundNumber = 1;
  var noOfQuestions = [1,5,5];
  var timeouts = []

  var answerAudios = {
    3: [ new Audio('../files/audio/polska/angielski/sea.wav'), new Audio('../files/audio/polska/angielski/lake.wav'), new Audio('../files/audio/polska/angielski/meadow.wav'), new Audio('../files/audio/polska/angielski/river.wav'), new Audio('../files/audio/polska/angielski/ship.wav') ]
  }

  var round2BadAnswersCount = 0

  var round2CheckedAnswer = false

  var round3 = [
    {
      0: 'sea.png',
      1: ['lake', 'sea', 'mountains']
    },
    {
      0: 'lake.png',
      1: ['map', 'country', 'lake']
    },
    {
      0: 'meadow.png',
      1: ['meadow', 'country', 'forest']
    },
    {
      0: 'river.png',
      1: ['river', 'sea', 'meadow']
    },
    {
      0: 'ship.png',
      1: ['lake', 'ship', 'map']
    }
  ]
  var round3Answers = [2,3,1,1,2]
  var round3UserAnswers = {
    1: [],
    2: [],
    3: [],
    4: [],
    5: []
  }

  var round3CheckedAnswers = [false, false, false, false, false]


// MAIN LOGIC

  $('.next-round').on('click', function(){
    roundNumber += 1;
    $('.round-' + (roundNumber-1)).addClass('hidden')
    $('.round-' + roundNumber).removeClass('hidden')
    if(roundNumber == 3){
      $('.next-round').addClass('disabled')
    }
    $('.prev-round').removeClass('disabled')
    $( '.round-number' ).html( roundNumber );
    $('#round2EndedModal').modal('hide')
    questionNumber = 1;
    if(roundNumber == 2) {
      round2prepareCurrentQuestionData()
      questionAudio = new Audio('../files/audio/polska/angielski/polecenie_2.wav');
    } else {
      if(roundNumber == 3){
        round3prepareCurrentQuestionData()
        questionAudio = new Audio('../files/audio/polska/angielski/polecenie_3.wav');
      }
    }
  })

  $('.prev-round').on('click', function(){
    roundNumber -= 1;
    $('.round-' + (roundNumber+1)).addClass('hidden')
    $('.round-' + roundNumber).removeClass('hidden')

    if(roundNumber == 1){
      $('.prev-round').addClass('disabled')
    }
    $('.next-round').removeClass('disabled')
    $( '.round-number' ).html( roundNumber );
    questionNumber = 1;
    if(roundNumber == 2) {
      round2prepareCurrentQuestionData()
    } else {
      if(roundNumber == 3){
        round3prepareCurrentQuestionData()
        questionAudio = new Audio('../files/audio/polska/angielski/polecenie_3.wav');
      }
    }
  })

// first round


  drawDropping = function(item, index){
    timeouts[index] = setTimeout(function(){
      $(item).addClass('bottom', 4500);
      audio = new Audio('../files/audio/polska/angielski/' + (index+1).toString() + '.wav')
      audioPL = new Audio('../files/audio/polska/angielski/' + (index+1).toString() + 'a.wav')
      audioPL.play();
      setTimeout(function() {
        audio.play()
      }, 1500)
    }, index*4500)
  }

  $('.btn-policz.start').on('click', function(event){
    event.preventDefault();
    $('.count-container', '.round-1').removeClass('bottom');
    $('.count-container', '.round-1').each(function(index){
      drawDropping(this, index)
    })
  })

  $('.btn-policz.stop').on('click', function(event){
    _.each(timeouts, function(item){
      clearTimeout(item)
    })
    $('.count-container', '.round-1').removeClass('bottom');
  })


// second round
  var selectedBtn = null

  round2prepareCurrentQuestionData = function () {
    selectedBtn = null
    $('.correct-answer-2', '.round-2').removeClass('correct-answer-2')
  }

  $('.answer-button', '.round-2').on('click', function(event) {
    event.preventDefault()
    if (selectedBtn) {
      if ( $(selectedBtn).hasClass('answer-button') ) {
        $(selectedBtn).removeClass('correct-answer-2')
        $(this).addClass('correct-answer-2')
        selectedBtn = this
      } else {
        processAnswer(this)
      }
    } else {
      $(this).addClass('correct-answer-2')
      selectedBtn = this
    }
  })

  $('.possible-answer-button', '.round-2').on('click', function(event) {
    event.preventDefault()
    if (selectedBtn) {
      if ( $(selectedBtn).hasClass('possible-answer-button') ) {
        $(selectedBtn).removeClass('correct-answer-2')
        $(this).addClass('correct-answer-2')
        selectedBtn = this
      } else {
        processAnswer(this)
      }
    } else {
      $(this).addClass('correct-answer-2')
      selectedBtn = this
    }
  })

  processAnswer = function (lastSelected) {
    if ( parseInt($(lastSelected).attr('data-answer-no')) == parseInt($(selectedBtn).attr('data-answer-no')) ) {
      badAnswerAudio.load()
      goodAnswerAudio.play()
      if ( $(selectedBtn).hasClass('answer-button') ) {
        $('p', selectedBtn).html($('p', lastSelected).html())
        $(selectedBtn).addClass('answered')
      } else {
        $('p', lastSelected).html($('p', selectedBtn).html())
        $(lastSelected).addClass('answered')
      }
      if ($('.answer-button:not(".answered")', '.round-2').length == 0) {
        $('#round2BadAnswersCount').html(round2BadAnswersCount)
        if (round2CheckedAnswer) { ans = 'TAK' } else { ans = 'NIE' }
        $('#round2CheckedAnswer').html(ans)
        $('#round2EndedModal').modal('show')
      }
    } else {
      goodAnswerAudio.load()
      badAnswerAudio.play()
      round2BadAnswersCount += 1
    }
    $('.correct-answer-2', '.round-2').removeClass('correct-answer-2')
  }

  $('.read-answer').on('click', function(event){
    event.preventDefault()
    answerAudios[roundNumber][questionNumber-1].play()
  })

  $('.check-answer', '.round-2').on('click', function(event) {
    event.preventDefault()
    round2CheckedAnswer = true
    $('p', '.round-2 .answer-button').addClass('hidden')
    $('.proper', '.round-2 .answer-button').removeClass('hidden').addClass('hidden', 500).removeClass('hidden', 500).addClass('hidden', 500).removeClass('hidden', 500).addClass('hidden', 500, function() {
      $('p', '.round-2 .answer-button').removeClass('hidden')
    })
  })

  $( '.round-number' ).html( roundNumber );

// third round

  var round3prepareCurrentQuestionData = function() {
    $('.answer-button', '.round-3').removeClass('correct-answer').removeClass('wrong-answer')
    $('.text-thumb', $('.answer-buttons', '.round-3')).each(function(index){
      $(this).html(round3[questionNumber-1][1][index])
      if(index+1 == round3Answers[questionNumber-1] && round3UserAnswers[questionNumber].indexOf(index+1) != -1){
        $(this).parents('.answer-button').addClass('correct-answer')
      }
    })
    $('.button-image', '.round-3').attr('src', '../files/img/polska/ang3/' + round3[questionNumber-1][0])
  }

  var checkIfShouldFinishRound3 = function() {
    var allAnsweredCorrectly = true;
    for(var i=0; i<round3Answers.length; i++) {
      if(round3UserAnswers[i+1].indexOf(round3Answers[i]) == -1) {
        allAnsweredCorrectly = false
      }
    }
    if(allAnsweredCorrectly) {
      var tableBodyHtml = '';
      for (var i=1; i<=round3Answers.length; i++) {
        tableBodyHtml += '<tr><td>' + i + '</td><td>'
        if(_.without(round3UserAnswers[i], round3Answers[i-1]).length > 0) {
          tableBodyHtml += _.without(round3UserAnswers[i], round3Answers[i-1]).length
          // + ' (' + _.without(round2UserAnswers[i], round2Answers[i-1]).join(', ') + ')'
        } else {
          tableBodyHtml += '0'
        }
        tableBodyHtml += '</td><td>'
        if(round3CheckedAnswers[i-1]){
          tableBodyHtml += 'TAK'
        } else {
          tableBodyHtml += 'NIE'
        }
        tableBodyHtml += '</td>'
      }
      $('tbody', '#round3EndedModal').html(tableBodyHtml)
      $('#round3EndedModal').modal('show')
    } else {
      $('#modalCorrectAnswer').modal('show')
    }
  }

  $('.read-question').on('click', function(event){
    event.preventDefault()
    questionAudio.play()
  })

  $( '.next-question', '.round-3' ).on('click', function(event){
    event.preventDefault()
    if(questionNumber < noOfQuestions[2]){
      questionNumber++;
      round3prepareCurrentQuestionData()
      if(questionNumber == noOfQuestions[2]){
        $('.next-question', '.round-3').addClass('disabled')
      }
      $('.prev-question', '.round-3').removeClass('disabled')
    }
    $('#modalCorrectAnswer').modal('hide')
  });

  $( '.prev-question', '.round-3' ).on('click', function(event){
    event.preventDefault()
    if(questionNumber > 1){
      questionNumber--;
      round3prepareCurrentQuestionData()
      if(questionNumber == 1){
        $('.prev-question', '.round-3').addClass('disabled')
      }
      $('.next-question', '.round-3').removeClass('disabled')
    }
    $('#modalCorrectAnswer').modal('hide')
  });

  $('.answer-button', '.round-3').on('click', function(event){
    event.preventDefault();
    round3UserAnswers[questionNumber].push(parseInt($(this).attr('data-answer-no')))
    $('.answer-button', '.round-3').removeClass('wrong-answer')
    if(parseInt($(this).attr('data-answer-no')) == round3Answers[questionNumber-1]){
      $(this).addClass('correct-answer')
      checkIfShouldFinishRound3()
      badAnswerAudio.load()
      goodAnswerAudio.play()
    } else {
      $(this).addClass('wrong-answer')
      goodAnswerAudio.load()
      badAnswerAudio.play()
    }
  })

  $('.check-answer', '.round-3').on('click', function(event) {
    event.preventDefault()
    round3CheckedAnswers[questionNumber-1] = true
    $('.answer-button[data-answer-no=' + round3Answers[questionNumber-1] + ']', '.round-3').toggleClass('correct-answer', 500).delay(500).toggleClass('correct-answer', 500).delay(500).toggleClass('correct-answer', 500).delay(500).toggleClass('correct-answer', 500).delay(500).toggleClass('correct-answer', 500).delay(500).toggleClass('correct-answer', 500)
  })



});
