$( document ).ready(function() {

  var goodAnswerAudio = new Audio('../files/audio/ogolne/brawo.wav');
  var badAnswerAudio = new Audio('../files/audio/ogolne/sprobuj.wav');
  var questionAudio = new Audio('../files/audio/polska/policz/polecenie_1.wav');

  var goodAnswers = [5, 5, 6, 6, 9, 7, 11]
  var noOfItems = [15, 19, 19, 18, 17, 14, 17]
  var questionNumber = 1
  var noOfQuestions = 7
  var answers = [ [], [], [], [], [], [], [] ]
  var checkedAnswers = [false, false, false, false, false, false, false]
  var timeouts = []

  var questionTexts = [
    'Policz i zapisz ile przepłynęło żaglówek zielonych',
    'Policz i zapisz ile przepłynęło żaglówek żółtych',
    'Policz i zapisz ile przepłynęło żaglówek niebieskich',
    'Policz i zapisz ile przepłynęło żaglówek czerwonych',
    'Policz i zapisz ile przepłynęło żaglówek żółtych i zielonych',
    'Policz i zapisz ile przepłynęło żaglówek czerwonych i niebieskich',
    'Policz i zapisz ile przepłynęło żaglówek żółtych i czerwonych',
  ]

  drawShipMovement = function(item, index){
    timeouts[index] = setTimeout(function(){
      $(item).addClass('end', 2000);
      if( index == noOfItems[questionNumber-1]-1 ){
        setTimeout(function(){
          $('.answer').removeClass('hidden');
          $('.answer-count').val('')
          $('.answer-count').focus()
          $('.answer').removeClass('correct-answer')
          $('.answer').removeClass('wrong-answer')
        }, 2000)
      }
    }, index*2000)
  }

  $('.btn-policz.start').on('click', function(event){
    event.preventDefault();
    $('.answer').addClass('hidden');
    $('.ship').removeClass('end');
    $('.ship', '.' + questionNumber + '-wave').each(function(index){
      drawShipMovement(this, index)
    })
  })

  $('.btn-policz.stop').on('click', function(event){
    _.each(timeouts, function(item){
      clearTimeout(item)
    })
    $('.ship').removeClass('end');
    $('.answer').removeClass('hidden');
    $('.answer-count').val('')
    $('.answer-count').focus()
    $('.answer').removeClass('correct-answer')
    $('.answer').removeClass('wrong-answer')
  })

  $('.check-answer').on('click', function(event){
    event.preventDefault()
    $('.answer-count').val(goodAnswers[questionNumber-1])
    $('.answer').removeClass('hidden')
    $('.check-my-answer').click()
    checkedAnswers[questionNumber-1] = true
  })

  $('.read-question').on('click', function(event){
    event.preventDefault()
    questionAudio.play()
  })

  $('.next-question').on('click', function(event){
    event.preventDefault();
    questionNumber+=1;
    if(noOfQuestions == questionNumber){
      $('.next-question').addClass('disabled');
    };
    $('.prev-question').removeClass('disabled');
    $('.question-text').html(questionTexts[questionNumber-1])
    questionAudio = new Audio('../files/audio/polska/policz/polecenie_' + questionNumber + '.wav');
    $('.question-number').html(questionNumber);
    $('#modalCorrectAnswer').modal('hide')
    if( answers[questionNumber-1] && answers[questionNumber-1].indexOf(goodAnswers[questionNumber-1]) == -1 ) {
      $('.answer').addClass('hidden')
    } else {
      $('.answer').removeClass('hidden').addClass('correct-answer')
      $('.answer-count').val(goodAnswers[questionNumber-1])
    }
  })

  $('.prev-question').on('click', function(event){
    event.preventDefault();
    questionNumber-=1;
    if(1 == questionNumber){
      $('.prev-question').addClass('disabled');
    };
    $('.next-question').removeClass('disabled');
    $('.question-number').html(questionNumber);
    $('.question-text').html(questionTexts[questionNumber-1])
    questionAudio = new Audio('../files/audio/polska/policz/polecenie_' + questionNumber + '.wav');
    $('#modalCorrectAnswer').modal('hide')
    if( answers[questionNumber-1] && answers[questionNumber-1].indexOf(goodAnswers[questionNumber-1]) == -1 ) {
      $('.answer').addClass('hidden')
    } else {
      $('.answer').removeClass('hidden').addClass('correct-answer')
      $('.answer-count').val(goodAnswers[questionNumber-1])
    }

  })

  $('.check-my-answer').on('click', function(event){
    event.preventDefault();
    answered = parseInt($('.answer-count').val())
    if( answered == goodAnswers[questionNumber-1] ) {
      badAnswerAudio.load();
      goodAnswerAudio.play();
      $('.answer').addClass('correct-answer')
      $('.answer').removeClass('wrong-answer')
      answers[questionNumber-1].push(answered)
      showProperModal()
    } else {
      goodAnswerAudio.load();
      badAnswerAudio.play();
      $('.answer').addClass('wrong-answer')
      $('.answer').removeClass('correct-answer')
      answers[questionNumber-1].push(answered)
    }
  })

  showFinishModal = function() {
    var tableBodyHtml = '';
    for (var i=0; i<10; i++) {
      tableBodyHtml += '<tr><td>' + (i+1) + '</td><td>'
      badAnswers = _.without(answers[i], goodAnswers[i])
      if(badAnswers.length > 0) {
        tableBodyHtml += badAnswers.length + ' (' + badAnswers.join(', ') + ')'
      } else {
        tableBodyHtml += '0'
      }
      tableBodyHtml += '</td><td>'
      if(checkedAnswers[i]){
        tableBodyHtml += 'TAK'
      } else {
        tableBodyHtml += 'NIE'
      }
      tableBodyHtml += '</td>'
    }
    $('tbody', '#countEndedModal').html(tableBodyHtml)
    $('#countEndedModal').modal('show')
  }

  showProperModal = function() {
    allAnsweredProperly = true;
    var i = 0;
    _.each(answers, function(questionAnswers){
      if( questionAnswers.indexOf(goodAnswers[i]) == -1 ){
        allAnsweredProperly = false;
      }
      i+=1;
    })
    if( allAnsweredProperly ) {
      showFinishModal()
    } else {
      $('#modalCorrectAnswer').modal('show')
    }
  }

  $('.question-number').html(questionNumber);
  $('.question-sum').html(noOfQuestions);
  $('.question-text').html(questionTexts[questionNumber-1]);


})