$( document ).ready(function() {

// DATA
  var goodAnswerAudio = new Audio('../files/audio/ogolne/brawo.wav');
  var badAnswerAudio = new Audio('../files/audio/ogolne/sprobuj.wav');
  var questionAudio = new Audio('../files/audio/polska/quiz/1/polecenie_1.wav');

  var questionNumber = 1;
  var noOfQuestions = 15;

  var questionTypes = [
    'text',
    'text',
    'text',
    'text',
    'text',
    'text',
    'text',
    'text',
    'text',
    'text',
    'text',
    'text',
    'text',
    'text',
    'text'
  ]

  var questions = {
    1: "Pełna nazwa naszego kraju to:",
    2: "Tytuł hymnu polskiego to:",
    3: "Godłem Polski jest:",
    4: "Polska leży nad morzem:",
    5: "Przez stolicę polski płynie rzeka:",
    6: "Rzeki które leżą na granicach Polski to:",
    7: "Najwyższe góry w Polsce to:",
    8: "Kolorem zielonym na mapie fizycznej oznaczamy:",
    9: "Kolorem żółtym na mapie fizycznej oznaczamy:",
    10: "Kolorem czerwonym na mapie fizycznej oznaczamy:",
    11: "Kolorem niebieskim na mapie fizycznej oznaczamy:",
    12: "Morze Bałtyckie leży na:",
    13: "Góry leżą na:",
    14: "Mazury leżą na:",
    15: "Nizina Wielkopolska leży na:"
  }

  var answers = {
    1: {
      0: ["Republika Polska", "Polska", "Rzeczpospolita Polska"],
      1: ['1/republika.wav', '1/Polska.wav', '1/Rzeczpospolita.wav']
    },
    2: {
      0: ["Marsz Dąbrowskiego", "Mazurek Dąbrowskiego", "Pieśń Polska"],
      1: ['2/marsz.wav', '2/mazurek.wav', '2/piesn.wav'],
    },
    3: {
      0: ["jastrząb na czerwonym tle", "biały orzeł na czerwonym tle", "czerwony orzeł na białym tle"],
      1: ['3/jastrzab.wav', '3/orzel.wav', '3/czer_orzel.wav']
    },
    4: {
      0: ["Północnym", "Bałtyckim", "Skandynaw-<br>skim"],
      1: ['4/polnocnym.wav', '4/baltyckim.wav', '4/skandynawskim.wav']
    },
    5: {
      0: ["Odra", "Wisła", "Warta"],
      1: ['5/odra.wav', '5/wisla.wav', '5/warta.wav']
    },
    6: {
      0: ["Buk i Odra", "Warta i Noteć", "Wisła i Odra"],
      1: ['6/buk_odra.wav', '6/warta_notec.wav', '6/wisla_odra.wav']
    },
    7: {
      0: ["Bieszczady", "Sudety", "Tatry"],
      1: ['7/bieszczady.wav', '7/sudety.wav', '7/tatry.wav']
    },
    8: {
      0: ["niziny", "góry", "wyżyny"],
      1: ['8/niziny.wav', '8/gory.wav', '8/wyzyny.wav']
    },
    9: {
      0: ["niziny", "góry", "wyżyny"],
      1: ['9/niziny.wav', '9/gory.wav', '9/wyzyny.wav']
    },
    10: {
      0: ["niziny", "góry", "wyżyny"],
      1: ['10/niziny.wav', '10/gory.wav', '10/wyzyny.wav']
    },
    11: {
      0: ["niebo", "rzeki", "chmury"],
      1: ['11/niebo.wav', '11/rzeki.wav', '11/chmury.wav'],
    },
    12: {
      0: ["północy", "zachodzie", "południu"],
      1: ['12/polnocy.wav', '12/zachodzie.wav', '12/poludniu.wav'],
    },
    13: {
      0: ["północy kraju", "zachodzie kraju", "południu kraju"],
      1: ['13/polnocy.wav', '13/zachodzie.wav', '13/poludniu.wav'],
    },
    14: {
      0: ["wschodzie kraju", "zachodzie kraju", "południu kraju"],
      1: ['14/wschodzie.wav', '14/zachodzie.wav', '14/poludniu.wav'],
    },
    15: {
      0: ["północy kraju", "zachodzie kraju", "południu kraju"],
      1: ['15/polnocy.wav', '15/zachodzie.wav', '15/poludniu.wav'],
    }

  }

  var answerAudios = []

  var correctAnswerIndexes = {
    1: [3],
    2: [2],
    3: [2],
    4: [2],
    5: [2],
    6: [1],
    7: [3],
    8: [1],
    9: [3],
    10: [2],
    11: [2],
    12: [1],
    13: [3],
    14: [1],
    15: [2]
  }

  var questionsFinished = []

  var answered = {
    1: [],
    2: [],
    3: [],
    4: [],
    5: [],
    6: [],
    7: [],
    8: [],
    9: [],
    10: [],
    11: [],
    12: [],
    13: [],
    14: [],
    15: []
  }

// MAIN LOGIC

  $( '.question-number' ).html( questionNumber );
  $( '.question-sum' ).html( noOfQuestions );
  $( '.question-text' ).html( questions[questionNumber] );

  $( 'body' ).on('click', '.next-question', function(event){
    event.preventDefault()
    if(questionNumber < noOfQuestions){
      questionNumber++;
      setPageDataForQuestion()
    }
    $('#modalCorrectAnswer').modal('hide')
  });

  $( '.prev-question' ).on('click', function(event){
    event.preventDefault()
    if(questionNumber > 1){
      questionNumber--;
      setPageDataForQuestion()
    }
  });

  $('.answer-audio').on('click', function(event){
    event.preventDefault();
    event.stopPropagation();
    var answerNo = parseInt($(this).attr('data-answer-no'));
    answerAudios[answerNo-1].play();
  })

  $( '.answer-button' ).on('click', function(event) {
    event.preventDefault()
    $('.wrong-answer').removeClass('wrong-answer')
    $('.last-answer').removeClass('last-answer')
    $(this).addClass('last-answer')
    var answerNo = parseInt($(this).attr('data-answer-no'))
    answered[questionNumber].push(answerNo)
    if(correctAnswerIndexes[questionNumber].indexOf(answerNo) !== -1) {
      $(this).addClass('correct-answer')
      badAnswerAudio.load()
      goodAnswerAudio.play()

      if(_.uniq(_.intersection(correctAnswerIndexes[questionNumber], answered[questionNumber])).length == correctAnswerIndexes[questionNumber].length) {

        //all correct answers selected
        if(questionsFinished.indexOf(questionNumber) == -1){
          questionsFinished.push(questionNumber)
        }
        if(!(questionsFinished.length === noOfQuestions)){
          if(questionNumber < noOfQuestions){
            showCorrectAnswerModal()
          }
        } else {
          fillEndModalAndShowIt()
        }

      }
    } else {
      goodAnswerAudio.load()
      badAnswerAudio.play()
      $(this).addClass('wrong-answer')
    }
  });

  $('.read-question').on('click', function(event) {
    event.preventDefault()
    questionAudio.play()
  })

  $('.check-answer').on('click', function(event) {
    event.preventDefault()
    $('.is-correct').toggleClass('correct-answer', 500).delay(500).toggleClass('correct-answer', 500).delay(500).toggleClass('correct-answer', 500).delay(500).toggleClass('correct-answer', 500).delay(500).toggleClass('correct-answer', 500).delay(500).toggleClass('correct-answer', 500)
  })

  var setPageDataForQuestion = function() {
    $( '.question-number' ).html(questionNumber );
    $( '.question-text' ).html(questions[questionNumber] );
    $( '.question-image').html('')

    questionAudio = new Audio('../files/audio/polska/quiz/' + questionNumber + '/polecenie_' + questionNumber + '.wav');

    if(questionTypes[questionNumber-1] === 'image'){
      setAnswerButtonsForImage()
    } else if(questionTypes[questionNumber-1] === 'text') {
      setAnswerButtonsForText()
    } else if(questionTypes[questionNumber-1] === 'text-with-image') {
      setAnswerButtonsForText()
      setImageForQuestion()
    }
    setAnswerAudiosButtons()
    if(questionNumber == noOfQuestions) {
      $( '.next-question' ).addClass('disabled')
    } else {
      $( '.next-question' ).removeClass('disabled');
    };
    if(questionNumber == 1) {
      $( '.prev-question' ).addClass('disabled');
    } else {
      $( '.prev-question' ).removeClass('disabled');
    }
    $('.wrong-answer').removeClass('wrong-answer')
    $('.last-answer').removeClass('last-answer')
  }

  var setAnswerAudiosButtons = function() {
    for (i = 0; i < 7; i++) {
      button = $('.answer-audio.aa-' + (i+1), '.answer-audios')
      if(answers[questionNumber][0][i]){
        $(button).removeClass('hide')
      } else {
        $(button).addClass('hide')
      }
    }
  }

  var setAnswerButtonsForText = function() {
    $('.answer-buttons-img').hide();
    $('.answer-buttons-txt').show();
    $('.answer-button').removeClass('is-correct')

    for (i = 0; i < 7; i++) {
      button = $('.answer-button.ab-' + (i+1), '.answer-buttons-txt')

      if(correctAnswerIndexes[questionNumber].indexOf(i+1) != -1){
        $(button).addClass('is-correct')
      }

      if(answers[questionNumber][0][i]){
        $(button).removeClass('hide')
        if(answered[questionNumber].indexOf(i+1) !== -1 && correctAnswerIndexes[questionNumber].indexOf(i+1) !== -1) {
          $(button).addClass('correct-answer')
        } else {
          $(button).removeClass('correct-answer')
        }
        $( '.text', $('a', button) ).html(answers[questionNumber][0][i]);
      } else {
        $(button).addClass('hide')
      }
    }
    setAnswerAudios(1)
  }

  var setImageForQuestion = function () {
    $( '.question-image').html('<img src="../files/img/polska/quiz/' + answers[questionNumber][2] + '">')
  }

  var setAnswerButtonsForImage = function() {
    $('.answer-buttons-txt').hide();
    $('.answer-buttons-img').show();
    $('.answer-button').removeClass('is-correct')
    for (i = 0; i < 7; i++) {
      button = $('.answer-button.ab-' + (i+1), '.answer-buttons-img')

      if(correctAnswerIndexes[questionNumber].indexOf(i+1) != -1){
        $(button).addClass('is-correct')
      }

      if(answers[questionNumber][1][i]){
        $(button).removeClass('hide')
        if(answered[questionNumber].indexOf(i+1) !== -1 && correctAnswerIndexes[questionNumber].indexOf(i+1) !== -1) {
          $(button).addClass('correct-answer')
        } else {
          $(button).removeClass('correct-answer')
        }
        $( '.button-image', button ).attr('src', '../files/img/polska/quiz/' + answers[questionNumber][1][i]);
        $( '.button-footer', button ).text(answers[questionNumber][0][i]);
      } else {
        $(button).addClass('hide')
      }
    }
    setAnswerAudios(2)
  }

  var setAnswerAudios = function(index){
    answerAudios = []
    for (i = 0; i < answers[questionNumber][index].length; i++) {
      answerAudios.push(new Audio('../files/audio/polska/quiz/' + answers[questionNumber][index][i]))
    }
  }

  var fillEndModalAndShowIt = function() {
    var tableBodyHtml = '';
    var i = 1;
    _.each(answered, function(yourAnswers){
      var yourAnswerTexts = []
      _.each(yourAnswers, function(answer) {
        if(correctAnswerIndexes[i].indexOf(answer) != -1){
          yourAnswerTexts.push('<span class="text-success">' + answers[i][0][answer-1] + '</span>')
        } else {
          yourAnswerTexts.push('<span class="text-danger">' + answers[i][0][answer-1] + '</span>')
        }
      })
      tableBodyHtml+='<tr><td>' + i + '</td><td>' + yourAnswers.length + '</td><td>' + _.difference(yourAnswers, correctAnswerIndexes[i]).length + '</td><td>' + yourAnswerTexts.join(', ') + '</td></tr>'
      i+=1;
    })
    $('tbody', '#quizEndedModal').html(tableBodyHtml)
    $('#quizEndedModal').modal('show')
  }

  var showCorrectAnswerModal = function(){
    $('#modalCorrectAnswer').modal('show')
  }



  setPageDataForQuestion()

});
