$( document ).ready(function() {

  var goodAnswerAudio = new Audio('../files/audio/ogolne/brawo.wav');
  var badAnswerAudio = new Audio('../files/audio/ogolne/sprobuj.wav');
  var questionAudio = new Audio('../files/audio/polska/rytm/polecenie.wav');

  var badAnswers = 0;
  var checkedItem = null

  $('.read-question').on('click', function(){
    questionAudio.play()
  })

  $('.quest', '.rytm-buttons').on('click', function(event){
    event.preventDefault()
    setAnswerOrHilight(this)
  })

  $('.answer-button', '.answers').on('click', function(event){
    event.preventDefault()
    setAnswerOrHilight(this)
  })

  $('.check-answer').on('click', function(event){
    event.preventDefault()
    $('.question-mark', '.quest').addClass('disable')
    $('.image-container', '.quest').addClass('disable')
    var loadedSrcs = []
    $('img', '.quest').each(function(){
      loadedSrcs.push($(this).attr('src'))
    })
    $('.quest').each(function(){
      $('img', this).attr('src', $('img', $('[data-answer-no=' + $(this).attr('data-answer-no') + ']', '.answers')).attr('src'))
    })
    $('.image-container', '.quest').toggleClass('disable', 500).toggleClass('disable', 500).toggleClass('disable', 500).toggleClass('disable', 500).toggleClass('disable', 500).toggleClass('disable', 500)

    $('.question-mark', '.quest').removeClass('disable', 3500)
  })

  $('.clear-answers').on('click', function(event){
    event.preventDefault()
    $('.image-container', '.quest').addClass('disable')
    $('.question-mark', '.quest').removeClass('disable')
    $('#modalTryAgain').modal('hide')
  })

  $('.close-me').on('click', function(event){
    event.preventDefault()
    $('#modalTryAgain').modal('hide')
  })

  var setAnswerOrHilight = function(item) {
    if( checkedItem ) {
      if(item == checkedItem){
        $(checkedItem).removeClass('checked')
        checkedItem = null
      } else {
        if(!(($(item).hasClass('quest') && $(checkedItem).hasClass('quest')) || ($(item).hasClass('answer') && $(checkedItem).hasClass('answer')))){
          if( $(item).hasClass('quest') ){
            $('img', item).attr('src', $('img', checkedItem).attr('src'))
            $('.image-container', item).removeClass('disable')
            $('.question-mark', item).addClass('disable')
            $(item).attr('data-answered', $(checkedItem).attr('data-answer-no'))
          } else {
            $('img', checkedItem).attr('src', $('img', item).attr('src'))
            $('.image-container', checkedItem).removeClass('disable')
            $('.question-mark', checkedItem).addClass('disable')
            $(checkedItem).attr('data-answered', $(item).attr('data-answer-no'))
          }
          $(checkedItem).removeClass('checked')
          checkedItem = null
          checkAllAnswers()
        }
      }
    } else {
      checkedItem = item
      $(item).addClass('checked')
    }
  }

  var checkAllAnswers = function() {
    if( $('.image-container.disable').length == 0 ){
      allAnsweredProperly = true
      $('.quest', '.rytm-buttons').each(function(){
        if($(this).attr('data-answer-no') != $(this).attr('data-answered')){
          allAnsweredProperly = false
        }
      })
      if( allAnsweredProperly ) {
        badAnswerAudio.load()
        goodAnswerAudio.play()
        $('.bad-answer-count', '#allEndedModal').html(badAnswers)
        $('#allEndedModal').modal('show')
      } else {
        badAnswers += 1
        goodAnswerAudio.load()
        badAnswerAudio.play()
        $('#modalTryAgain').modal('show')
      }
    }
  }

  // var checkProperAnswer = function() {
  //   var i = 0
  //   var isAnswerOk = true
  //   _.each($('.answer-button', '.answered'), function(item){
  //     if(parseInt($(item).attr('data-last-answer')) != goodAnswers[i]) {
  //       isAnswerOk = false
  //     }
  //     i+=1
  //   })
  //   if(isAnswerOk) {
  //     goodAnswerAudio.play();
  //     allAnsweredProperly();
  //   } else {
  //     badAnswerAudio.play();
  //     badAnswers += 1;
  //     $('.question-mark', $('.answered')).show()
  //     $('.image-container', $('.answered')).addClass('disable')
  //     currentAnswer = 0
  //   }
  // }

  var allAnsweredProperly = function() {

    $('.bad-answer-count', '#quizEndedModal').html(badAnswers)
    $('#quizEndedModal').modal('show')
  }

});