$( document ).ready(function() {

  var goodAnswerAudio = new Audio('../files/audio/ogolne/brawo.wav');
  var badAnswerAudio = new Audio('../files/audio/ogolne/sprobuj.wav');
  var questionAudio = new Audio('../files/audio/anatomia/dopasuj/polecenie.wav');

  var badAnswersCount = 0
  var checkedAnswer = 'NIE'

  $('.read-question').on('click', function(event){
    event.preventDefault()
    questionAudio.play()
  })

  $('.check-answer').on('click', function(event){
    event.preventDefault()
    checkedAnswer = 'TAK'
    $('.answer').not('.used').addClass('preview', 500).delay(500).removeClass('preview', 500).delay(500).addClass('preview', 500).delay(500).removeClass('preview', 500).delay(500).addClass('preview', 500).delay(500).removeClass('preview', 500)
  })

  $('.possibility').on('click', function(event){
    event.preventDefault()
    if ($('.possibility.selected').length > 0) {
      $('.possibility.selected').removeClass('selected')
      $(this).addClass('selected')
    } else {
      $(this).addClass('selected')
      processAnswer($(this), $('.answer.selected'))
    }
  })

  $('.answer').on('click', function(event){
    event.preventDefault()
    if ($('.answer.selected').length > 0) {
      $('.answer.selected').removeClass('selected')
      $(this).addClass('selected')
    } else {
      $(this).addClass('selected')
      processAnswer($('.possibility.selected'), $(this))
    }
  })

  processAnswer = function(possibility, answer) {
    if ($(possibility).length > 0 && $(answer).length > 0) {
      if ($(possibility).attr('data-answer') == $(answer).attr('data-answer')) {
        badAnswerAudio.load()
        goodAnswerAudio.play()
        answerAudio = new Audio('../files/audio/anatomia/dopasuj/' + $(possibility).attr('data-answer') + '.wav')
        setTimeout(function() {
          answerAudio.play()
        }, 1000)
        $(answer).addClass('used').text($(possibility).text())
        $('.selected').removeClass('selected')
        checkIfEnded()
      } else {
        goodAnswerAudio.load()
        badAnswerAudio.play()
        $('.selected').removeClass('selected')
        badAnswersCount += 1
      }
    }
  }

  checkIfEnded = function() {
    if( $('.answer').not('.used').length == 0 ){
      $('.wrong-answer-count').text(badAnswersCount)
      $('.checked-answer').text(checkedAnswer)
      $('#allEndedModal').modal('show')
    }
  }

})