$( document ).ready(function() {

  var goodAnswerAudio = new Audio('../files/audio/ogolne/brawo.wav');
  var badAnswerAudio = new Audio('../files/audio/ogolne/sprobuj.wav');
  var questionAudio = new Audio('../files/audio/anatomia/pamiec_polecenie.wav');

  var badAnswers = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0]
  var goodAnswers = [ false, false, false, false, false, false, false, false, false, false ]
  var checkedAnswers = [ false, false, false, false, false, false, false, false, false, false ]

  questionNumber = 1
  noOfQuestions = 10

  var answerData = [
    ['plomien.png', 'szklanka-wody.png', 'plomien.png', 'szklanka-wody.png', 'plomien.png'],
    ['plomien.png', 'plomien.png', 'ziemia.png', 'ziemia.png', 'chmura.png', 'chmura.png'],
    ['szklanka-wody.png', 'ziemia.png', 'parasol.png', 'wulkan.png', 'szklanka-wody.png', 'ziemia.png', 'parasol.png', 'wulkan.png'],
    ['ziemia.png', 'plomien.png', 'chmura.png', 'ziemia.png', 'plomien.png', 'chmura.png', 'parasol.png'],
    ['chmura.png', 'szklanka-wody.png', 'chmura.png', 'szklanka-wody.png', 'chmura.png'],
    ['plomien.png', 'ziemia.png', 'ziemia.png', 'chmura.png', 'ziemia.png', 'ziemia.png', 'chmura.png'],
    ['parasol.png', 'parasol.png', 'chmura.png', 'chmura.png', 'ziemia.png', 'ziemia.png', 'wulkan.png', 'wulkan.png'],
    ['plomien.png', 'parasol.png', 'parasol.png', 'plomien.png', 'parasol.png', 'parasol.png'],
    ['wulkan.png', 'chmura.png', 'szklanka-wody.png', 'chmura.png', 'wulkan.png'],
    ['chmura.png', 'plomien.png', 'ziemia.png', 'wulkan.png', 'plomien.png', 'ziemia.png', 'chmura.png']
  ]

  var properAnswers = [
    [2,3,2,3,2],
    [2,2,5,5,0,0],
    [3,5,1,4,3,5,1,4],
    [5,2,0,5,2,0,1],
    [0,3,0,3,0],
    [2,5,5,0,5,5,0],
    [1,1,0,0,5,5,4,4],
    [2,1,1,2,1,1],
    [4,0,3,0,4],
    [0,2,5,4,2,5,0]
  ]

  $('.read-question').on('click', function(){
    questionAudio.play()
  })

  $('.next-question').on('click', function(event){
    event.preventDefault();
    questionNumber+=1;
    prepareQuestionData()
  })

  $('.prev-question').on('click', function(event){
    event.preventDefault();
    questionNumber-=1;
    prepareQuestionData()
  })

  $('.answer-button', '.answers').on('click', function(event) {
    event.preventDefault()
    img = $('img', this).attr('src')
    answerNo = parseInt($(this).attr('data-answer-no'))
    $('.selected-images').append('<div class="image-container" data-answer-no="' + answerNo + '"><img class="button-image" src="' + img + '"></div>&nbsp;')
    if($('img', '.selected-images').length >= properAnswers[questionNumber-1].length){
      checkYourAnswer()
    }
  })

  $('.clear').on('click', function(event){
    event.preventDefault()
    $('#modalWrongAnswer').modal('hide')
    $('.selected-images').html('')
  })

  $('.play').on('click', function(event){
    event.preventDefault()
    var nqd = $('.next-question').hasClass('disabled')
    var pqd = $('.prev-question').hasClass('disabled')
    $('.next-question').addClass('disabled')
    $('.prev-question').addClass('disabled')

    $('#modalWrongAnswer').modal('hide')
    $('.play-section').addClass('hidden')
    $('.selected-images').html('')
    $('.counter-container').removeClass('hidden').addClass('hidden', 5000)
    $('.question-section').removeClass('hidden').addClass('hidden', 5000)
    $('.answer-prepend-section').addClass('hidden').removeClass('hidden', 5050).addClass('hidden', 1000)
    $('.answer-section').addClass('hidden').removeClass('hidden', 6100)

    var i = 5
    $('.counter').text(i)
    var intervalCounter = setInterval(function(){
      i-=1;
      $('.counter').text(i)
      checkIfShouldStopCounter(i);
    }, 1000)
    var checkIfShouldStopCounter = function(i){
      if(i==0){
        window.clearInterval(intervalCounter);
      }
    }

    setTimeout(function(){
      if(pqd == false){
        $('.prev-question').removeClass('disabled')
      }
      if(nqd == false){
        $('.next-question').removeClass('disabled')
      }
    }, 6100)
  })

  $('.check-answer').on('click', function(event){
    event.preventDefault();

    checkedAnswers[questionNumber-1] = true
    $('.selected-images').html('')
    var index = 0
    _.each(answerData[questionNumber-1], function(img){
      $('.selected-images').append('<div class="image-container" data-answer-no="' + (index+1) + '"><img class="button-image" src="../files/img/anatomia/pamiec/' + img + '"></div>&nbsp;')
      index+=1
    })

    $('.play-section').addClass('hidden')
    $('.counter-container').addClass('hidden')
    $('.question-section').addClass('hidden')
    $('.answer-prepend-section').addClass('hidden')
    $('.answer-section').removeClass('hidden')
    $('.image-container', '.selected-images').toggleClass('hidden', 500).toggleClass('hidden', 500).toggleClass('hidden', 500).toggleClass('hidden', 500).toggleClass('hidden', 500).toggleClass('hidden', 500)
    setTimeout(function(){
      $('.selected-images').html('')
    }, 3500)
  })

  var checkYourAnswer = function() {
    var isAnswerOK = true
    $('.image-container', '.selected-images').each(function(index){
      if( parseInt($(this).attr('data-answer-no')) != properAnswers[questionNumber-1][index] ){
        isAnswerOK = false
      }
    })
    if(isAnswerOK) {
      goodAnswers[questionNumber-1] = true
      badAnswerAudio.load()
      goodAnswerAudio.play()
      if( goodAnswers.indexOf(false) == -1 ) {
        allAnsweredProperly()
      } else {
        $('#modalCorrectAnswer').modal('show')
      }
    }else {
      badAnswers[questionNumber-1] += 1
      goodAnswerAudio.load()
      badAnswerAudio.play()
      $('#modalWrongAnswer').modal('show')
    }
  }


  var allAnsweredProperly = function() {
    var tableBodyHtml = '';
    for (var i=0; i<noOfQuestions; i++) {
      tableBodyHtml += '<tr><td>' + (i+1) + '</td><td>'
      tableBodyHtml += badAnswers[i]
      tableBodyHtml += '</td><td>'
      if(checkedAnswers[i]){
        tableBodyHtml += 'TAK'
      } else {
        tableBodyHtml += 'NIE'
      }
      tableBodyHtml += '</td>'
    }
    $('tbody', '#allEndedModal').html(tableBodyHtml)
    $('#allEndedModal').modal('show')
  }

  var prepareQuestionData = function() {
    $('.question-number').html(questionNumber)
    if(noOfQuestions == questionNumber){
      $('.next-question').addClass('disabled');
    } else {
      $('.next-question').removeClass('disabled');
    }
    if(1 == questionNumber){
      $('.prev-question').addClass('disabled');
    } else {
      $('.prev-question').removeClass('disabled');
    }
    $('#modalCorrectAnswer').modal('hide')

    if( goodAnswers[questionNumber-1] != true ){
      $('.question-section').addClass('hidden')
      $('.answer-section').addClass('hidden')
      $('.selected-images').html('')
      $('.play-section').removeClass('hidden')
    } else {
      $('.question-section').addClass('hidden')
      $('.play-section').addClass('hidden')
      $('.selected-images').html('')
      var index = 0
      _.each(answerData[questionNumber-1], function(img){
        $('.selected-images').append('<div class="image-container" data-answer-no="' + (index+1) + '"><img class="button-image" src="../files/img/anatomia/pamiec/' + img + '"></div>&nbsp;')
        $('.answer-section').removeClass('hidden')
        index += 1
      })
    }
    $('.question-section').html('')
    _.each(answerData[questionNumber-1], function(img){
      $('.question-section').append('<div class="col-xs-2 col-xs-for-8 answer-button"><div class="dummy"></div><a class="thumbnail"><div class="image-container"><img class="button-image" src="../files/img/anatomia/pamiec/' + img + '"></div></a> </div>')
    })
  }

  prepareQuestionData()
  $('.no-of-questions').html(noOfQuestions)

});