$( document ).ready(function() {

  var goodAnswerAudio = new Audio('../files/audio/ogolne/brawo.wav');
  var badAnswerAudio = new Audio('../files/audio/ogolne/sprobuj.wav');
  var questionAudio = new Audio('../files/audio/anatomia/policz/polecenie.wav');

  var badAnswers = [0,0,0,0,0,0,0]
  var answeredCorrectly = [false,false,false,false,false,false,false]
  var checkedAnswers = ['NIE','NIE','NIE','NIE','NIE','NIE','NIE']

  var noOfIterations = [2,4,7,5,8,6,10]

  questionNumber = 1
  noOfQuestions = 7

  var properAnswers = [2,4,7,5,8,6,10]

  $('.read-question').on('click', function(){
    questionAudio.play()
  })

  $('.next-question').on('click', function(event){
    event.preventDefault();
    questionNumber+=1;
    loadQuestionData()
  })

  $('.prev-question').on('click', function(event){
    event.preventDefault();
    questionNumber-=1;
    loadQuestionData()
  })

  $('.btn-policz.start').on('click', function(event){
    event.preventDefault();
    loadQuestionData()
    $('.answer-count').val('')
    $('.answer-count').focus()
    $('.answer').removeClass('correct-answer wrong-answer').addClass('hidden');
    drawQuestionIterations()
  })

  $('.btn-policz.stop').on('click', function(event){
    event.preventDefault()
    if (drawInterval)
      clearInterval(drawInterval)
    loadQuestionData()
    $('.answer-count').val('')
    $('.answer-count').focus()
    $('.answer').removeClass('correct-answer wrong-answer hidden')
  })

  $('.check-my-answer').on('click', function(event){
    event.preventDefault()
    if (parseInt($('.answer-count').val()) == properAnswers[questionNumber-1]) {
      badAnswerAudio.load()
      goodAnswerAudio.play()
      $('.answer').removeClass('wrong-answer').addClass('correct-answer')
      answeredCorrectly[questionNumber-1] = true
      checkIfShouldEnd()
    } else {
      $('.answer').removeClass('correct-answer').addClass('wrong-answer')
      goodAnswerAudio.load()
      badAnswerAudio.play()
      badAnswers[questionNumber-1] += 1
    }
  })

  $('.check-answer').on('click', function(event){
    event.preventDefault()
    badAnswerAudio.load()
    goodAnswerAudio.play()
    $('.answer').addClass('correct-answer').removeClass('hidden')
    checkedAnswers[questionNumber-1] = 'TAK'
    $('.answer-count').val(properAnswers[questionNumber-1])
    answeredCorrectly[questionNumber-1] = true
    checkIfShouldEnd()
  })

  var drawInterval = null
  var iteration = 1

  checkIfShouldEnd = function() {
    if (answeredCorrectly.indexOf(false) == -1) {
      var tableBodyHtml = '';
      for (var i=0; i<noOfQuestions; i++) {
        tableBodyHtml += '<tr><td>' + (i+1) + '</td><td>'
        tableBodyHtml += badAnswers[i]
        tableBodyHtml += '</td><td>'
        tableBodyHtml += checkedAnswers[i]
        tableBodyHtml += '</td>'
      }
      $('tbody', '#allEndedModal').html(tableBodyHtml)
      $('#allEndedModal').modal('show')
    }
  }

  drawIteration = function() {
    iterationItems = $('.' + questionNumber.toString() + '-' + iteration.toString())
    if (iteration > noOfIterations[questionNumber-1] && drawInterval) {
      clearInterval(drawInterval)
      $('.answer').removeClass('hidden')
      $('.answer-count').val('')
      $('.answer-count').focus()
      return
    }
    $(iterationItems).each(function(){
      $(this).addClass('close-eye', 400).delay(1000).removeClass('close-eye', 400)
    })
    iteration += 1
  }

  drawQuestionIterations = function() {
    iteration = 1
    if (drawInterval) {
      clearInterval(drawInterval)
    }
    drawIteration()
    drawInterval = setInterval(drawIteration, 2500)
  }

  loadQuestionData = function(){
    $('.question-number').text(questionNumber)
    $('.question-sum').text(noOfQuestions)
    $('.cf').removeClass('close-eye')
    $('.answer').removeClass('wrong-answer')
    if (answeredCorrectly[questionNumber-1] == true) {
      $('.answer').removeClass('hidden').addClass('correct-answer')
      $('.answer-count').val(properAnswers[questionNumber-1])
    } else {
      $('.answer').addClass('hidden')
      $('.answer').removeClass('correct-answer')
      $('.answer-count').val('')
    }
    if (questionNumber >= noOfQuestions)
      $('.next-question').addClass('disabled')
    else
      $('.next-question').removeClass('disabled')
    if (questionNumber > 1 || (questionNumber == 1 && noOfQuestions == 1))
      $('.prev-question').removeClass('disabled')
    else
      $('.prev-question').addClass('disabled')
  }

  loadQuestionData()
});