$( document ).ready(function() {

  var goodAnswerAudio = new Audio('../files/audio/ogolne/brawo.wav');
  var badAnswerAudio = new Audio('../files/audio/ogolne/sprobuj.wav');
  var questionAudio = new Audio('../files/audio/wynalazki/mnozenie/polecenie.wav');
  var checkedAnswers = 0
  var badAnswers = 0
  lastInputFocused = null

  $('.read-question').on('click', function(event){
    event.preventDefault()
    questionAudio.play()
  })

  $('.check-answer').on('click', function(event){
    event.preventDefault()
    if (lastInputFocused) {
      checkedAnswers += 1
      var i = 0
      interval = setInterval(function() {
        if (i%2 == 0)
          $(lastInputFocused).val($(lastInputFocused).attr('data-answer'))
        else
          $(lastInputFocused).val('')
        i++
        if (i == 6)
          clearInterval(interval)
      }, 500)
    }
  })

  $('input.answer-input').on('focus', function() {
    $(this).val('')
    lastInputFocused = $(this)
    $(this).removeClass('bad-answer')
  })

$('input.answer-input').on('blur', function() {
    val = $(this).val().toString()
    answer = $(this).attr('data-answer').toString()
    if (val.length > 0 && val != answer) {
        $(this).addClass('bad-answer')
    }
  })

  $('input.answer-input').on('keyup', function() {
    val = $(this).val().toString()
    answer = $(this).attr('data-answer').toString()
    if (val.length == answer.length) {
      if (val == answer) {
        badAnswerAudio.load()
        goodAnswerAudio.play()
        $(this).addClass('good-answer')
        checkIfShouldEnd()
      } else {
        goodAnswerAudio.load()
        badAnswerAudio.play()
        badAnswers += 1
      }
    }
  })

  checkIfShouldEnd = function() {
    if ($('input.answer-input').not('.good-answer').length == 0) {
      $('.wrong-answer-count').text(badAnswers)
      $('.checked-answer-count').text(checkedAnswers)
      $('#allEndedModal').modal('show')
    }
  }


})