$( document ).ready(function() {

// DATA
  var goodAnswerAudio = new Audio('../files/audio/ogolne/brawo.wav');
  var badAnswerAudio = new Audio('../files/audio/ogolne/sprobuj.wav');
  var questionAudio = new Audio('../files/audio/transport/quiz/polecenie_1.wav');

  var questionNumber = 1;
  var noOfQuestions = 12;

  var questionTypes = [
    'image',
    'image',
    'image',
    'image',
    'image',
    'image',
    'image',
    'image',
    'image',
    'image',
    'image',
    'image'
  ]

  var questions = {
    1: "Można wtedy jechać na nim kiedy kręci się nogami.",
    2: "Pod dowództwem kapitana. Płynie po morzach i oceanach.",
    3: "Postaw na niej jedną nogę, a natychmiast rusza w drogę.",
    4: "Nie mają kół, a jadą w dół. Po śniegu białym, torze wspaniałym.",
    5: "Żelazną szosą koła go niosą. Czerwone światło zatrzyma go łatwo.",
    6: "Nie jest ptakiem, lecz ma skrzydła. Możesz się nim, w podróż wybrać.",
    7: "Pędzi po szynach potwór rozpędzony. Sieje złote iskry i ciągnie wagony.",
    8: "Jaki ptak ma skrzydła, ale nie z piórek? Bardzo wysoko wzbija się w górę.",
    9: "Pływa po jeziorze. Opłynąć może świat! Stanie, gdy na nią, nie dmucha wiatr!",
    10: "Jakim to pojazdem, ciągniętym przez konie, podróżowali niegdyś królowie w koronie?",
    11: "Czytaj od początku albo wspak, nic nie szkodzi. I tak się nie zmieni nazwa znanej łodzi.",
    12: "Wiezie tłum podróżnych i wielkie bagaże, wszędzie, gdzie przewodnik jechać mu rozkaże."
  }

  var answers = {
    1: {
      0: ['samochód', 'rower', 'hulajnoga'],
      1: ['samochod.png', 'rower.png', 'hulajnoga.png'],
      2: ['samochod.wav', 'rower.wav', 'hulajnoga.wav']
    },
    2: {
      0: ['samochód', 'statek', 'hulajnoga'],
      1: ['samochod.png', 'statek.png', 'hulajnoga.png'],
      2: ['samochod.wav', 'statek.wav', 'hulajnoga.wav']
    },
    3: {
      0: ['samochód', 'statek', 'hulajnoga'],
      1: ['samochod.png', 'statek.png', 'hulajnoga.png'],
      2: ['samochod.wav', 'statek.wav', 'hulajnoga.wav']
    },
    4: {
      0: ['samochód', 'statek', 'sanki'],
      1: ['samochod.png', 'statek.png', 'sanki.png'],
      2: ['samochod.wav', 'statek.wav', 'sanki.wav']
    },
    5: {
      0: ['pociąg', 'kajak', 'sanki'],
      1: ['pociag.png', 'kajak.png', 'sanki.png'],
      2: ['pociag.wav', 'kajak.wav', 'sanki.wav']
    },
    6: {
      0: ['pociąg', 'statek', 'samolot'],
      1: ['pociag.png', 'statek.png', 'samolot.png'],
      2: ['pociag.wav', 'statek.wav', 'samolot.wav']
    },
    7: {
      0: ['samochód', 'lokomotywa', 'samolot'],
      1: ['samochod.png', 'lokomotywa.png', 'samolot.png'],
      2: ['samochod.wav', 'lokomotywa.wav', 'samolot.wav']
    },
    8: {
      0: ['pociąg', 'statek', 'samolot'],
      1: ['pociag.png', 'statek.png', 'samolot.png'],
      2: ['pociag.wav', 'statek.wav', 'samolot.wav']
    },
    9: {
      0: ['samochód', 'żaglówka', 'hulajnoga'],
      1: ['samochod.png', 'zaglowka.png', 'hulajnoga.png'],
      2: ['samochod.wav', 'zaglowka.wav', 'hulajnoga.wav']
    },
    10: {
      0: ['samochód', 'kareta', 'hulajnoga'],
      1: ['samochod.png', 'kareta.png', 'hulajnoga.png'],
      2: ['samochod.wav', 'kareta.wav', 'hulajnoga.wav']
    },
    11: {
      0: ['samochód', 'statek', 'kajak'],
      1: ['samochod.png', 'statek.png', 'kajak.png'],
      2: ['samochod.wav', 'statek.wav', 'kajak.wav']
    },
    12: {
      0: ['samochód', 'autokar', 'samolot'],
      1: ['samochod.png', 'autokar.png', 'samolot.png'],
      2: ['samochod.wav', 'autokar.wav', 'samolot.wav']
    }
  }

  var answerAudios = []

  var correctAnswerIndexes = {
    1: [2],
    2: [2],
    3: [3],
    4: [3],
    5: [1],
    6: [3],
    7: [2],
    8: [3],
    9: [2],
    10: [2],
    11: [3],
    12: [2]
  }

  var questionsFinished = []

  var answered = {
    1: [],
    2: [],
    3: [],
    4: [],
    5: [],
    6: [],
    7: [],
    8: [],
    9: [],
    10: [],
    11: [],
    12: []
  }

// MAIN LOGIC

  $( '.question-number' ).html( questionNumber );
  $( '.question-sum' ).html( noOfQuestions );
  $( '.question-text' ).html( questions[questionNumber] );

  $( 'body' ).on('click', '.next-question', function(event){
    event.preventDefault()
    if(questionNumber < noOfQuestions){
      questionNumber++;
      setPageDataForQuestion()
    }
    $('#modalCorrectAnswer').modal('hide')
  });

  $( '.prev-question' ).on('click', function(event){
    event.preventDefault()
    if(questionNumber > 1){
      questionNumber--;
      setPageDataForQuestion()
    }
  });

  $('.answer-audio').on('click', function(event){
    event.preventDefault();
    event.stopPropagation();
    var answerNo = parseInt($(this).attr('data-answer-no'));
    answerAudios[answerNo-1].play();
  })

  $( '.answer-button' ).on('click', function(event) {
    event.preventDefault()
    $('.wrong-answer').removeClass('wrong-answer')
    $('.last-answer').removeClass('last-answer')
    $(this).addClass('last-answer')
    var answerNo = parseInt($(this).attr('data-answer-no'))
    answered[questionNumber].push(answerNo)
    if(correctAnswerIndexes[questionNumber].indexOf(answerNo) !== -1) {
      $(this).addClass('correct-answer')
      badAnswerAudio.load()
      goodAnswerAudio.play()

      if(_.uniq(_.intersection(correctAnswerIndexes[questionNumber], answered[questionNumber])).length == correctAnswerIndexes[questionNumber].length) {

        //all correct answers selected
        if(questionsFinished.indexOf(questionNumber) == -1){
          questionsFinished.push(questionNumber)
        }
        if(!(questionsFinished.length === noOfQuestions)){
          if(questionNumber < noOfQuestions){
            showCorrectAnswerModal()
          }
        } else {
          fillEndModalAndShowIt()
        }

      }
    } else {
      goodAnswerAudio.load()
      badAnswerAudio.play()
      $(this).addClass('wrong-answer')
    }
  });

  $('.read-question').on('click', function(event) {
    event.preventDefault()
    questionAudio.play()
  })

  $('.check-answer').on('click', function(event) {
    event.preventDefault()
    $('.is-correct').toggleClass('correct-answer', 500).delay(500).toggleClass('correct-answer', 500).delay(500).toggleClass('correct-answer', 500).delay(500).toggleClass('correct-answer', 500).delay(500).toggleClass('correct-answer', 500).delay(500).toggleClass('correct-answer', 500)
  })

  var setPageDataForQuestion = function() {
    $( '.question-number' ).html(questionNumber );
    $( '.question-text' ).html(questions[questionNumber] );
    $( '.question-image').html('')

    questionAudio = new Audio('../files/audio/transport/quiz/polecenie_' + questionNumber + '.wav');

    if(questionTypes[questionNumber-1] === 'image'){
      setAnswerButtonsForImage()
    } else if(questionTypes[questionNumber-1] === 'text') {
      setAnswerButtonsForText()
    } else if(questionTypes[questionNumber-1] === 'text-with-image') {
      setAnswerButtonsForText()
      setImageForQuestion()
    }
    setAnswerAudiosButtons()
    if(questionNumber == noOfQuestions) {
      $( '.next-question' ).addClass('disabled')
    } else {
      $( '.next-question' ).removeClass('disabled');
    };
    if(questionNumber == 1) {
      $( '.prev-question' ).addClass('disabled');
    } else {
      $( '.prev-question' ).removeClass('disabled');
    }
    $('.wrong-answer').removeClass('wrong-answer')
    $('.last-answer').removeClass('last-answer')
  }

  var setAnswerAudiosButtons = function() {
    for (i = 0; i < 7; i++) {
      button = $('.answer-audio.aa-' + (i+1), '.answer-audios')
      if(answers[questionNumber][0][i]){
        $(button).removeClass('hide')
      } else {
        $(button).addClass('hide')
      }
    }
  }

  var setAnswerButtonsForText = function() {
    $('.answer-buttons-img').hide();
    $('.answer-buttons-txt').show();
    $('.answer-button').removeClass('is-correct')

    for (i = 0; i < 7; i++) {
      button = $('.answer-button.ab-' + (i+1), '.answer-buttons-txt')

      if(correctAnswerIndexes[questionNumber].indexOf(i+1) != -1){
        $(button).addClass('is-correct')
      }

      if(answers[questionNumber][0][i]){
        $(button).removeClass('hide')
        if(answered[questionNumber].indexOf(i+1) !== -1 && correctAnswerIndexes[questionNumber].indexOf(i+1) !== -1) {
          $(button).addClass('correct-answer')
        } else {
          $(button).removeClass('correct-answer')
        }
        $( '.text', $('a', button) ).html(answers[questionNumber][0][i]);
      } else {
        $(button).addClass('hide')
      }
    }
    setAnswerAudios(1)
  }

  var setImageForQuestion = function () {
    $( '.question-image').html('<img src="../files/img/transport/quiz/' + answers[questionNumber][2] + '">')
  }

  var setAnswerButtonsForImage = function() {
    $('.answer-buttons-txt').hide();
    $('.answer-buttons-img').show();
    $('.answer-button').removeClass('is-correct')
    for (i = 0; i < 7; i++) {
      button = $('.answer-button.ab-' + (i+1), '.answer-buttons-img')

      if(correctAnswerIndexes[questionNumber].indexOf(i+1) != -1){
        $(button).addClass('is-correct')
      }

      if(answers[questionNumber][1][i]){
        $(button).removeClass('hide')
        if(answered[questionNumber].indexOf(i+1) !== -1 && correctAnswerIndexes[questionNumber].indexOf(i+1) !== -1) {
          $(button).addClass('correct-answer')
        } else {
          $(button).removeClass('correct-answer')
        }
        $( '.button-image', button ).attr('src', '../files/img/transport/quiz/' + answers[questionNumber][1][i]);
        $( '.button-footer', button ).text(answers[questionNumber][0][i]);
      } else {
        $(button).addClass('hide')
      }
    }
    setAnswerAudios(2)
  }

  var setAnswerAudios = function(index){
    answerAudios = []
    for (i = 0; i < answers[questionNumber][index].length; i++) {
      answerAudios.push(new Audio('../files/audio/transport/quiz/' + answers[questionNumber][index][i]))
    }
  }

  var fillEndModalAndShowIt = function() {
    var tableBodyHtml = '';
    var i = 1;
    _.each(answered, function(yourAnswers){
      var yourAnswerTexts = []
      _.each(yourAnswers, function(answer) {
        if(correctAnswerIndexes[i].indexOf(answer) != -1){
          yourAnswerTexts.push('<span class="text-success">' + answers[i][0][answer-1] + '</span>')
        } else {
          yourAnswerTexts.push('<span class="text-danger">' + answers[i][0][answer-1] + '</span>')
        }
      })
      tableBodyHtml+='<tr><td>' + i + '</td><td>' + yourAnswers.length + '</td><td>' + _.difference(yourAnswers, correctAnswerIndexes[i]).length + '</td><td>' + yourAnswerTexts.join(', ') + '</td></tr>'
      i+=1;
    })
    $('tbody', '#quizEndedModal').html(tableBodyHtml)
    $('#quizEndedModal').modal('show')
  }

  var showCorrectAnswerModal = function(){
    $('#modalCorrectAnswer').modal('show')
  }



  setPageDataForQuestion()

});
