$( document ).ready(function() {

  var goodAnswerAudio = new Audio('../files/audio/ogolne/brawo.wav');
  var badAnswerAudio = new Audio('../files/audio/ogolne/sprobuj.wav');
  var questionAudio = new Audio('../files/audio/transport/policz/polecenie.wav');

  var questionNumber = 1
  var noOfQuestions = 11

  var checkedAnswers = [false, false, false, false, false, false, false, false, false, false, false]
  var badAnswers = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0]
  var goodAnswers = [false, false, false, false, false, false, false, false, false, false, false]

  var hours = [
    "5.00",
    "5.30",
    "6.00",
    "8.35",
    "9.30",
    "10.00",
    "11.40",
    "12.15",
    "13.55",
    "17.25",
    "12.58"
  ]

  $('.read-question').on('click', function(event){
    event.preventDefault()
    questionAudio.play()
  })

  $('.check-answer').on('click', function(event){
    event.preventDefault()
    checkedAnswers[questionNumber-1] = true
    $('.answer-' + questionNumber).addClass('good-answer', 500).removeClass('good-answer', 500).addClass('good-answer', 500).removeClass('good-answer', 500).addClass('good-answer', 500).removeClass('good-answer', 500)
  })

  $('.next-question').on('click', function(event){
    event.preventDefault();
    questionNumber+=1;
    prepareQuestionData()
  })

  $('.next-available-question').on('click', function(event){
    event.preventDefault();
    if (questionNumber == noOfQuestions)
      questionNumber = goodAnswers.indexOf(false)+1
    else
      questionNumber+=1;
    prepareQuestionData()
  })

  $('.prev-question').on('click', function(event){
    event.preventDefault();
    questionNumber-=1;
    prepareQuestionData()
  })

  $('div', '.policz-table').on('click', function(event) {
    if ($(this).hasClass('answer-' + questionNumber)) {
      $(this).addClass('good-answer')
      badAnswerAudio.load()
      goodAnswerAudio.play()
      goodAnswers[questionNumber-1] = true
      if (goodAnswers.indexOf(false) == -1)
        showFinishModal()
      else
        $('#modalCorrectAnswer').modal('show')
    } else {
      goodAnswerAudio.load()
      badAnswerAudio.play()
      badAnswers[questionNumber-1] += 1
    }
  })

  showFinishModal = function() {
    var tableBodyHtml = '';
    for (var i=0; i<noOfQuestions; i++) {
      tableBodyHtml += '<tr><td>' + (i+1) + '</td><td>'
      tableBodyHtml += badAnswers[i]
      tableBodyHtml += '</td><td>'
      if(checkedAnswers[i]){
        tableBodyHtml += 'TAK'
      } else {
        tableBodyHtml += 'NIE'
      }
      tableBodyHtml += '</td>'
    }
    $('tbody', '#allEndedModal').html(tableBodyHtml)
    $('#allEndedModal').modal('show')
  }


  var prepareQuestionData = function() {
    $('.question-number').html(questionNumber)
    if(noOfQuestions == questionNumber){
      $('.next-question').addClass('disabled');
    } else {
      $('.next-question').removeClass('disabled');
    }
    if(1 == questionNumber){
      $('.prev-question').addClass('disabled');
    } else {
      $('.prev-question').removeClass('disabled');
    }
    $('#modalCorrectAnswer').modal('hide')
    $('.hour').text(hours[questionNumber-1])
    $('.good-answer').removeClass('good-answer')
    if( goodAnswers[questionNumber-1] == true ){
      $('.answer-' + questionNumber).addClass('good-answer')
    }
  }

  prepareQuestionData()
  $('.no-of-questions').html(noOfQuestions)


})