$( document ).ready(function() {

// DATA
  var goodAnswerAudio = new Audio('../files/audio/ogolne/brawo.wav');
  var badAnswerAudio = new Audio('../files/audio/ogolne/sprobuj.wav');
  var questionAudio = new Audio('../files/audio/pocztowki/quiz/1.wav');

  var questionNumber = 1;
  var noOfQuestions = 14;

  var questionTypes = [
    'text',
    'text',
    'text',
    'text',
    'text',
    'text',
    'text',
    'text',
    'text',
    'text',
    'text',
    'text',
    'text',
    'text'
  ]
  var questions = {
    1: 'Stolica Włoch to',
    2: 'Stolica Chin to',
    3: 'Stolica Stanów Zjednoczonych to',
    4: 'Stolica Brazylii to',
    5: 'Stolica Australii to',
    6: 'Stolica Kenii to',
    7: 'Na jakim kontynencie leży Brazylia',
    8: 'Na jakim kontynencie leży Australia',
    9: 'Na jakim kontynencie leżą Chiny',
    10: 'Na jakim kontynencie leży Kenia',
    11: 'Na jakim kontynencie leży USA',
    12: 'Na jakim kontynencie leżą Włochy',
    13: 'W jakim mieście zobaczymy Statuę Wolności',
    14: 'W jakim kraju znajduje się największy mur świata?'
  }

  var answers = {
    1: {
      0: ["Neapol", "Mediolan", "Rzym"],
      1: ["neapol.wav", "mediolan.wav", "rzym.wav"]
    },
    2: {
      0: ["Tokio", "Pekin", "Ohara"],
      1: ["tokyo.wav", "pekin.wav", "ohara.wav"]
    },
    3: {
      0: ["Nowy Jork", "Chicago", "Waszyngton"],
      1: ["nowy_york.wav", "chicago.wav", "waszyngton.wav"]
    },
    4: {
      0: ["Manaus", "Belem", "Rio de Janeiro"],
      1: ["manaus.wav", "belem.wav", "rio.wav"]
    },
    5: {
      0: ["Melbourne", "Sydney", "Canberra"],
      1: ["melbourne.wav", "sydney.wav", "canberra.wav"]
    },
    6: {
      0: ["Nairobi", "Mombasa", "Kisumu"],
      1: ["nairobi.wav", "mombasa.wav", "kisumu.wav"]
    },
    7: {
      0: ["Ameryka Północna", "Ameryka Południowa", "Afryka"],
      1: ["ameryka_polnocna.wav", "ameryka_poludniowa.wav", "afryka.wav"]
    },
    8: {
      0: ["Ameryka Północna", "Australia", "Afryka"],
      1: ["ameryka_polnocna.wav", "australia.wav", "afryka.wav"]
    },
    9: {
      0: ["Azja", "Ameryka Południowa", "Europa"],
      1: ["azja.wav", "ameryka_poludniowa.wav", "europa.wav"]
    },
    10: {
      0: ["Ameryka Północna", "Azja", "Afryka"],
      1: ["ameryka_polnocna.wav", "azja.wav", "afryka.wav"]
    },
    11: {
      0: ["Ameryka Północna", "Ameryka Południowa", "Afryka"],
      1: ["ameryka_polnocna.wav", "ameryka_poludniowa.wav", "afryka.wav"]
    },
    12: {
      0: ["Europa", "Ameryka Południowa", "Afryka"],
      1: ["europa.wav", "ameryka_poludniowa.wav", "afryka.wav"]
    },
    13: {
      0: ["w Rzymie", "w Pekinie", "w Waszyngtonie"],
      1: ["w_rzymie.wav", "w_pekinie.wav", "w_waszyngtonie.wav"]
    },
    14: {
      0: ["w Brazylii", "w Chinach", "we Włoszech"],
      1: ["w_brazylii.wav", "w_chinach.wav", "we_wloszech.wav"]
    }
  }

  var answerAudios = []

  var correctAnswerIndexes = {
    1: [3],
    2: [2],
    3: [3],
    4: [3],
    5: [3],
    6: [1],
    7: [2],
    8: [2],
    9: [1],
    10: [3],
    11: [1],
    12: [1],
    13: [3],
    14: [2]
  }

  var questionsFinished = []

  var answered = {
    1: [],
    2: [],
    3: [],
    4: [],
    5: [],
    6: [],
    7: [],
    8: [],
    9: [],
    10: [],
    11: [],
    12: [],
    13: [],
    14: []
  }

// MAIN LOGIC

  $( '.question-number' ).html( questionNumber );
  $( '.question-sum' ).html( noOfQuestions );
  $( '.question-text' ).html( questions[questionNumber] );

  $( 'body' ).on('click', '.next-question', function(event){
    event.preventDefault()
    if(questionNumber < noOfQuestions){
      questionNumber++;
      setPageDataForQuestion()
    }
    $('#modalCorrectAnswer').modal('hide')
  });

  $( '.prev-question' ).on('click', function(event){
    event.preventDefault()
    if(questionNumber > 1){
      questionNumber--;
      setPageDataForQuestion()
    }
  });

  $('.answer-audio').on('click', function(event){
    event.preventDefault();
    event.stopPropagation();
    var answerNo = parseInt($(this).attr('data-answer-no'));
    answerAudios[answerNo-1].play();
  })

  $( '.answer-button' ).on('click', function(event) {
    event.preventDefault()
    $('.wrong-answer').removeClass('wrong-answer')
    $('.last-answer').removeClass('last-answer')
    $(this).addClass('last-answer')
    var answerNo = parseInt($(this).attr('data-answer-no'))
    answered[questionNumber].push(answerNo)
    if(correctAnswerIndexes[questionNumber].indexOf(answerNo) !== -1) {
      $(this).addClass('correct-answer')
      badAnswerAudio.load()
      goodAnswerAudio.play()

      if(_.uniq(_.intersection(correctAnswerIndexes[questionNumber], answered[questionNumber])).length == correctAnswerIndexes[questionNumber].length) {

        //all correct answers selected
        if(questionsFinished.indexOf(questionNumber) == -1){
          questionsFinished.push(questionNumber)
        }
        if(!(questionsFinished.length === noOfQuestions)){
          if(questionNumber < noOfQuestions){
            showCorrectAnswerModal()
          }
        } else {
          fillEndModalAndShowIt()
        }

      }
    } else {
      goodAnswerAudio.load()
      badAnswerAudio.play()
      $(this).addClass('wrong-answer')
    }
  });

  $('.read-question').on('click', function(event) {
    event.preventDefault()
    questionAudio.play()
  })

  $('.check-answer').on('click', function(event) {
    event.preventDefault()
    $('.is-correct').toggleClass('correct-answer', 500).delay(500).toggleClass('correct-answer', 500).delay(500).toggleClass('correct-answer', 500).delay(500).toggleClass('correct-answer', 500).delay(500).toggleClass('correct-answer', 500).delay(500).toggleClass('correct-answer', 500)
  })

  var setPageDataForQuestion = function() {
    $( '.question-number' ).html(questionNumber );
    $( '.question-text' ).html(questions[questionNumber] );
    $( '.question-image').html('')

    questionAudio = new Audio('../files/audio/pocztowki/quiz/' + questionNumber + '.wav');

    if(questionTypes[questionNumber-1] === 'image'){
      setAnswerButtonsForImage()
    } else if(questionTypes[questionNumber-1] === 'text') {
      setAnswerButtonsForText()
    } else if(questionTypes[questionNumber-1] === 'text-with-image') {
      setAnswerButtonsForText()
      setImageForQuestion()
    }
    setAnswerAudiosButtons()
    if(questionNumber == noOfQuestions) {
      $( '.next-question' ).addClass('disabled')
    } else {
      $( '.next-question' ).removeClass('disabled');
    };
    if(questionNumber == 1) {
      $( '.prev-question' ).addClass('disabled');
    } else {
      $( '.prev-question' ).removeClass('disabled');
    }
    $('.wrong-answer').removeClass('wrong-answer')
    $('.last-answer').removeClass('last-answer')
  }

  var setAnswerAudiosButtons = function() {
    for (i = 0; i < 7; i++) {
      button = $('.answer-audio.aa-' + (i+1), '.answer-audios')
      if(answers[questionNumber][0][i]){
        $(button).removeClass('hide')
      } else {
        $(button).addClass('hide')
      }
    }
  }

  var setAnswerButtonsForText = function() {
    $('.answer-buttons-img').hide();
    $('.answer-buttons-txt').show();
    $('.answer-button').removeClass('is-correct')

    for (i = 0; i < 7; i++) {
      button = $('.answer-button.ab-' + (i+1), '.answer-buttons-txt')

      if(correctAnswerIndexes[questionNumber].indexOf(i+1) != -1){
        $(button).addClass('is-correct')
      }

      if(answers[questionNumber][0][i]){
        $(button).removeClass('hide')
        if(answered[questionNumber].indexOf(i+1) !== -1 && correctAnswerIndexes[questionNumber].indexOf(i+1) !== -1) {
          $(button).addClass('correct-answer')
        } else {
          $(button).removeClass('correct-answer')
        }
        $( '.text', $('a', button) ).html(answers[questionNumber][0][i]);
      } else {
        $(button).addClass('hide')
      }
    }
    setAnswerAudios(1)
  }

  var setImageForQuestion = function () {
    $( '.question-image').html('<img src="../files/img/pocztowki/quiz/' + answers[questionNumber][2] + '">')
  }

  var setAnswerButtonsForImage = function() {
    $('.answer-buttons-txt').hide();
    $('.answer-buttons-img').show();
    $('.answer-button').removeClass('is-correct')
    for (i = 0; i < 7; i++) {
      button = $('.answer-button.ab-' + (i+1), '.answer-buttons-img')

      if(correctAnswerIndexes[questionNumber].indexOf(i+1) != -1){
        $(button).addClass('is-correct')
      }

      if(answers[questionNumber][1][i]){
        $(button).removeClass('hide')
        if(answered[questionNumber].indexOf(i+1) !== -1 && correctAnswerIndexes[questionNumber].indexOf(i+1) !== -1) {
          $(button).addClass('correct-answer')
        } else {
          $(button).removeClass('correct-answer')
        }
        $( '.button-image', button ).attr('src', '../files/img/pocztowki/quiz/' + answers[questionNumber][1][i]);
        $( '.button-footer', button ).text(answers[questionNumber][0][i]);
      } else {
        $(button).addClass('hide')
      }
    }
    setAnswerAudios(2)
  }

  var setAnswerAudios = function(index){
    answerAudios = []
    for (i = 0; i < answers[questionNumber][index].length; i++) {
      answerAudios.push(new Audio('../files/audio/pocztowki/quiz/' + answers[questionNumber][index][i]))
    }
  }

  var fillEndModalAndShowIt = function() {
    var tableBodyHtml = '';
    var i = 1;
    _.each(answered, function(yourAnswers){
      var yourAnswerTexts = []
      _.each(yourAnswers, function(answer) {
        if(correctAnswerIndexes[i].indexOf(answer) != -1){
          yourAnswerTexts.push('<span class="text-success">' + answers[i][0][answer-1] + '</span>')
        } else {
          yourAnswerTexts.push('<span class="text-danger">' + answers[i][0][answer-1] + '</span>')
        }
      })
      tableBodyHtml+='<tr><td>' + i + '</td><td>' + yourAnswers.length + '</td><td>' + _.difference(yourAnswers, correctAnswerIndexes[i]).length + '</td><td>' + yourAnswerTexts.join(', ') + '</td></tr>'
      i+=1;
    })
    $('tbody', '#quizEndedModal').html(tableBodyHtml)
    $('#quizEndedModal').modal('show')
  }

  var showCorrectAnswerModal = function(){
    $('#modalCorrectAnswer').modal('show')
  }



  setPageDataForQuestion()

});
