$( document ).ready(function() {

  var goodAnswerAudio = new Audio('../files/audio/ogolne/brawo.wav');
  var badAnswerAudio = new Audio('../files/audio/ogolne/sprobuj.wav');
  var questionAudio = new Audio('../files/audio/kosmos/dopasuj/polecenie.wav');

  var badAnswersCount = 0
  var checkedAnswer = 'NIE'

  $('.read-question').on('click', function(event){
    event.preventDefault()
    questionAudio.play()
  })

  $('.check-answer').on('click', function(event){
    event.preventDefault()
    checkedAnswer = 'TAK'
    $('.space-box.hide-proper').addClass('override-show', 500).delay(500).removeClass('override-show', 500).delay(500).addClass('override-show', 500).delay(500).removeClass('override-show', 500).delay(500).addClass('override-show', 500).delay(500).removeClass('override-show', 500).delay(500).addClass('override-show', 500).delay(500).removeClass('override-show', 500)
  })

  $('.thumbnail', '.answer-buttons-img').on('click', function(event) {
    event.preventDefault()
    if ($(this).hasClass('selected')) {
      $(this).removeClass('selected')
    }
    else {
      $('.selected', '.answer-buttons-img').removeClass('selected')
      $(this).addClass('selected')
      checkAnswerIfShould()
    }
  })

  $('.space-box').on('click', function(event) {
    event.preventDefault()
    if ($(this).hasClass('selected')) {
      $(this).removeClass('selected')
    }
    else {
      $('.space-box').removeClass('selected')
      $(this).addClass('selected')
      checkAnswerIfShould()
    }
  })

  checkAnswerIfShould = function() {
    answer = $('.selected', '.answer-buttons-img')
    box = $('.space-box.selected')
    if ($(answer).length > 0 && $(box).length > 0) {
      if ($(answer).attr('data-answer') == $(box).attr('data-answer')) {
        badAnswerAudio.load()
        goodAnswerAudio.play()
        setTimeout(function(){
          var planetAudio = new Audio('../files/audio/kosmos/dopasuj/' + $(box).attr('data-audio') + '.wav');
          planetAudio.play()
        }, 1000)
        $(box).removeClass('hide-proper')
        checkIfShouldEnd()
      } else {
        goodAnswerAudio.load()
        badAnswerAudio.play()
        badAnswersCount += 1
      }
      $('.selected').removeClass('selected')
    }
  }

  checkIfShouldEnd = function() {
    if ($('.space-box.hide-proper').length == 0) {
      showFinishModal()
    }
  }

  showFinishModal = function() {
    $('.wrong-answer-count').text(badAnswersCount)
    $('.checked-answer').text(checkedAnswer)
    $('#allEndedModal').modal('show')
  }

})