$( document ).ready(function() {

  var goodAnswerAudio = new Audio('../files/audio/ogolne/brawo.wav');
  var badAnswerAudio = new Audio('../files/audio/ogolne/sprobuj.wav');
  var questionAudio = new Audio('../files/audio/iluzja/mnozenie/polecenie.wav');
  var checkedAnswers = ['NIE', 'NIE', 'NIE', 'NIE', 'NIE', 'NIE', 'NIE', 'NIE']
  var badAnswers = [0, 0, 0, 0, 0, 0, 0, 0]

  var questionText = "Policz ile elementów znajduje się na tablicy. Aby ułatwić sobie zadanie skorzystaj z tabliczki mnożenia."

  var goodAnswers = [36, 40, 35, 49, 32, 40, 48, 81]
  var answeredCorrectly = [false, false, false, false, false, false, false, false]

  var questionNumber = 1
  var noOfQuestions = 8

  $('.read-question').on('click', function(event){
    event.preventDefault()
    questionAudio.play()
  })

  $('.check-answer').on('click', function(event){
    event.preventDefault()
    checkedAnswers[questionNumber-1] = 'TAK'
    var i = 0
    interval = setInterval(function() {
      if (i%2 == 0)
        $('.answer-box').val(goodAnswers[questionNumber-1])
      else
        $('.answer-box').val('')
      i++
      if (i == 6)
        clearInterval(interval)
    }, 500)
  })

  $('.next-question').on('click', function(event){
    event.preventDefault()
    if (questionNumber < noOfQuestions)
      questionNumber += 1
    loadQuestionData()
  })

  $('.prev-question').on('click', function(event){
    event.preventDefault()
    if (questionNumber > 0)
      questionNumber -= 1
    loadQuestionData()
  })

  $('.check-my-answer').on('click', function(event) {
    event.preventDefault()
    if (parseInt($('.answer-box').val()) == goodAnswers[questionNumber-1]) {
      badAnswerAudio.load()
      goodAnswerAudio.play()
      answeredCorrectly[questionNumber-1] = true
      $('.answer-box').parent().removeClass('wrong-answer').addClass('correct-answer')
      checkIfShouldEnd()
    } else {
      goodAnswerAudio.load()
      badAnswerAudio.play()
      badAnswers[questionNumber-1] += 1
      $('.answer-box').parent().removeClass('correct-answer').addClass('wrong-answer')
    }
  })

  checkIfShouldEnd = function() {
    if (answeredCorrectly.indexOf(false) == -1) {
      var tableBodyHtml = '';
      for (var i=0; i<noOfQuestions; i++) {
        tableBodyHtml += '<tr><td>' + (i+1) + '</td><td>'
        tableBodyHtml += badAnswers[i]
        tableBodyHtml += '</td><td>'
        tableBodyHtml += checkedAnswers[i]
        tableBodyHtml += '</td>'
      }
      $('tbody', '#allEndedModal').html(tableBodyHtml)
      $('#allEndedModal').modal('show')
    }
  }

  loadQuestionData = function(){
    $('.question-number').text(questionNumber)
    $('.question-sum').text(noOfQuestions)
    $('.question-text').text(questionText)
    $('.tabliczka').addClass('hidden')
    $('.round-' + questionNumber).removeClass('hidden')
    if (answeredCorrectly[questionNumber-1] == true) {
      $('.answer-box').val(goodAnswers[questionNumber-1])
      $('.answer-box').parent().removeClass('wrong-answer').addClass('correct-answer')
    } else {
      $('.answer-box').val('')
      $('.answer-box').parent().removeClass('correct-answer wrong-answer')
    }
    if (questionNumber >= noOfQuestions)
      $('.next-question').addClass('disabled')
    else
      $('.next-question').removeClass('disabled')
    if (questionNumber > 1 || (questionNumber == 1 && noOfQuestions == 1))
      $('.prev-question').removeClass('disabled')
    else
      $('.prev-question').addClass('disabled')
  }

  loadQuestionData()
})