$( document ).ready(function() {

  var goodAnswerAudio = new Audio('../files/audio/ogolne/brawo.wav');
  var badAnswerAudio = new Audio('../files/audio/ogolne/sprobuj.wav');
  var questionAudio = new Audio('../files/audio/geografia/dopasuj/polecenie.wav');

  var badAnswersCount = 0
  var checkedAnswer = 'NIE'

  $('.read-question').on('click', function(event){
    event.preventDefault()
    questionAudio.play()
  })

  $('.check-answer').on('click', function(event){
    event.preventDefault()
    checkedAnswer = 'TAK'
    $('.answer-button', '.answer-section').not('.used').addClass('used', 500).delay(500).removeClass('used', 500).delay(500).addClass('used', 500).delay(500).removeClass('used', 500).delay(500).addClass('used', 500).delay(500).removeClass('used', 500)
  })

  $('.answer-button', '.audios').on('click', function(event) {
    event.preventDefault()
    event.stopPropagation()
    var au = new Audio('../files/audio/geografia/dopasuj/' + $(this).attr('data-audio') + '.wav')
    au.play()
  })

  $('.answer-button', '.possibilities').on('click', function(event) {
    event.preventDefault()
    event.stopPropagation()
    if( $('.answer-button.selected', '.possibilities').length > 0 ){
      $('.answer-button.selected', '.possibilities').removeClass('selected')
    }
    $(this).addClass('selected')
    processAnswer()
  })

  $('.answer-button', '.answer-section').on('click', function(event) {
    event.preventDefault()
    event.stopPropagation()
    if (!$(this).hasClass('used')) {
      if( $('.answer-button.selected', '.answer-section').length > 0 ){
        $('.answer-button.selected', '.answer-section').removeClass('selected')
      }
      $(this).addClass('selected')
      processAnswer()
    }
  })

  processAnswer = function(){
    selectedAnswer = $('.answer-button.selected', '.answer-section')
    selectedPossibility = $('.answer-button.selected', '.possibilities')
    if ($(selectedAnswer).length > 0 && $(selectedPossibility).length > 0) {
      if ($(selectedAnswer).attr('data-answer-no') == $(selectedPossibility).attr('data-answer-no')) {
        badAnswerAudio.load()
        goodAnswerAudio.play()
        $(selectedAnswer).addClass('used').removeClass('selected')
        $(selectedPossibility).removeClass('selected')
        checkIfEnded()
      } else {
        goodAnswerAudio.load()
        badAnswerAudio.play()
        badAnswersCount += 1
        $(selectedAnswer).removeClass('selected')
        $(selectedPossibility).removeClass('selected')
      }
    }
  }

  checkIfEnded = function() {
    if( $('.answer-button', '.answer-section').not('.used').length == 0 ){
      $('.wrong-answer-count').text(badAnswersCount)
      $('.checked-answer').text(checkedAnswer)
      $('#allEndedModal').modal('show')
    }
  }

})