$( document ).ready(function() {

// DATA
  var goodAnswerAudio = new Audio('../files/audio/ogolne/brawo.wav');
  var badAnswerAudio = new Audio('../files/audio/ogolne/sprobuj.wav');
  var questionAudio = new Audio('../files/audio/geografia/quiz/polecenie_1.wav');

  var questionNumber = 1;
  var noOfQuestions = 14;

  var questionTypes = [
    'text',
    'text',
    'text',
    'text',
    'text',
    'text',
    'text',
    'text',
    'text',
    'text',
    'text',
    'text',
    'text',
    'text'
  ]

  var questions = {
    1: "Które z miast jest stolicą Polski?",
    2: "Które z miast jest stolicą Niemiec?",
    3: "Które z miast jest stolicą Francji?",
    4: "Które z miast jest stolicą Szwecji?",
    5: "Które z miast jest stolicą Rosji?",
    6: "Jakiego koloru nie znajdziesz na fladze Włoch?",
    7: "Jakiego koloru nie znajdziesz na fladze Francji?",
    8: "Jakiego koloru nie znajdziesz na fladze Szwecji?",
    9: "Jakiego koloru nie znajdziesz na fladze Rosji?",
    10: "Jakiego koloru nie znajdziesz na fladze Polski?",
    11: "Która z rzek nie płynie przez Europę?",
    12: "Które z gór nie leżą w Europie?",
    13: "Które z państw nie leży na terenie Europy?",
    14: "Jaka waluta używana jest we Francji?"
  }

  var answers = {
    1: {
      0: ["Kraków", "Wiedeń", "Warszawa"],
      1: ["krakow.wav", "wieden.wav", "warszawa.wav"]
    },
    2: {
      0: ["Wiedeń", "Berlin", "Monachium"],
      1: ["wieden.wav", "berlin.wav", "monachium.wav"]
    },
    3: {
      0: ["Paryż", "Berlin", "Wiedeń"],
      1: ["paryz.wav", "berlin.wav", "wieden.wav"]
    },
    4: {
      0: ["Paryż", "Berlin", "Sztokholm"],
      1: ["paryz.wav", "berlin.wav", "sztokholm.wav"]
    },
    5: {
      0: ["Paryż", "Moskwa", "Warszawa"],
      1: ["paryz.wav", "moskwa.wav", "warszawa.wav"]
    },
    6: {
      0: ["czerwonego", "zielonego", "żółtego"],
      1: ["czerwonego.wav", "zielonego.wav", "zoltego.wav"]
    },
    7: {
      0: ["czerwonego", "zielonego", "białego"],
      1: ["czerwonego.wav", "zielonego.wav", "bialego.wav"]
    },
    8: {
      0: ["czerwonego", "niebieskiego", "żółtego"],
      1: ["czerwonego.wav", "niebieskiego.wav", "zoltego.wav"]
    },
    9: {
      0: ["czerwonego", "białego", "żółtego"],
      1: ["czerwonego.wav", "bialego.wav", "zoltego.wav"]
    },
    10: {
      0: ["czerwonego", "białego", "żółtego"],
      1: ["czerwonego.wav", "bialego.wav", "zoltego.wav"]
    },
    11: {
      0: ["Dunaj", "Sekwana", "Nil"],
      1: ["dunaj.wav", "sekwana.wav", "nil.wav"]
    },
    12: {
      0: ["Andy", "Alpy", "Karpaty"],
      1: ["andy.wav", "alpy.wav", "karpaty.wav"]
    },
    13: {
      0: ["Niemcy", "Anglia", "Brazylia"],
      1: ["niemcy.wav", "anglia.wav", "brazylia.wav"]
    },
    14: {
      0: ["Funt", "Euro", "Marki"],
      1: ["funt.wav", "euro.wav", "marki.wav"]
    }
  }

  var answerAudios = []

  var correctAnswerIndexes = {
    1: [3],
    2: [2],
    3: [1],
    4: [3],
    5: [2],
    6: [3],
    7: [2],
    8: [1],
    9: [3],
    10: [3],
    11: [3],
    12: [1],
    13: [3],
    14: [2]
  }

  var questionsFinished = []

  var answered = {
    1: [],
    2: [],
    3: [],
    4: [],
    5: [],
    6: [],
    7: [],
    8: [],
    9: [],
    10: [],
    11: [],
    12: [],
    13: [],
    14: []
  }

// MAIN LOGIC

  $( '.question-number' ).html( questionNumber );
  $( '.question-sum' ).html( noOfQuestions );
  $( '.question-text' ).html( questions[questionNumber] );

  $( 'body' ).on('click', '.next-question', function(event){
    event.preventDefault()
    if(questionNumber < noOfQuestions){
      questionNumber++;
      setPageDataForQuestion()
    }
    $('#modalCorrectAnswer').modal('hide')
  });

  $( '.prev-question' ).on('click', function(event){
    event.preventDefault()
    if(questionNumber > 1){
      questionNumber--;
      setPageDataForQuestion()
    }
  });

  $('.answer-audio').on('click', function(event){
    event.preventDefault();
    event.stopPropagation();
    var answerNo = parseInt($(this).attr('data-answer-no'));
    answerAudios[answerNo-1].play();
  })

  $( '.answer-button' ).on('click', function(event) {
    event.preventDefault()
    $('.wrong-answer').removeClass('wrong-answer')
    $('.last-answer').removeClass('last-answer')
    $(this).addClass('last-answer')
    var answerNo = parseInt($(this).attr('data-answer-no'))
    answered[questionNumber].push(answerNo)
    if(correctAnswerIndexes[questionNumber].indexOf(answerNo) !== -1) {
      $(this).addClass('correct-answer')
      badAnswerAudio.load()
      goodAnswerAudio.play()

      if(_.uniq(_.intersection(correctAnswerIndexes[questionNumber], answered[questionNumber])).length == correctAnswerIndexes[questionNumber].length) {

        //all correct answers selected
        if(questionsFinished.indexOf(questionNumber) == -1){
          questionsFinished.push(questionNumber)
        }
        if(!(questionsFinished.length === noOfQuestions)){
          if(questionNumber < noOfQuestions){
            showCorrectAnswerModal()
          }
        } else {
          fillEndModalAndShowIt()
        }

      }
    } else {
      goodAnswerAudio.load()
      badAnswerAudio.play()
      $(this).addClass('wrong-answer')
    }
  });

  $('.read-question').on('click', function(event) {
    event.preventDefault()
    questionAudio.play()
  })

  $('.check-answer').on('click', function(event) {
    event.preventDefault()
    $('.is-correct').toggleClass('correct-answer', 500).delay(500).toggleClass('correct-answer', 500).delay(500).toggleClass('correct-answer', 500).delay(500).toggleClass('correct-answer', 500).delay(500).toggleClass('correct-answer', 500).delay(500).toggleClass('correct-answer', 500)
  })

  var setPageDataForQuestion = function() {
    $( '.question-number' ).html(questionNumber );
    $( '.question-text' ).html(questions[questionNumber] );
    $( '.question-image').html('')

    questionAudio = new Audio('../files/audio/geografia/quiz/polecenie_' + questionNumber + '.wav');

    if(questionTypes[questionNumber-1] === 'image'){
      setAnswerButtonsForImage()
    } else if(questionTypes[questionNumber-1] === 'text') {
      setAnswerButtonsForText()
    } else if(questionTypes[questionNumber-1] === 'text-with-image') {
      setAnswerButtonsForText()
      setImageForQuestion()
    }
    setAnswerAudiosButtons()
    if(questionNumber == noOfQuestions) {
      $( '.next-question' ).addClass('disabled')
    } else {
      $( '.next-question' ).removeClass('disabled');
    };
    if(questionNumber == 1) {
      $( '.prev-question' ).addClass('disabled');
    } else {
      $( '.prev-question' ).removeClass('disabled');
    }
    $('.wrong-answer').removeClass('wrong-answer')
    $('.last-answer').removeClass('last-answer')
  }

  var setAnswerAudiosButtons = function() {
    for (i = 0; i < 7; i++) {
      button = $('.answer-audio.aa-' + (i+1), '.answer-audios')
      if(answers[questionNumber][0][i]){
        $(button).removeClass('hide')
      } else {
        $(button).addClass('hide')
      }
    }
  }

  var setAnswerButtonsForText = function() {
    $('.answer-buttons-img').hide();
    $('.answer-buttons-txt').show();
    $('.answer-button').removeClass('is-correct')

    for (i = 0; i < 7; i++) {
      button = $('.answer-button.ab-' + (i+1), '.answer-buttons-txt')

      if(correctAnswerIndexes[questionNumber].indexOf(i+1) != -1){
        $(button).addClass('is-correct')
      }

      if(answers[questionNumber][0][i]){
        $(button).removeClass('hide')
        if(answered[questionNumber].indexOf(i+1) !== -1 && correctAnswerIndexes[questionNumber].indexOf(i+1) !== -1) {
          $(button).addClass('correct-answer')
        } else {
          $(button).removeClass('correct-answer')
        }
        $( '.text', $('a', button) ).html(answers[questionNumber][0][i]);
      } else {
        $(button).addClass('hide')
      }
    }
    setAnswerAudios(1)
  }

  var setImageForQuestion = function () {
    $( '.question-image').html('<img src="../files/img/geografia/quiz/' + answers[questionNumber][2] + '">')
  }

  var setAnswerButtonsForImage = function() {
    $('.answer-buttons-txt').hide();
    $('.answer-buttons-img').show();
    $('.answer-button').removeClass('is-correct')
    for (i = 0; i < 7; i++) {
      button = $('.answer-button.ab-' + (i+1), '.answer-buttons-img')

      if(correctAnswerIndexes[questionNumber].indexOf(i+1) != -1){
        $(button).addClass('is-correct')
      }

      if(answers[questionNumber][1][i]){
        $(button).removeClass('hide')
        if(answered[questionNumber].indexOf(i+1) !== -1 && correctAnswerIndexes[questionNumber].indexOf(i+1) !== -1) {
          $(button).addClass('correct-answer')
        } else {
          $(button).removeClass('correct-answer')
        }
        $( '.button-image', button ).attr('src', '../files/img/geografia/quiz/' + answers[questionNumber][1][i]);
        $( '.button-footer', button ).text(answers[questionNumber][0][i]);
      } else {
        $(button).addClass('hide')
      }
    }
    setAnswerAudios(2)
  }

  var setAnswerAudios = function(index){
    answerAudios = []
    for (i = 0; i < answers[questionNumber][index].length; i++) {
      answerAudios.push(new Audio('../files/audio/geografia/quiz/' + answers[questionNumber][index][i]))
    }
  }

  var fillEndModalAndShowIt = function() {
    var tableBodyHtml = '';
    var i = 1;
    _.each(answered, function(yourAnswers){
      var yourAnswerTexts = []
      _.each(yourAnswers, function(answer) {
        if(correctAnswerIndexes[i].indexOf(answer) != -1){
          yourAnswerTexts.push('<span class="text-success">' + answers[i][0][answer-1] + '</span>')
        } else {
          yourAnswerTexts.push('<span class="text-danger">' + answers[i][0][answer-1] + '</span>')
        }
      })
      tableBodyHtml+='<tr><td>' + i + '</td><td>' + yourAnswers.length + '</td><td>' + _.difference(yourAnswers, correctAnswerIndexes[i]).length + '</td><td>' + yourAnswerTexts.join(', ') + '</td></tr>'
      i+=1;
    })
    $('tbody', '#quizEndedModal').html(tableBodyHtml)
    $('#quizEndedModal').modal('show')
  }

  var showCorrectAnswerModal = function(){
    $('#modalCorrectAnswer').modal('show')
  }



  setPageDataForQuestion()

});
