;
(function($, window, document, undefined)
{
    var pluginName = "game",
        defaults = {
            photoHideTime: 30,
            elements: [
                {
                    img: "img/znaki/przejscie-dla-pieszych.png",
                    isOnPhoto: true,
                    audio: "sounds/error.mp3",
                    text: "przejście dla pieszych"
                },
                {
                    img: "img/znaki/droga-dla-rowerow.png",
                    isOnPhoto: true,
                    audio: "sounds/error.mp3",
                    text: "droga dla rowerów"
                },
                {
                    img: "img/znaki/zakaz-ruchu-pieszego.png",
                    isOnPhoto: true,
                    audio: "sounds/error.mp3",
                    text: "zakaz ruchu pieszego"
                },
                {
                    img: "img/znaki/ustap-pierwszenstwa.png",
                    isOnPhoto: true,
                    audio: "sounds/error.mp3",
                    text: "ustąp pierwszeństwa"
                },
                {
                    img: "img/znaki/pierwszenstwo-przejazdu.png",
                    isOnPhoto: true,
                    audio: "sounds/error.mp3",
                    text: "pierwszeństwo przejazdu"
                },
                {
                    img: "img/znaki/stop.png",
                    isOnPhoto: true,
                    audio: "sounds/error.mp3",
                    text: "stop"
                },
                {
                    img: "img/znaki/nakaz-jazdy-w-lewo.png",
                    isOnPhoto: false,
                    audio: false,
                    text: "nakaz jazdy w lewo"
                },
                {
                    img: "img/znaki/nakaz-jazdy-w-prawo.png",
                    isOnPhoto: false,
                    audio: false,
                    text: "nakaz jazdy w prawo"
                },
                {
                    img: "img/znaki/ograniczenie-predkosci.png",
                    isOnPhoto: false,
                    audio: false,
                    text: "ograniczenie prędkości"
                },
                {
                    img: "img/znaki/parking.png",
                    isOnPhoto: false,
                    audio: false,
                    text: "parking"
                },
                {
                    img: "img/znaki/rondo.png",
                    isOnPhoto: false,
                    audio: false,
                    text: "rondo"
                },
                {
                    img: "img/znaki/slepa-ulica.png",
                    isOnPhoto: false,
                    audio: false,
                    text: "ślepa ulica"
                },
                {
                    img: "img/znaki/sygnalizacja-swietlna.png",
                    isOnPhoto: false,
                    audio: false,
                    text: "sygnalizacja świetlna"
                },
                {
                    img: "img/znaki/zakaz-wjazdu.png",
                    isOnPhoto: false,
                    audio: false,
                    text: "zakaz wjazdu"
                },
                {
                    img: "img/znaki/zakaz-skretu-w-prawo.png",
                    isOnPhoto: false,
                    audio: false,
                    text: "zakaz skrętu w prawo"
                },
                {
                    img: "img/znaki/zakaz-skretu-w-lewo.png",
                    isOnPhoto: false,
                    audio: false,
                    text: "zakaz skrętu w lewo"
                },
                {
                    img: "img/znaki/zakaz-postoju.png",
                    isOnPhoto: false,
                    audio: false,
                    text: "zakaz postoju"
                }
            ]
        };

    function Plugin(element, options)
    {
        this.element = element;
        this.$element = $(element);
        this.settings = $.extend({}, defaults, options);
        this._defaults = defaults;
        this._name = pluginName;
        this.init();
    }

    $.extend(Plugin.prototype, {
        init: function()
        {
            var _this = this,
                audio = document.createElement('audio'),
                $element = $("<div><img src alt /><span class='name'></span></div>").addClass("element");

            this.clicks = 0;
            this.points = 0;
            this.supportsAudio = !!(audio.canPlayType && audio.canPlayType('audio/mpeg;').replace(/no/, ''));
            if(this.supportsAudio)
            {
                this.audio = new Audio();
            }

            $.each(this.settings.elements, function(i, obj)
            {
                var $el = $element.clone()
                    .find("img").attr("src", obj.img).end()
                    .find(".name").text(obj.text).end()
                    .attr("data-is-correct", obj.isOnPhoto ? 1 : "")
                    .attr("data-audio", obj.audio ? obj.audio : "")
                    .appendTo(_this.$element.find(".elements"));
            });

            this.$element.find(".element").randomize().on("click", function()
            {
                if($(this).hasClass("is-clicked"))
                {
                    return false;
                }
                _this.clicks += 1;

                var $this = $(this).addClass("is-clicked");
                if($this.attr("data-is-correct"))
                {
                    $this.addClass("is-correct");

                    if(_this.supportsAudio)
                    {
                        _this.audio.pause();
                        _this.audio.removeAttribute("src");
                        _this.audio.src = $this.attr("data-audio");
                        try
                        {
                            _this.audio.currentTime = 0;
                        }
                        catch(ex)
                        {

                        }
                        _this.audio.play();
                    }

                    _this.incPoints();
                }
                else
                {
                    $this.addClass("is-incorrect");
                }

                if(_this.clicks === 6)
                {
                    if(_this.points === 6){
                        _this.$element.find(".popup.popup-result, .popup-overlay").show();
                    }else{
                        _this.$element.find(".popup.popup-result-2, .popup-overlay").show();
                    }

                }
            });

            // start
            this.$element.find(".popup.popup-photo, .popup-overlay").show();

            var intervalID,
                seconds = _this.settings.photoHideTime;
            setTimeout(function()
            {
                clearInterval(intervalID);
                _this.$element.find(".popup.popup-photo, .popup-overlay").fadeOut("fast", function()
                {
                    _this.$element.find(".elements, .points").fadeIn("fast");
                });
            }, _this.settings.photoHideTime * 1000);
            intervalID = setInterval(function()
            {
                _this.$element.find(".counter").text(--seconds);
            }, 1000);

            this.$element.find(".see-again").on("click", function()
            {
                _this.$element.find(".popup.popup-only-photo, .popup-overlay").show();
                return false;
            });

            this.$element.find("#refresh").on("click", function()
            {
                window.location.reload();
                return false;
            });
        },
        incPoints: function()
        {
            var _this = this;
            this.points += 1;
            this.$element.find(".points.points-success, .summary-points").each(function()
            {
                $(this).text(_this.points);
            });
        },
        check: function()
        {

        }
    });
    $.fn.randomize = function(selector)
    {
        (selector ? this.find(selector) : this).parent().each(function()
        {
            $(this).children(selector).sort(function()
            {
                return Math.random() - Math.random();
            }).detach().appendTo(this);
        });

        return this;
    };
    $.fn[pluginName] = function(options)
    {
        this.each(function()
        {
            if(!$.data(this, "plugin_" + pluginName))
            {
                $.data(this, "plugin_" + pluginName, new Plugin(this, options));
            }
        });
        return this;
    };

})(jQuery, window, document);