;
(function($, window, document, undefined)
{
    var pluginName = "game",
        defaults = {
            elements: [
                {
                    img: "img/elements/arbuz.png"
                },
                {
                    img: "img/elements/brokul.png"
                },
                {
                    img: "img/elements/brzoskwinia.png"
                },
                {
                    img: "img/elements/burak.png"
                },
                {
                    img: "img/elements/cebula.png"
                },
                {
                    img: "img/elements/groszek.png"
                },
                {
                    img: "img/elements/gruszka.png"
                },
                {
                    img: "img/elements/jablko.png"
                },
                {
                    img: "img/elements/jagoda.png"
                },
                {
                    img: "img/elements/malina.png"
                },
                {
                    img: "img/elements/marchewka.png"
                },
                {
                    img: "img/elements/ogorki.png"
                },
                {
                    img: "img/elements/pietruszka.png"
                },
                {
                    img: "img/elements/pomidor.png"
                },
                {
                    img: "img/elements/salata.png"
                },
                {
                    img: "img/elements/seler.png"
                },
                {
                    img: "img/elements/truskawka.png"
                },
                {
                    img: "img/elements/winogron.png"
                },
                {
                    img: "img/elements/wisnia.png"
                },
                {
                    img: "img/elements/ziemniak.png"
                },
                {
                    img: "img/elements/sliwka.png"
                }
            ]
        };

    function Plugin(element, options)
    {
        this.element = element;
        this.$element = $(element);
        this.settings = $.extend({}, defaults, options);
        this._defaults = defaults;
        this._name = pluginName;
        this.init();
    }

    $.extend(Plugin.prototype, {
        init: function()
        {
            this.$element.find(".popup-instruction .start").on("click", function()
            {
                _this.$element.find(".popup.popup-instruction, .popup-overlay").hide();
                return false;
            });

            this.$element.find(".popup.popup-instruction, .popup-overlay").show();

            this.points = {
                player1: 0,
                player2: 0
            };
            this.currentPlayer = "1";
            this.$element.addClass("current-player-1");

            var _this = this,
                $element = $("<div><span class='number'/><img alt /></div>").addClass("element"),
                $equasion = $("<div><span class='text'></span><input type='text' /><a class='ready' href='#'>Gotowe</a></div>").addClass("equasion"),
                onReady = function onReady()
                {
                    var value = $(this).siblings('input').val();
                    if(value)
                    {
                        $(this).closest(".equasion").fadeOut("fast");

                        if(value === $(this).siblings('input').attr("data-correct-value"))
                        {
                            $(this).closest(".element")
                                .removeClass("result-incorrect")
                                .addClass("player-" + _this.currentPlayer).addClass("result-correct")
                                .draggable({
                                    containment: '#game',
                                    revert: "invalid",
                                    appendTo: _this.$element.find(".elements"),
                                    stop: function()
                                    {
                                        setTimeout(function()
                                        {
                                            _this.isEquasionVisible = false;
                                        }, 50);
                                    }
                                });
                        }
                        else
                        {
                            $(this).closest(".element").addClass("blocked-player-" + _this.currentPlayer).find("input").val("");
                            setTimeout(function()
                            {
                                _this.changePlayer();
                                _this.isEquasionVisible = false;
                            }, 3000);
                        }
                        _this.check();
                    }
                };

            $.each(this.settings.elements, function(key, obj)
            {
                var $el = $element.clone()
                        .find("span").text(key + 1).end()
                        .find("img").attr("src", obj.img).end()
                        .appendTo(_this.$element.find(".elements")),
                    equasion = _this.createEquasion(),
                    $eq = $equasion.clone()
                        .find(".text").text(equasion.equasion).end()
                        .find("input").attr("data-correct-value", equasion.result).end()
                        .appendTo($el);
            });

            $(".ready").on("click", onReady);

            this.$element.find(".element").randomize().on("click", function()
            {
                if(_this.isEquasionVisible || $(this).hasClass("blocked-player-" + _this.currentPlayer))
                {
                    return false;
                }

                $(this).addClass("is-equasion-visible").find(".equasion").show().end().find("input").trigger("focus");
                _this.isEquasionVisible = true;

                return false;
            });

            this.$element.find(".basket-1 .elements-wrapper").droppable({
                accept: '.element.player-1',
                drop: function(evt, ui)
                {
                    var elementsCount = $(this).find(".element").size(),
                    //top = elementsCount < 6 ? "5%" : "45%",
                    //left = ((elementsCount % 6 + 1) * 8) + "%",
                        $draggable = $(ui.draggable),
                        $this = $(this);

                    // position reset bug fix
                    /*$draggable.clone().appendTo($(this)).css({
                     top: top,
                     left: left
                     });
                     $draggable.remove();*/
                    $draggable.appendTo($this);
                    $this.closest(".basket").addClass("animated");
                    setTimeout(function()
                    {
                        $this.closest(".basket").removeClass("animated");
                    }, 1000);

                    $(this).parent().removeClass("active-drop");

                    _this.incPoints();
                    _this.check();
                    _this.changePlayer();
                },
                over: function(event, ui)
                {
                    $(this).parent().addClass('active-drop');
                },
                out: function(event, ui)
                {
                    $(this).parent().removeClass('active-drop');
                }
            });

            this.$element.find(".basket-2 .elements-wrapper").droppable({
                accept: '.element.player-2',
                drop: function(evt, ui)
                {
                    var elementsCount = $(this).find(".element").size(),
                    //top = elementsCount < 6 ? "5%" : "45%",
                    //left = ((elementsCount % 6 + 1) * 8) + "%",
                        $draggable = $(ui.draggable),
                        $this = $(this);

                    // position reset bug fix
                    /*$draggable.clone().appendTo($(this)).css({
                     top: top,
                     left: left
                     });
                     $draggable.remove();*/
                    $draggable.appendTo($this);
                    $this.closest(".basket").addClass("animated");
                    setTimeout(function()
                    {
                        $this.closest(".basket").removeClass("animated");
                    }, 1000);

                    $(this).parent().removeClass("active-drop");

                    _this.incPoints();
                    _this.check();
                    _this.changePlayer();
                },
                over: function(event, ui)
                {
                    $(this).parent().addClass('active-drop');
                },
                out: function(event, ui)
                {
                    $(this).parent().removeClass('active-drop');
                }
            });

            this.$element.find("#refresh").on("click", function()
            {
                window.location.reload();
                return false;
            });
        },
        check: function()
        {
            var playerWon;
            if(this.$element.find(".elements .element:not(.result-incorrect)").size() === 0)
            {
                playerWon = this.$element.find(".basket-1 .element").size() > this.$element.find(".basket-2 .element").size()
                    ? "1" : "2";
                this.$element.find(".popup .player").text(playerWon);
                this.$element.find(".popup, .popup-overlay").show();
            }
        },
        incPoints: function()
        {
            var points = this.$element.find(".points[data-player-id='"+this.currentPlayer+"']").text();
            points = parseInt(points);
            points += 1;
            this.$element.find(".points[data-player-id='" + this.currentPlayer + "']").text(points);
        },
        createEquasion: function()
        {
            var type = Math.random() > 0.5 ? "+" : "-",
                firstNumber, secondNumber,
                result;

            if(type === "+")
            {
                do
                {
                    firstNumber = Math.floor(Math.random() * 50 + 1);
                    secondNumber = Math.floor(Math.random() * 50 + 1);
                }
                while(firstNumber + secondNumber > 50);
            }
            else
            {
                do
                {
                    firstNumber = Math.floor(Math.random() * 50 + 1);
                    secondNumber = Math.floor(Math.random() * 50 + 1);
                }
                while(firstNumber - secondNumber < 0);
            }

            result = type === "+" ? firstNumber + secondNumber : firstNumber - secondNumber;
            return {
                equasion: firstNumber + (type === "+" ? " + " : " - ") + secondNumber + " = ",
                result: result
            }
        },
        changePlayer: function()
        {
            this.currentPlayer = this.currentPlayer === "1" ? "2" : "1";
            this.$element.find(".current-player").text("Gracz nr " + this.currentPlayer);
            this.$element.removeClass("current-player-1").removeClass("current-player-2").addClass("current-player-" + this.currentPlayer);
        }
    });
    $.fn.randomize = function(selector)
    {
        (selector ? this.find(selector) : this).parent().each(function()
        {
            $(this).children(selector).sort(function()
            {
                return Math.random() - Math.random();
            }).detach().appendTo(this);
        });

        return this;
    };
    $.fn[pluginName] = function(options)
    {
        this.each(function()
        {
            if(!$.data(this, "plugin_" + pluginName))
            {
                $.data(this, "plugin_" + pluginName, new Plugin(this, options));
            }
        });
        return this;
    };

})(jQuery, window, document);