/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath;

import org.scilab.forge.jlatexmath.Atom;
import org.scilab.forge.jlatexmath.Box;
import org.scilab.forge.jlatexmath.HorizontalBox;
import org.scilab.forge.jlatexmath.HorizontalRule;
import org.scilab.forge.jlatexmath.InvalidUnitException;
import org.scilab.forge.jlatexmath.SpaceAtom;
import org.scilab.forge.jlatexmath.StrutBox;
import org.scilab.forge.jlatexmath.TeXEnvironment;
import org.scilab.forge.jlatexmath.TeXFont;
import org.scilab.forge.jlatexmath.VerticalBox;

public class FractionAtom
extends Atom {
    private boolean noDefault = false;
    private int unit;
    private int numAlign = 2;
    private int denomAlign = 2;
    private Atom numerator;
    private Atom denominator;
    private float thickness;
    private float defFactor;
    private boolean defFactorSet = false;

    public FractionAtom(Atom atom, Atom atom2) {
        this(atom, atom2, true);
    }

    public FractionAtom(Atom atom, Atom atom2, boolean bl) {
        this(atom, atom2, !bl, 2, 0.0f);
    }

    public FractionAtom(Atom atom, Atom atom2, boolean bl, int n, float f) throws InvalidUnitException {
        SpaceAtom.checkUnit(n);
        this.numerator = atom;
        this.denominator = atom2;
        this.noDefault = bl;
        this.thickness = f;
        this.unit = n;
        this.type = 7;
    }

    public FractionAtom(Atom atom, Atom atom2, boolean bl, int n, int n2) {
        this(atom, atom2, bl);
        this.numAlign = this.checkAlignment(n);
        this.denomAlign = this.checkAlignment(n2);
    }

    public FractionAtom(Atom atom, Atom atom2, float f, int n, int n2) {
        this(atom, atom2, true, n, n2);
        this.defFactor = f;
        this.defFactorSet = true;
    }

    public FractionAtom(Atom atom, Atom atom2, int n, float f, int n2, int n3) {
        this(atom, atom2, n, f);
        this.numAlign = this.checkAlignment(n2);
        this.denomAlign = this.checkAlignment(n3);
    }

    public FractionAtom(Atom atom, Atom atom2, int n, float f) {
        this(atom, atom2, true, n, f);
    }

    private int checkAlignment(int n) {
        if (n == 0 || n == 1) {
            return n;
        }
        return 2;
    }

    public Box createBox(TeXEnvironment teXEnvironment) {
        float f;
        float f2;
        float f3;
        Box box;
        TeXFont teXFont = teXEnvironment.getTeXFont();
        int n = teXEnvironment.getStyle();
        float f4 = teXFont.getDefaultRuleThickness(n);
        this.thickness = this.noDefault ? (this.thickness *= SpaceAtom.getFactor(this.unit, teXEnvironment)) : (this.defFactorSet ? this.defFactor * f4 : f4);
        Box box2 = this.numerator == null ? new StrutBox(0.0f, 0.0f, 0.0f, 0.0f) : this.numerator.createBox(teXEnvironment.numStyle());
        Box box3 = box = this.denominator == null ? new StrutBox(0.0f, 0.0f, 0.0f, 0.0f) : this.denominator.createBox(teXEnvironment.denomStyle());
        if (box2.getWidth() < box.getWidth()) {
            box2 = new HorizontalBox(box2, box.getWidth(), this.numAlign);
        } else {
            box = new HorizontalBox(box, box2.getWidth(), this.denomAlign);
        }
        if (n < 2) {
            f3 = teXFont.getNum1(n);
            f2 = teXFont.getDenom1(n);
        } else {
            f2 = teXFont.getDenom2(n);
            f3 = this.thickness > 0.0f ? teXFont.getNum2(n) : teXFont.getNum3(n);
        }
        VerticalBox verticalBox = new VerticalBox();
        verticalBox.add(box2);
        float f5 = teXFont.getAxisHeight(n);
        if (this.thickness > 0.0f) {
            float f6 = n < 2 ? 3.0f * this.thickness : this.thickness;
            float f7 = this.thickness / 2.0f;
            f = f3 - box2.getDepth() - (f5 + f7);
            float f8 = f5 - f7 - (box.getHeight() - f2);
            float f9 = f6 - f;
            float f10 = f6 - f8;
            if (f9 > 0.0f) {
                f3 += f9;
                f += f9;
            }
            if (f10 > 0.0f) {
                f2 += f10;
                f8 += f10;
            }
            verticalBox.add(new StrutBox(0.0f, f, 0.0f, 0.0f));
            verticalBox.add(new HorizontalRule(this.thickness, box2.getWidth(), 0.0f));
            verticalBox.add(new StrutBox(0.0f, f8, 0.0f, 0.0f));
        } else {
            float f11 = n < 2 ? 7.0f * f4 : 3.0f * f4;
            float f12 = (f11 - (f = f3 - box2.getDepth() - (box.getHeight() - f2))) / 2.0f;
            if (f12 > 0.0f) {
                f3 += f12;
                f2 += f12;
                f += 2.0f * f12;
            }
            verticalBox.add(new StrutBox(0.0f, f, 0.0f, 0.0f));
        }
        verticalBox.add(box);
        verticalBox.setHeight(f3 + box2.getHeight());
        verticalBox.setDepth(f2 + box.getDepth());
        f = new SpaceAtom(0, 0.12f, 0.0f, 0.0f).createBox(teXEnvironment).getWidth();
        return new HorizontalBox(verticalBox, verticalBox.getWidth() + 2.0f * f, 2);
    }
}

