/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath.cache;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.scilab.forge.jlatexmath.ParseException;
import org.scilab.forge.jlatexmath.TeXFormula;
import org.scilab.forge.jlatexmath.TeXIcon;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JLaTeXMathCache {
    private static final AffineTransform identity = new AffineTransform();
    private static ConcurrentMap<CachedTeXFormula, SoftReference<CachedImage>> cache = new ConcurrentHashMap<CachedTeXFormula, SoftReference<CachedImage>>(128);
    private static int max = Integer.MAX_VALUE;
    private static ReferenceQueue queue = new ReferenceQueue();

    private JLaTeXMathCache() {
    }

    public static void setMaxCachedObjects(int n) {
        max = Math.max(n, 1);
        cache.clear();
        cache = new ConcurrentHashMap<CachedTeXFormula, SoftReference<CachedImage>>(max);
    }

    public static int[] getCachedTeXFormulaDimensions(String string, int n, int n2, int n3, int n4, Color color) throws ParseException {
        return JLaTeXMathCache.getCachedTeXFormulaDimensions(new CachedTeXFormula(string, n, n2, n3, n4, color));
    }

    public static int[] getCachedTeXFormulaDimensions(String string, int n, int n2, int n3) throws ParseException {
        return JLaTeXMathCache.getCachedTeXFormulaDimensions(string, n, 0, n2, n3, null);
    }

    public static int[] getCachedTeXFormulaDimensions(Object object) throws ParseException {
        if (object == null || !(object instanceof CachedTeXFormula)) {
            return new int[]{0, 0, 0};
        }
        CachedTeXFormula cachedTeXFormula = (CachedTeXFormula)object;
        SoftReference<CachedImage> softReference = (SoftReference<CachedImage>)cache.get(cachedTeXFormula);
        if (softReference == null || softReference.get() == null) {
            softReference = JLaTeXMathCache.makeImage(cachedTeXFormula);
        }
        return new int[]{cachedTeXFormula.width, cachedTeXFormula.height, cachedTeXFormula.depth};
    }

    public static Object getCachedTeXFormula(String string, int n, int n2, int n3, int n4, Color color) throws ParseException {
        CachedTeXFormula cachedTeXFormula = new CachedTeXFormula(string, n, n2, n3, n4, color);
        SoftReference<CachedImage> softReference = (SoftReference<CachedImage>)cache.get(cachedTeXFormula);
        if (softReference == null || softReference.get() == null) {
            softReference = JLaTeXMathCache.makeImage(cachedTeXFormula);
        }
        return cachedTeXFormula;
    }

    public static Object getCachedTeXFormula(String string, int n, int n2, int n3) throws ParseException {
        return JLaTeXMathCache.getCachedTeXFormula(string, n, 0, n2, n3, null);
    }

    public static void clearCache() {
        cache.clear();
    }

    public static void removeCachedTeXFormula(String string, int n, int n2, int n3, int n4, Color color) throws ParseException {
        cache.remove(new CachedTeXFormula(string, n, n2, n3, n4, color));
    }

    public static void removeCachedTeXFormula(String string, int n, int n2, int n3) throws ParseException {
        JLaTeXMathCache.removeCachedTeXFormula(string, n, 0, n2, n3, null);
    }

    public static void removeCachedTeXFormula(Object object) throws ParseException {
        if (object != null && object instanceof CachedTeXFormula) {
            cache.remove((CachedTeXFormula)object);
        }
    }

    public static Object paintCachedTeXFormula(String string, int n, int n2, int n3, int n4, Color color, Graphics2D graphics2D) throws ParseException {
        return JLaTeXMathCache.paintCachedTeXFormula(new CachedTeXFormula(string, n, n2, n3, n4, color), graphics2D);
    }

    public static Object paintCachedTeXFormula(String string, int n, int n2, int n3, Graphics2D graphics2D) throws ParseException {
        return JLaTeXMathCache.paintCachedTeXFormula(string, n, 0, n2, n3, null, graphics2D);
    }

    public static Object paintCachedTeXFormula(Object object, Graphics2D graphics2D) throws ParseException {
        if (object == null || !(object instanceof CachedTeXFormula)) {
            return null;
        }
        CachedTeXFormula cachedTeXFormula = (CachedTeXFormula)object;
        SoftReference<CachedImage> softReference = (SoftReference<CachedImage>)cache.get(cachedTeXFormula);
        if (softReference == null || softReference.get() == null) {
            softReference = JLaTeXMathCache.makeImage(cachedTeXFormula);
        }
        graphics2D.drawImage(softReference.get().image, identity, null);
        return cachedTeXFormula;
    }

    public static Image getCachedTeXFormulaImage(String string, int n, int n2, int n3, int n4, Color color) throws ParseException {
        return JLaTeXMathCache.getCachedTeXFormulaImage(new CachedTeXFormula(string, n, n2, n3, n4, color));
    }

    public static Image getCachedTeXFormulaImage(String string, int n, int n2, int n3) throws ParseException {
        return JLaTeXMathCache.getCachedTeXFormulaImage(string, n, 0, n2, n3, null);
    }

    public static Image getCachedTeXFormulaImage(Object object) throws ParseException {
        if (object == null || !(object instanceof CachedTeXFormula)) {
            return null;
        }
        CachedTeXFormula cachedTeXFormula = (CachedTeXFormula)object;
        SoftReference<CachedImage> softReference = (SoftReference<CachedImage>)cache.get(cachedTeXFormula);
        if (softReference == null || softReference.get() == null) {
            softReference = JLaTeXMathCache.makeImage(cachedTeXFormula);
        }
        return softReference.get().image;
    }

    private static SoftReference<CachedImage> makeImage(CachedTeXFormula cachedTeXFormula) throws ParseException {
        TeXFormula teXFormula = new TeXFormula(cachedTeXFormula.f);
        TeXIcon teXIcon = teXFormula.createTeXIcon(cachedTeXFormula.style, cachedTeXFormula.size, cachedTeXFormula.type, cachedTeXFormula.fgcolor);
        teXIcon.setInsets(new Insets(cachedTeXFormula.inset, cachedTeXFormula.inset, cachedTeXFormula.inset, cachedTeXFormula.inset));
        BufferedImage bufferedImage = new BufferedImage(teXIcon.getIconWidth(), teXIcon.getIconHeight(), 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        teXIcon.paintIcon(null, graphics2D, 0, 0);
        graphics2D.dispose();
        cachedTeXFormula.setDimensions(teXIcon.getIconWidth(), teXIcon.getIconHeight(), teXIcon.getIconDepth());
        SoftReference<CachedImage> softReference = new SoftReference<CachedImage>(new CachedImage(bufferedImage, cachedTeXFormula), queue);
        if (cache.size() >= max) {
            Iterator iterator;
            Reference reference;
            while ((reference = queue.poll()) != null) {
                iterator = (CachedImage)reference.get();
                if (iterator == null) continue;
                cache.remove(((CachedImage)((Object)iterator)).cachedTf);
            }
            iterator = cache.keySet().iterator();
            if (iterator.hasNext()) {
                CachedTeXFormula cachedTeXFormula2 = (CachedTeXFormula)iterator.next();
                SoftReference softReference2 = (SoftReference)cache.get(cachedTeXFormula2);
                if (softReference2 != null) {
                    softReference2.clear();
                }
                cache.remove(cachedTeXFormula2);
            }
        }
        cache.put(cachedTeXFormula, softReference);
        return softReference;
    }

    private static class CachedImage {
        Image image;
        CachedTeXFormula cachedTf;

        CachedImage(Image image, CachedTeXFormula cachedTeXFormula) {
            this.image = image;
            this.cachedTf = cachedTeXFormula;
        }
    }

    private static class CachedTeXFormula {
        String f;
        int style;
        int type;
        int size;
        int inset;
        int width = -1;
        int height;
        int depth;
        Color fgcolor;

        CachedTeXFormula(String string, int n, int n2, int n3, int n4, Color color) {
            this.f = string;
            this.style = n;
            this.type = n2;
            this.size = n3;
            this.inset = n4;
            this.fgcolor = color;
        }

        void setDimensions(int n, int n2, int n3) {
            this.width = n;
            this.height = n2;
            this.depth = n3;
        }

        public boolean equals(Object object) {
            if (object != null && object instanceof CachedTeXFormula) {
                boolean bl;
                CachedTeXFormula cachedTeXFormula = (CachedTeXFormula)object;
                boolean bl2 = bl = cachedTeXFormula.f.equals(this.f) && cachedTeXFormula.style == this.style && cachedTeXFormula.type == this.type && cachedTeXFormula.size == this.size && cachedTeXFormula.inset == this.inset && cachedTeXFormula.fgcolor.equals(this.fgcolor);
                if (bl) {
                    if (cachedTeXFormula.width == -1) {
                        cachedTeXFormula.width = this.width;
                        cachedTeXFormula.height = this.height;
                        cachedTeXFormula.depth = this.depth;
                    } else if (this.width == -1) {
                        this.width = cachedTeXFormula.width;
                        this.height = cachedTeXFormula.height;
                        this.depth = cachedTeXFormula.depth;
                    }
                }
                return bl;
            }
            return false;
        }

        public int hashCode() {
            return this.f.hashCode();
        }
    }
}

