/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.Kit;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Token;
import org.mozilla.javascript.UintMap;

public class Decompiler {
    public static final int ONLY_BODY_FLAG = 1;
    public static final int TO_SOURCE_FLAG = 2;
    public static final int INITIAL_INDENT_PROP = 1;
    public static final int INDENT_GAP_PROP = 2;
    public static final int CASE_GAP_PROP = 3;
    private static final int FUNCTION_END = 160;
    private char[] sourceBuffer = new char[128];
    private int sourceTop;
    private static final boolean printSource = false;

    String getEncodedSource() {
        return this.sourceToString(0);
    }

    int getCurrentOffset() {
        return this.sourceTop;
    }

    int markFunctionStart(int n) {
        int n2 = this.getCurrentOffset();
        this.addToken(108);
        this.append((char)n);
        return n2;
    }

    int markFunctionEnd(int n) {
        int n2 = this.getCurrentOffset();
        this.append('\u00a0');
        return n2;
    }

    void addToken(int n) {
        if (0 > n || n > 159) {
            throw new IllegalArgumentException();
        }
        this.append((char)n);
    }

    void addEOL(int n) {
        if (0 > n || n > 159) {
            throw new IllegalArgumentException();
        }
        this.append((char)n);
        this.append('\u0001');
    }

    void addName(String string) {
        this.addToken(39);
        this.appendString(string);
    }

    void addString(String string) {
        this.addToken(41);
        this.appendString(string);
    }

    void addRegexp(String string, String string2) {
        this.addToken(48);
        this.appendString('/' + string + '/' + string2);
    }

    void addNumber(double d) {
        this.addToken(40);
        long l = (long)d;
        if ((double)l != d) {
            l = Double.doubleToLongBits(d);
            this.append('D');
            this.append((char)(l >> 48));
            this.append((char)(l >> 32));
            this.append((char)(l >> 16));
            this.append((char)l);
        } else {
            if (l < 0L) {
                Kit.codeBug();
            }
            if (l <= 65535L) {
                this.append('S');
                this.append((char)l);
            } else {
                this.append('J');
                this.append((char)(l >> 48));
                this.append((char)(l >> 32));
                this.append((char)(l >> 16));
                this.append((char)l);
            }
        }
    }

    private void appendString(String string) {
        int n;
        int n2 = string.length();
        int n3 = 1;
        if (n2 >= 32768) {
            n3 = 2;
        }
        if ((n = this.sourceTop + n3 + n2) > this.sourceBuffer.length) {
            this.increaseSourceCapacity(n);
        }
        if (n2 >= 32768) {
            this.sourceBuffer[this.sourceTop] = (char)(0x8000 | n2 >>> 16);
            ++this.sourceTop;
        }
        this.sourceBuffer[this.sourceTop] = (char)n2;
        ++this.sourceTop;
        string.getChars(0, n2, this.sourceBuffer, this.sourceTop);
        this.sourceTop = n;
    }

    private void append(char c) {
        if (this.sourceTop == this.sourceBuffer.length) {
            this.increaseSourceCapacity(this.sourceTop + 1);
        }
        this.sourceBuffer[this.sourceTop] = c;
        ++this.sourceTop;
    }

    private void increaseSourceCapacity(int n) {
        int n2;
        if (n <= this.sourceBuffer.length) {
            Kit.codeBug();
        }
        if ((n2 = this.sourceBuffer.length * 2) < n) {
            n2 = n;
        }
        char[] cArray = new char[n2];
        System.arraycopy(this.sourceBuffer, 0, cArray, 0, this.sourceTop);
        this.sourceBuffer = cArray;
    }

    private String sourceToString(int n) {
        if (n < 0 || this.sourceTop < n) {
            Kit.codeBug();
        }
        return new String(this.sourceBuffer, n, this.sourceTop - n);
    }

    public static String decompile(String string, int n, UintMap uintMap) {
        int n2;
        int n3;
        int n4 = string.length();
        if (n4 == 0) {
            return "";
        }
        int n5 = uintMap.getInt(1, 0);
        if (n5 < 0) {
            throw new IllegalArgumentException();
        }
        int n6 = uintMap.getInt(2, 4);
        if (n6 < 0) {
            throw new IllegalArgumentException();
        }
        int n7 = uintMap.getInt(3, 2);
        if (n7 < 0) {
            throw new IllegalArgumentException();
        }
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = 0 != (n & 1);
        boolean bl2 = 0 != (n & 2);
        int n8 = 0;
        boolean bl3 = false;
        int n9 = 0;
        if (string.charAt(n9) == '\u0087') {
            ++n9;
            n3 = -1;
        } else {
            n3 = string.charAt(n9 + 1);
        }
        if (!bl2) {
            stringBuffer.append('\n');
            for (n2 = 0; n2 < n5; ++n2) {
                stringBuffer.append(' ');
            }
        } else if (n3 == 2) {
            stringBuffer.append('(');
        }
        block99: while (n9 < n4) {
            switch (string.charAt(n9)) {
                case '\u0096': 
                case '\u0097': {
                    stringBuffer.append(string.charAt(n9) == '\u0096' ? "get " : "set ");
                    ++n9;
                    n9 = Decompiler.printSourceString(string, n9 + 1, false, stringBuffer);
                    ++n9;
                    break;
                }
                case '\'': 
                case '0': {
                    n9 = Decompiler.printSourceString(string, n9 + 1, false, stringBuffer);
                    continue block99;
                }
                case ')': {
                    n9 = Decompiler.printSourceString(string, n9 + 1, true, stringBuffer);
                    continue block99;
                }
                case '(': {
                    n9 = Decompiler.printSourceNumber(string, n9 + 1, stringBuffer);
                    continue block99;
                }
                case '-': {
                    stringBuffer.append("true");
                    break;
                }
                case ',': {
                    stringBuffer.append("false");
                    break;
                }
                case '*': {
                    stringBuffer.append("null");
                    break;
                }
                case '+': {
                    stringBuffer.append("this");
                    break;
                }
                case 'l': {
                    ++n9;
                    stringBuffer.append("function ");
                    break;
                }
                case '\u00a0': {
                    break;
                }
                case 'X': {
                    stringBuffer.append(", ");
                    break;
                }
                case 'T': {
                    ++n8;
                    if (1 == Decompiler.getNext(string, n4, n9)) {
                        n5 += n6;
                    }
                    stringBuffer.append('{');
                    break;
                }
                case 'U': {
                    if (bl && --n8 == 0) break;
                    stringBuffer.append('}');
                    switch (Decompiler.getNext(string, n4, n9)) {
                        case 1: 
                        case 160: {
                            n5 -= n6;
                            break;
                        }
                        case 112: 
                        case 116: {
                            n5 -= n6;
                            stringBuffer.append(' ');
                        }
                    }
                    break;
                }
                case 'V': {
                    stringBuffer.append('(');
                    break;
                }
                case 'W': {
                    stringBuffer.append(')');
                    if (84 != Decompiler.getNext(string, n4, n9)) break;
                    stringBuffer.append(' ');
                    break;
                }
                case 'R': {
                    stringBuffer.append('[');
                    break;
                }
                case 'S': {
                    stringBuffer.append(']');
                    break;
                }
                case '\u0001': {
                    int n10;
                    if (bl2) break;
                    n2 = 1;
                    if (!bl3) {
                        bl3 = true;
                        if (bl) {
                            stringBuffer.setLength(0);
                            n5 -= n6;
                            n2 = 0;
                        }
                    }
                    if (n2 != 0) {
                        stringBuffer.append('\n');
                    }
                    if (n9 + 1 >= n4) break;
                    int n11 = 0;
                    char c = string.charAt(n9 + 1);
                    if (c == 'r' || c == 's') {
                        n11 = n6 - n7;
                    } else if (c == 'U') {
                        n11 = n6;
                    } else if (c == '\'' && string.charAt(n10 = Decompiler.getSourceStringEnd(string, n9 + 2)) == 'f') {
                        n11 = n6;
                    }
                    while (n11 < n5) {
                        stringBuffer.append(' ');
                        ++n11;
                    }
                    break;
                }
                case 'k': {
                    stringBuffer.append('.');
                    break;
                }
                case '\u001e': {
                    stringBuffer.append("new ");
                    break;
                }
                case '\u001f': {
                    stringBuffer.append("delete ");
                    break;
                }
                case 'o': {
                    stringBuffer.append("if ");
                    break;
                }
                case 'p': {
                    stringBuffer.append("else ");
                    break;
                }
                case 'v': {
                    stringBuffer.append("for ");
                    break;
                }
                case '4': {
                    stringBuffer.append(" in ");
                    break;
                }
                case 'z': {
                    stringBuffer.append("with ");
                    break;
                }
                case 't': {
                    stringBuffer.append("while ");
                    break;
                }
                case 'u': {
                    stringBuffer.append("do ");
                    break;
                }
                case 'P': {
                    stringBuffer.append("try ");
                    break;
                }
                case '{': {
                    stringBuffer.append("catch ");
                    break;
                }
                case '|': {
                    stringBuffer.append("finally ");
                    break;
                }
                case '2': {
                    stringBuffer.append("throw ");
                    break;
                }
                case 'q': {
                    stringBuffer.append("switch ");
                    break;
                }
                case 'w': {
                    stringBuffer.append("break");
                    if (39 != Decompiler.getNext(string, n4, n9)) break;
                    stringBuffer.append(' ');
                    break;
                }
                case 'x': {
                    stringBuffer.append("continue");
                    if (39 != Decompiler.getNext(string, n4, n9)) break;
                    stringBuffer.append(' ');
                    break;
                }
                case 'r': {
                    stringBuffer.append("case ");
                    break;
                }
                case 's': {
                    stringBuffer.append("default");
                    break;
                }
                case '\u0004': {
                    stringBuffer.append("return");
                    if (81 == Decompiler.getNext(string, n4, n9)) break;
                    stringBuffer.append(' ');
                    break;
                }
                case 'y': {
                    stringBuffer.append("var ");
                    break;
                }
                case '\u0098': {
                    stringBuffer.append("let ");
                    break;
                }
                case 'Q': {
                    stringBuffer.append(';');
                    if (1 == Decompiler.getNext(string, n4, n9)) break;
                    stringBuffer.append(' ');
                    break;
                }
                case 'Y': {
                    stringBuffer.append(" = ");
                    break;
                }
                case '`': {
                    stringBuffer.append(" += ");
                    break;
                }
                case 'a': {
                    stringBuffer.append(" -= ");
                    break;
                }
                case 'b': {
                    stringBuffer.append(" *= ");
                    break;
                }
                case 'c': {
                    stringBuffer.append(" /= ");
                    break;
                }
                case 'd': {
                    stringBuffer.append(" %= ");
                    break;
                }
                case 'Z': {
                    stringBuffer.append(" |= ");
                    break;
                }
                case '[': {
                    stringBuffer.append(" ^= ");
                    break;
                }
                case '\\': {
                    stringBuffer.append(" &= ");
                    break;
                }
                case ']': {
                    stringBuffer.append(" <<= ");
                    break;
                }
                case '^': {
                    stringBuffer.append(" >>= ");
                    break;
                }
                case '_': {
                    stringBuffer.append(" >>>= ");
                    break;
                }
                case 'e': {
                    stringBuffer.append(" ? ");
                    break;
                }
                case 'B': {
                    stringBuffer.append(':');
                    break;
                }
                case 'f': {
                    if (1 == Decompiler.getNext(string, n4, n9)) {
                        stringBuffer.append(':');
                        break;
                    }
                    stringBuffer.append(" : ");
                    break;
                }
                case 'g': {
                    stringBuffer.append(" || ");
                    break;
                }
                case 'h': {
                    stringBuffer.append(" && ");
                    break;
                }
                case '\t': {
                    stringBuffer.append(" | ");
                    break;
                }
                case '\n': {
                    stringBuffer.append(" ^ ");
                    break;
                }
                case '\u000b': {
                    stringBuffer.append(" & ");
                    break;
                }
                case '.': {
                    stringBuffer.append(" === ");
                    break;
                }
                case '/': {
                    stringBuffer.append(" !== ");
                    break;
                }
                case '\f': {
                    stringBuffer.append(" == ");
                    break;
                }
                case '\r': {
                    stringBuffer.append(" != ");
                    break;
                }
                case '\u000f': {
                    stringBuffer.append(" <= ");
                    break;
                }
                case '\u000e': {
                    stringBuffer.append(" < ");
                    break;
                }
                case '\u0011': {
                    stringBuffer.append(" >= ");
                    break;
                }
                case '\u0010': {
                    stringBuffer.append(" > ");
                    break;
                }
                case '5': {
                    stringBuffer.append(" instanceof ");
                    break;
                }
                case '\u0012': {
                    stringBuffer.append(" << ");
                    break;
                }
                case '\u0013': {
                    stringBuffer.append(" >> ");
                    break;
                }
                case '\u0014': {
                    stringBuffer.append(" >>> ");
                    break;
                }
                case ' ': {
                    stringBuffer.append("typeof ");
                    break;
                }
                case '}': {
                    stringBuffer.append("void ");
                    break;
                }
                case '\u0099': {
                    stringBuffer.append("const ");
                    break;
                }
                case 'H': {
                    stringBuffer.append("yield ");
                    break;
                }
                case '\u001a': {
                    stringBuffer.append('!');
                    break;
                }
                case '\u001b': {
                    stringBuffer.append('~');
                    break;
                }
                case '\u001c': {
                    stringBuffer.append('+');
                    break;
                }
                case '\u001d': {
                    stringBuffer.append('-');
                    break;
                }
                case 'i': {
                    stringBuffer.append("++");
                    break;
                }
                case 'j': {
                    stringBuffer.append("--");
                    break;
                }
                case '\u0015': {
                    stringBuffer.append(" + ");
                    break;
                }
                case '\u0016': {
                    stringBuffer.append(" - ");
                    break;
                }
                case '\u0017': {
                    stringBuffer.append(" * ");
                    break;
                }
                case '\u0018': {
                    stringBuffer.append(" / ");
                    break;
                }
                case '\u0019': {
                    stringBuffer.append(" % ");
                    break;
                }
                case '\u008f': {
                    stringBuffer.append("::");
                    break;
                }
                case '\u008e': {
                    stringBuffer.append("..");
                    break;
                }
                case '\u0091': {
                    stringBuffer.append(".(");
                    break;
                }
                case '\u0092': {
                    stringBuffer.append('@');
                    break;
                }
                default: {
                    throw new RuntimeException("Token: " + Token.name(string.charAt(n9)));
                }
            }
            ++n9;
        }
        if (!bl2) {
            if (!bl) {
                stringBuffer.append('\n');
            }
        } else if (n3 == 2) {
            stringBuffer.append(')');
        }
        return stringBuffer.toString();
    }

    private static int getNext(String string, int n, int n2) {
        return n2 + 1 < n ? (int)string.charAt(n2 + 1) : 0;
    }

    private static int getSourceStringEnd(String string, int n) {
        return Decompiler.printSourceString(string, n, false, null);
    }

    private static int printSourceString(String string, int n, boolean bl, StringBuffer stringBuffer) {
        int n2 = string.charAt(n);
        ++n;
        if ((0x8000 & n2) != 0) {
            n2 = (Short.MAX_VALUE & n2) << 16 | string.charAt(n);
            ++n;
        }
        if (stringBuffer != null) {
            String string2 = string.substring(n, n + n2);
            if (!bl) {
                stringBuffer.append(string2);
            } else {
                stringBuffer.append('\"');
                stringBuffer.append(ScriptRuntime.escapeString(string2));
                stringBuffer.append('\"');
            }
        }
        return n + n2;
    }

    private static int printSourceNumber(String string, int n, StringBuffer stringBuffer) {
        double d = 0.0;
        char c = string.charAt(n);
        ++n;
        if (c == 'S') {
            if (stringBuffer != null) {
                char c2 = string.charAt(n);
                d = c2;
            }
            ++n;
        } else if (c == 'J' || c == 'D') {
            if (stringBuffer != null) {
                long l = (long)string.charAt(n) << 48;
                l |= (long)string.charAt(n + 1) << 32;
                l |= (long)string.charAt(n + 2) << 16;
                d = c == 'J' ? (double)l : Double.longBitsToDouble(l |= (long)string.charAt(n + 3));
            }
            n += 4;
        } else {
            throw new RuntimeException();
        }
        if (stringBuffer != null) {
            stringBuffer.append(ScriptRuntime.numberToString(d, 10));
        }
        return n;
    }
}

