<?php


$hassidepre = $PAGE->blocks->region_has_content('side-pre', $OUTPUT);
$hassidepost = $PAGE->blocks->region_has_content('side-post', $OUTPUT);
$showsidepre = $hassidepre && !$PAGE->blocks->region_completely_docked('side-pre', $OUTPUT);
$showsidepost = $hassidepost && !$PAGE->blocks->region_completely_docked('side-post', $OUTPUT);

$hastagline = (!empty($PAGE->theme->settings->tagline));

$custommenu = $OUTPUT->custom_menu();
$hascustommenu = (empty($PAGE->layout_options['nocustommenu']) && !empty($custommenu));

$bodyclasses = array();
if ($showsidepre && !$showsidepost) {
    $bodyclasses[] = 'side-pre-only';
} else if ($showsidepost && !$showsidepre) {
    $bodyclasses[] = 'side-post-only';
} else if (!$showsidepost && !$showsidepre) {
    $bodyclasses[] = 'content-only';
}
if ($hascustommenu) {
    $bodyclasses[] = 'has_custom_menu';
}

if (!isloggedin()) {
    $path = $CFG->wwwroot.'/course/index.php';
    header("Location:  $path");
}

echo $OUTPUT->doctype() ?>
<html <?php echo $OUTPUT->htmlattributes() ?>>
<head>
    <title><?php echo $PAGE->title ?></title>
    <link rel="shortcut icon" href="<?php echo $OUTPUT->pix_url('favicon', 'theme')?>" />
    <meta name="description" content="<?php p(strip_tags(format_text($SITE->summary, FORMAT_HTML))) ?>" />
    <?php echo $OUTPUT->standard_head_html() ?>
</head>
<body id="<?php p($PAGE->bodyid) ?>" class="<?php p($PAGE->bodyclasses.' '.join(' ', $bodyclasses)) ?>">
<?php echo $OUTPUT->standard_top_of_body_html() ?>

<div id="page">

<div id="page-header">

        <div class="rounded-corner top-left"></div>
        <div class="rounded-corner top-right"></div>
		<a href="/"><div id="logo"></div></a>
		<div id="title-header">
		</div>
        <div class="headermenu"><?php
            echo $OUTPUT->login_info();
           // echo $OUTPUT->lang_menu();
            //echo $PAGE->headingmenu;
        ?></div>

        <?php if ($hastagline) { ?>
            <h2 class="tagline"><?php echo $PAGE->theme->settings->tagline;?></h2>
        <?php } ?>


        <?php
    if ($hascustommenu) { ?>
        <div id="custommenu"><?php echo $custommenu; ?></div>
        <?php
    } ?>

</div>
<!-- END OF HEADER -->



    <div id="page-content">	        
        <div id="region-main-box">
            <div id="region-post-box">

                <div id="region-main-wrap">
                    <div id="region-main">
                        <div class="region-content">
						<div id="welcone_message">
						  <div style="height:205px;"  id="wm-text">
						  </div>	
						
						  <a href="" id="button_czytaj_wiecej">czytaj więcej</a>
						  <a href="http://pinap.czn.uj.edu.pl/course/index.php" id="button_projekt_pinap">projekt pinap</a>
						</div>
                            <?php echo $OUTPUT->main_content() ?>
                        </div>
                    </div>
                </div>

                <?php if ($hassidepre) { ?>
                <div id="region-pre" class="block-region">
                    <div class="region-content">
                        <?php echo $OUTPUT->blocks_for_region('side-pre') ?>
                    </div>
                </div>
                <?php } ?>

                <?php if ($hassidepost) { ?>
                <div id="region-post" class="block-region">
                    <div class="region-content">
                        <?php echo $OUTPUT->blocks_for_region('side-post') ?>
                    </div>
                </div>
                <?php } ?>

            </div>
        </div>
    </div>

<!-- START OF FOOTER -->
    <div id="page-footer">
<div id="stopka">
<div id="finansowanie"><p>Projekt współfinansowany ze środków Unii Europejskiej w ramach Europejskiego Funduszu Społecznego</p>
</div>


<div id="stopka_pinap">Biuro Projektu PINaP: Uniwersytet Jagielloński, Instytut Geografii i Gospodarki Przestrzennej,<br />
<br />
Adres: ul. Gronostajowa 7,<br />
pok. 2.17, 30-387 Kraków,<br />
<br />
tel. (12) 664 63 08,<br />
fax (12) 664 51 08;<br />
e-mail: pinap@uj.edu.pl</div>
<a href="" id="button_czytaj_wiecej_stopka">czytaj więcej</a>
<p id="wykonal">wykonanie: Centrum Zdalnego Nauczania</p>
</div> 
 
    </div>
    <div class="clearfix"></div>
</div>
<?php echo $OUTPUT->standard_end_of_body_html() ?>
</body>
</html>
