$(document).ready(function () {
    $('#game').Game();
});

gameId = 'A';
gameNr = 4;

(function ($, f) {

    if (!$)
        return f;

    var Game = function ()
    {
        var __ = this;
        __.canvas = false;

        this.init = function (el)
        {
            window.bootstrap();

            if (typeof el === 'undefined')
                return f;

            __.canvas = el;
            __.cWidth = parseInt(__.canvas.css('width'));
            __.cHeight = parseInt(__.canvas.css('height'));

            __.gameId = window.gameId;
            __.gameNr = window.gameNr;

            initBackground(__);
            loadAudioForGame(__);
            loadBgAudio(__);
            __.initKids();

            /*~~~~~~~~~~~~~~~~~~~~~~~*/

            window.countAll = 0;

            __.initAnimals();
            __.initWeights();

            /*~~~~~~~~~~~~~~~~~~~~~~~*/

            setTimeout(function () {
                initButtons(__);
                initHelp(__);
            }, 200);

            if(window.enableInitSounds) {
                playInitAudio(__);
            }
        };

        this.initKids = function ()
        {
            var kid1Path = 'zosia.png';
            var kid2Path = 'stas.png';
            __.kid1 = initKid(__, 'kid1', kid1Path, 7, 486);
            __.kid2 = initKid(__, 'kid2', kid2Path, 828, 356);

            var Kids = new Object();
            Kids.kid2 = __.kid2;
            Kids.kid1 = __.kid1;
            window.kids = Kids;

        };
        /*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/

        this.initAnimals = function()
        {
            __.lines = [];
            __.aInfos = [];
            __.linesInfo = [];
            __.linesInfo.push({x: 100, y :56, zx:100, zy: 420});
            __.linesInfo.push({x: 280, y :52, zx:280, zy: 390});
            __.linesInfo.push({x: 500, y :56, zx:480, zy: 400});
            __.linesInfo.push({x: 700, y :72, zx:676, zy: 370});


            for (index in __.linesInfo) {
                var lineInfo = __.linesInfo[index];

                var id = 'l_'+index;
                __.lines[id] = new Item({
                    canvas: __.canvas,
                    id: id,
                    imgUrl: '../../img/' + __.gameId + '/' + __.gameNr + '/' + 'zwierzak'+ (parseInt(index)+1) + '-liana-A.png',
                    coordX: lineInfo.x,
                    coordY: lineInfo.y,
                    draggable: false,
                    visible: true,
                    bringToFront: true
                });
                __.lines[id].init();
                var id = 'lxx_'+index;
                __.lines[id] = new Item({
                    canvas: __.canvas,
                    id: id,
                    imgUrl: '../../img/' + __.gameId + '/' + __.gameNr + '/' + 'zwierzak'+ (parseInt(index)+1) + '-liana-B.png',
                    coordX: lineInfo.x,
                    coordY: lineInfo.y,
                    draggable: false,
                    visible: false,
                    bringToFront: true
                });

                __.lines[id].init();
                var id = 'z_'+index;
                __.lines[id] = new Item({
                    canvas: __.canvas,
                    id: id,
                    imgUrl: '../../img/' + __.gameId + '/' + __.gameNr + '/' + 'zwierzak'+ (parseInt(index)+1) + '.png',
                    coordX: lineInfo.zx,
                    coordY: lineInfo.zy,
                    draggable: false,
                    visible: true,
                    bringToFront: true
                });
                __.lines[id].init();

                var id = 'aInfo_'+index;
                __.aInfos[id] = new Item({
                    canvas: __.canvas,
                    id: id,
                    imgUrl: '../../img/' + __.gameId + '/' + __.gameNr + '/' + 'w'+ (parseInt(index)+1) + '.png',
                    coordX: lineInfo.zx+60,
                    coordY: lineInfo.zy+110,
                    draggable: false,
                    visible: true,
                    bringToFront: true
                });
                __.aInfos[id].init();
            }
        };

        this.initWeights = function()
        {
            __.weights = [];
            __.weightsInfo = [];
            __.weightsInfo.push({x: 100, y :560, target: 3});
            __.weightsInfo.push({x: 180, y :560, target: false});
            __.weightsInfo.push({x: 260, y :560, target: false});
            __.weightsInfo.push({x: 340, y :560, target: 2});
            __.weightsInfo.push({x: 420, y :560, target: 1});
            __.weightsInfo.push({x: 500, y :560, target: false});
            __.weightsInfo.push({x: 580, y :560, target: 4});

            __.targets = {
                1: {x:173, y:243},
                2: {x:336, y:155},
                3: {x:507, y:136 },
                4: {x:703, y:118},
            };

            for (index in __.weightsInfo) {
                var lineInfo = __.weightsInfo[index];

                var id = 'ww_'+index;
                __.weights[id] = new Material({
                    canvas: __.canvas,
                    id: id,
                    imgUrl: '../../img/' + __.gameId + '/' + __.gameNr + '/' + 'ww'+ (parseInt(index)+1) + '.png',
                    coordX: lineInfo.x+100,
                    coordY: lineInfo.y,
                    draggable: true,
                    visible: true,
                    bringToFront: true,
                    apro: 20,
                    target: lineInfo.target,
                    goodPosition: (__.targets[lineInfo.target])? {
                        x: __.targets[lineInfo.target]['x'], 
                        y: __.targets[lineInfo.target]['y']
                    } : false
                });
                __.weights[id].init();

                __.weights[id].dragstop = function(layer) {


                    if (this.isOnPosition(layer)) {
                        window.countAll++;
                        cl(this.target);

                        var nr = parseInt(this.target)-1;
                        cl(nr);

                        __.lines['l_' + nr ].hide(100);
                        __.aInfos['aInfo_' + nr].hide(100);
                        __.lines['lxx_' + nr].show(100);

                        

                        if (window.countAll >= 4) {
                            play('koniec-stas', __.kid1, 'game5.html');
                        } else {
                            play('poprawnie-zosia', __.kid1);
                        }

                        this.set('draggable', false);
                        // this.animateToPosition(layer, this.goodPosition['x'], this.goodPosition['y']);

                        if (this.target === 1) {
                            this.animateToPosition(layer, 174, 401, 10);
                            __.lines['z_0'].animateToPosition(0, 102, 138, 100);
                        } else if (this.target === 2) {
                            this.animateToPosition(layer, 330, 400, 10);
                            __.lines['z_1'].animateToPosition(0, 277, 110, 100);
                        } else if (this.target === 3) {
                            this.animateToPosition(layer, 511, 331, 10);
                            __.lines['z_2'].animateToPosition(0, 472, 120, 100);
                        } else if (this.target === 4) {
                            this.animateToPosition(layer, 702, 379, 10);
                            cl(__.lines);
                            __.lines['z_3'].animateToPosition(0, 674, 95, 100);
                        } 


                        // this.good(layer);
                        
                    } else {
                        play('blad-zosia', __.kid1);
                        // this.error(layer);
                        this.backToOryginalPosition(layer);
                    }

                };
            }
        }
    };

    $.fn.Game = function ()
    {
        var instance = (new Game).init();
        var len = this.length;
        return this.each(function (index) {
            var me = $(this);
            var instance = (new Game).init(me);
            me.data('Game' + (len > 1 ? '-' + (index + 1) : ''), instance);
        });

    };
})(window.jQuery, false);