$(document).ready(function () {
    $('#game').Game();
});

gameId = 'A';
gameNr = 5;

(function ($, f) {

    if (!$)
        return f;

    var Game = function ()
    {
        var __ = this;
        __.canvas = false;

        this.init = function (el)
        {
            window.bootstrap();

            if (typeof el === 'undefined')
                return f;

            __.canvas = el;
            __.cWidth = parseInt(__.canvas.css('width'));
            __.cHeight = parseInt(__.canvas.css('height'));

            __.gameId = window.gameId;
            __.gameNr = window.gameNr;

            initBackground(__);
            loadAudioForGame(__);
            loadBgAudio(__);
            __.initKids();

            /*~~~~~~~~~~~~~~~~~~~~~~~*/

            window.clickedItems = 0;
            window.amountLeft = 30;
            window.use = {
                'p': 0,
                'k': 0,
                'b': 0
            };
            __.initItems();
            // __.initBoy();

            /*~~~~~~~~~~~~~~~~~~~~~~~*/

            setTimeout(function () {
                initButtons(__);
                initHelp(__);
            }, 200);

            if(window.enableInitSounds) {
                playInitAudio(__);
            }
        };

        this.initKids = function ()
        {
            var kid1Path = 'zosia.png';
            var kid2Path = 'stas.png';
            __.kid1 = initKid(__, 'kid1', kid1Path, 1, 486);
            __.kid2 = initKid(__, 'kid2', kid2Path, 81, 476);

            var Kids = new Object();
            Kids.kid1 = __.kid1;
            Kids.kid2 = __.kid2;
            window.kids = Kids;
        };
        /*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/

        this.initItems = function ()
        {
            __.mon = new Txt({
                canvas: __.canvas,
                id: 'mon',
                fillStyle: '#316583',
                strokeStyle: '#2c5078',
                fontStyle: 'bold',
                fontSize: '26pt',
                fontFamily: 'Trebuchet MS, sans-serif',
                text: window.amountLeft,
                coordX: 30, coordY: 440,
                align: 'center',
                draggable: false,
                bringToFront: true,
                game: __
            });
            __.mon.init();

            __.mico = new Item({
                canvas: __.canvas,
                id: 'mico',
                imgUrl: getImgDir(__) + 'moneta.png',
                coordX: 77,
                coordY: 443,
                draggable: false,
                bringToFront: true
            });
            __.mico.init();

            __.items = {};
            __.prices = {};
            __.itemsData = {
                'p': [],
                'k': [],
                'b': []
            };
            __.itemsData['p'].push({x: 150, y :83, price: 5});
            __.itemsData['p'].push({x: 150, y :155, price: 5});
            __.itemsData['p'].push({x: 150, y :226, price: 3});
            __.itemsData['p'].push({x: 150, y :295, price: 3});
            __.itemsData['p'].push({x: 150, y :367, price: 10});
            __.itemsData['p'].push({x: 150, y :430, price: 10});


            __.itemsData['k'].push({x: 400, y :83, price: 1});
            __.itemsData['k'].push({x: 400, y :155, price: 3});
            __.itemsData['k'].push({x: 400, y :226, price: 5});
            __.itemsData['k'].push({x: 400, y :295, price: 7});
            __.itemsData['k'].push({x: 400, y :367, price: 9});
            __.itemsData['k'].push({x: 400, y :430, price: 11});

            __.itemsData['b'].push({x: 650, y :83, price: 2});
            __.itemsData['b'].push({x: 650, y :155, price: 4});
            __.itemsData['b'].push({x: 650, y :226, price: 6});
            __.itemsData['b'].push({x: 650, y :295, price: 8});
            __.itemsData['b'].push({x: 650, y :367, price: 10});
            __.itemsData['b'].push({x: 650, y :430, price: 12});


            for (letter in __.itemsData) {
                for(i=1; i <= __.itemsData[letter].length; i++) {
                    var id = letter + i;

                    __.items[id] = new Item({
                        canvas: __.canvas,
                        id: id,
                        imgUrl: getImgDir(__) + letter + i + '.png',
                        coordX: __.itemsData[letter][i-1].x,
                        coordY: __.itemsData[letter][i-1].y,
                        draggable: false,
                        bringToFront: true,
                        letter: letter,
                        price: __.itemsData[letter][i-1].price
                    });
                    __.items[id].init();

                    if (letter === 'p') {
                        __.itemsData[letter][i-1].x += 110;
                        __.itemsData[letter][i-1].y += 21;
                    } else if (letter === 'k') {
                        __.itemsData[letter][i-1].x += 70;
                        __.itemsData[letter][i-1].y += 11;
                    } else if (letter === 'b') {
                        __.itemsData[letter][i-1].x += 70;
                        __.itemsData[letter][i-1].y += 8;
                    }

                    __.drawPrice(id, __.itemsData[letter][i-1]);

                    __.items[id].click = function(layer)
                    {
                        var max = 4;

                        if (!this.isMark()) {

                            var canClickIt = true;
                            if (this.letter === 'p' && window.use[this.letter] === 2) {
                                canClickIt = false;
                            } else if (window.use[this.letter] === 1 && this.letter != 'p') {
                                canClickIt = false;
                            }

                            if (!canClickIt) {
                                return false;
                            }
                        }

                        if (this.isMark()) {
                            this.unMark();
                            window.amountLeft += this.price;
                            window.clickedItems--;
                            window.use[this.letter]--;
                        } else {
                            this.mark();
                            window.amountLeft -= this.price;
                            window.clickedItems++;
                            window.use[this.letter]++;
                        }

                        __.mon.set('text', parseInt(window.amountLeft));

                        if (window.clickedItems === max) {
                            if (window.amountLeft == 5) {
                                play('koniec-zosia', __.kid1, 'index.html');
                            } else if (window.amountLeft < 5) {
                                play('blad-bilet-zosia', __.kid1);
                            } else {
                                play('blad-monety-stas', __.kid2);
                            }
                        }
                        this.swing();
                    };
                }
            }
        };

        this.drawPrice = function(id, data)
        {
            var id = 'txt_' + id;
            __.prices[id] = new Txt({
                canvas: __.canvas,
                id: id,
                fillStyle: '#47629a',
                strokeStyle: '#000000',
                fontStyle: '',
                fontSize: '30pt',
                fontFamily: 'Trebuchet MS, sans-serif',
                text: data.price,
                coordX: data.x, coordY: data.y,
                align: 'center',
                draggable: false,
                bringToFront: true
            });
            __.prices[id].init();
            __.prices[id].click = function(layer) {
                
            }
        };
    }

    $.fn.Game = function ()
    {
        var instance = (new Game).init();
        var len = this.length;
        return this.each(function (index) {
            var me = $(this);
            var instance = (new Game).init(me);
            me.data('Game' + (len > 1 ? '-' + (index + 1) : ''), instance);
        });

    };
})(window.jQuery, false);