$(document).ready(function () {
    $('#game').Game();
});

gameId = 'B';
gameNr = 2;

(function ($, f) {

    if (!$)
        return f;

    var Game = function ()
    {
        var __ = this;
        __.canvas = false;

        this.init = function (el)
        {
            window.bootstrap();

            if (typeof el === 'undefined')
                return f;

            __.canvas = el;
            __.cWidth = parseInt(__.canvas.css('width'));
            __.cHeight = parseInt(__.canvas.css('height'));

            __.gameId = window.gameId;
            __.gameNr = window.gameNr;

            initBackground(__);
            loadAudioForGame(__);
            loadBgAudio(__);
            __.initKids();

            /*~~~~~~~~~~~~~~~~~~~~~~~*/

            window.countAll = 0;
            __.animals = [];
            __.initItems();

            /*~~~~~~~~~~~~~~~~~~~~~~~*/

            setTimeout(function () {
                initButtons(__);
                initHelp(__);
            }, 300);

            if(window.enableInitSounds) {
                playInitAudio(__);
            }
        };

        this.initKids = function ()
        {
            var kid1Path = '/zosia_nurek.png';
            var kid2Path = '/stas_nurek.png';
            __.kid1 = initKid(__, 'kid1', kid1Path, 12, 506);
            __.kid2 = initKid(__, 'kid2', kid2Path, 95, 495);

            var Kids = new Object();
            Kids.kid1 = __.kid1;
            Kids.kid2 = __.kid2;
            window.kids = Kids;
        };
        /*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/

        this.initItems = function ()
        {
            __.items = {};
            __.itemsData = [];
            __.itemsData.push({x: 166, y:63, g: 1, gx: 488, gy:194});
            __.itemsData.push({x: 713, y:6, g: 1, gx: 636, gy:115});
            __.itemsData.push({x: 13, y:103, g: 1, gx: 533, gy:124});
            __.itemsData.push({x: 834, y:91, g: 1,  gx: 338, gy:136 });

            __.itemsData.push({x: 863, y:189, g: 2, gx: 595, gy:277});
            __.itemsData.push({x: 119, y:294, g: 2, gx: 339, gy:241});
            __.itemsData.push({x: 9, y:176, g: 2, gx: 407, gy:357});
            __.itemsData.push({x: 927, y:196 , g: 2, gx: 261, gy:211 });

            __.itemsData.push({x: 7, y:384, g: 3, gx: 638, gy:381});
            __.itemsData.push({x: 11, y:221, g: 3, gx: 699, gy:312});
            __.itemsData.push({x: 167, y:570, g: 3, gx: 460, gy:435});
            __.itemsData.push({x: 279, y:9, g: 3, gx: 348, gy:402});



            for (index in __.itemsData) {
                var data = __.itemsData[index];
                var nr = parseInt(index) + 1;

                if (nr > 4) {
                    nr = ((data.g * 4) -4 - nr) * -1;
                }

                var id = 'item_' + data.g + '_' + nr;
                __.items[id] = new Material({
                    canvas: __.canvas,
                    id: id,
                    imgUrl: getImgDir(__) + 'item_' + data.g + '_' + nr + '.png',
                    coordX: data.x,
                    coordY: data.y,
                    draggable: true,
                    bringToFront: true,
                    goodPosition: {x: data.gx, y: data.gy},
                    g: data.g
                });
                __.items[id].init();

                __.items[id].isOnPosition = function(layer) {
                    return this.inOnGroup(layer);
                    return false;
                }

                __.items[id].dragstop = function(layer) {
                    cl(this.id +'    gx: ' + layer.x + ', gy:' + layer.y);

                    if (this.isOnPosition(layer)) {
                        window.countAll++;
                        this.set('draggable', false);
                        this.animateToPosition(layer, this.goodPosition['x'], this.goodPosition['y']);

                        cl(window.countAll);
                        if (window.countAll === 12) {
                            play('koniec-stas', __.kid2, 'game3.html');
                        } else {
                            play('poprawnie-zosia', __.kid1);
                        }


                    } else {
                        this.error(layer);
                        this.backToOryginalPosition(layer);
                        play('blad-zosia', __.kid1);
                    }
                }

                __.items[id].go = function()
                {
                    cl(this.id);
                    if (this.goodPosition.x > 1) {
                        
                         // __.canvas.animateLayer(this.id, {x: this.goodPosition.x, y: this.goodPosition.y}, 600, 'swing');
                    }
                }

                __.items[id].inOnGroup = function(layer)
                {
                    var apro = 8;
                    var X = layer.x;
                    var Y = layer.y;



                    var goodX = X >= 304 - apro && X <= 726 + apro;
                    var goodY = Y >= 94 - apro && Y <= 198 + apro;

                    if (goodX && goodY && this.g === 1)  {
                        return this.g;
                    }


                    var goodX = X >= 265 - apro && X <= 711 + apro;
                    var goodY = Y >= 211 - apro && Y <= 318 + apro;

                    if (goodX && goodY && this.g === 2)  {
                        return this.g;
                    }

                    var goodX = X >= 290 - apro && X <= 769 + apro;
                    var goodY = Y >= 371 - apro && Y <= 454 + apro;

                    if (goodX && goodY && this.g === 3)  {
                        return this.g;
                    }
                    return  false;
                }
            }

            setTimeout(function () {
                for (index in __.itemsData) {
                    var data = __.itemsData[index];
                    var nr = parseInt(index) + 1;

                if (nr > 4) {
                    nr = ((data.g * 4) -4 - nr) * -1;
                }
                var id = 'item_' + data.g + '_' + nr;

                    __.items[id].go();
                }
            }, 300);
        }
    };

    $.fn.Game = function ()
    {
        var instance = (new Game).init();
        var len = this.length;
        return this.each(function (index) {
            var me = $(this);
            var instance = (new Game).init(me);
            me.data('Game' + (len > 1 ? '-' + (index + 1) : ''), instance);
        });

    };
})(window.jQuery, false);