$(document).ready(function () {
    $('#game').Game();
});

gameId = 'B';
gameNr = 4;

(function ($, f) {

    if (!$)
        return f;

    var Game = function ()
    {
        var __ = this;
        __.canvas = false;

        this.init = function (el)
        {
            window.bootstrap();

            if (typeof el === 'undefined')
                return f;

            __.canvas = el;
            __.cWidth = parseInt(__.canvas.css('width'));
            __.cHeight = parseInt(__.canvas.css('height'));

            __.gameId = window.gameId;
            __.gameNr = window.gameNr;

            initBackground(__);
            loadAudioForGame(__);
            loadBgAudio(__);
            __.initKids();

            /*~~~~~~~~~~~~~~~~~~~~~~~*/

            // window.initBlock = false;

            window.goodCount = 0;

            window.taskNow = 0;

            __.initAnimals();

            __.goTask(1);
            

            /*~~~~~~~~~~~~~~~~~~~~~~~*/

            setTimeout(function () {
                initButtons(__);
                initHelp(__);
            }, 300);

            if(window.enableInitSounds) {
                playInitAudio(__);
            }
        };

        this.initKids = function ()
        {
            var kid1Path = '/zosia_nurek.png';
            var kid2Path = '/stas_nurek.png';
            __.kid1 = initKid(__, 'kid1', kid1Path, 312, 50);
            __.kid2 = initKid(__, 'kid2', kid2Path, 395, 50);

            var Kids = new Object();
            Kids.kid1 = __.kid1;
            Kids.kid2 = __.kid2;
            window.kids = Kids;
        };
        /*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/

        this.clickOnBg = function(layer) {
            // console.log('x:' + layer.eventX + ', y:' + layer.eventY);
        }

        __.initAnimals = function() {
            
            __.items = {};
            __.itemsData = [];
            __.itemsData.push({x: 59, y:261, g:4});
            __.itemsData.push({x: 455, y:255, g:4});
            __.itemsData.push({x: 128, y:571, g:1});
            __.itemsData.push({x: 714, y:417, g:1}); 
            __.itemsData.push({x: 324, y:510, g:1});// 5
            __.itemsData.push({x: 241, y:492, g:1});
            __.itemsData.push({x: 539, y:422, g:1});
            __.itemsData.push({x: 725, y:219, g:2});
            __.itemsData.push({x: 107, y:359, g:2});
            __.itemsData.push({x: 499, y:528, g:3});// 10
            __.itemsData.push({x: 258, y:422, g:3});
            __.itemsData.push({x: 41, y:512, g:3});
            __.itemsData.push({x: 737, y:62, g:5});
            __.itemsData.push({x: 411, y:411, g:5});
            __.itemsData.push({x: 159, y:269, g:5});

            __.counts = {
                1:0,
                2:0,
                3:0,
                4:0,
                5:0
            };
            for (index in __.itemsData) {
                var data = __.itemsData[index];
                var nr = parseInt(index) + 1;
                var id = 'item_' + '_' + nr;
                __.counts[data.g]++;
            }

            for (index in __.itemsData) {
                var data = __.itemsData[index];
                var nr = parseInt(index) + 1;
                var id = 'item_' + '_' + nr;
                __.items[id] = new Item({
                    canvas: __.canvas,
                    id: id,
                    imgUrl: getImgDir(__) + 'i_' + nr + '.png',
                    coordX: data.x,
                    coordY: data.y,
                    draggable: false,
                    bringToFront: true,
                    g: data.g,
                    nr: nr
                });
                __.items[id].init();

                __.items[id].click = function(layer) {
                    var taskNow = window.taskNow;
                    if (this.g === taskNow) {
                        window.goodCount++;
                        cl(__.counts[taskNow]);

                        if (this.g === 5 && __.counts[taskNow] === window.goodCount) {
                            play('koniec-zosia', __.kid1, 'game5.html');
                        } else if(__.counts[taskNow] === window.goodCount) {
                            var gnr = this.g+1;
                            __.goTask(gnr);
                        } else {
                            play('poprawnie-stas', __.kid2);
                        }
                        
                        this.hide(100);
                    } else {
                        play('blad-stas', __.kid2);
                    }
                }
            }
        }

        __.goTask = function(taskNr)
        {
            if (window.initBlock) {
                setTimeout(function () {
                    __.goTask(taskNr);
                }, 300);
                return;
            }

            cl('TASK');
            cl(taskNr);

            window.taskNow = taskNr;
            window.goodCount = 0;

            var taskAudioFile;
            var selectedKid;
            if (taskNr == 1) {
                taskAudioFile = 'zadanie1-zosia';
                selectedKid = __.kid1;
            } else if (taskNr == 2) {
                taskAudioFile = 'zadanie2-stas';
                selectedKid = __.kid2;
            } else if (taskNr == 3) {
                taskAudioFile = 'zadanie3-zosia';
                selectedKid = __.kid1;
            } else if (taskNr == 4) {
                taskAudioFile = 'zadanie4-stas';
                selectedKid = __.kid2;
            } else if (taskNr == 5) {
                taskAudioFile = 'zadanie5-zosia';
                selectedKid = __.kid1;
            } 

            play(taskAudioFile, selectedKid);
        }
    };

    $.fn.Game = function ()
    {
        var instance = (new Game).init();
        var len = this.length;
        return this.each(function (index) {
            var me = $(this);
            var instance = (new Game).init(me);
            me.data('Game' + (len > 1 ? '-' + (index + 1) : ''), instance);
        });

    };
})(window.jQuery, false);