var BaseEntity = function (settings)
{
    var __ = this;
    __.imgUrl = false;
    __.noLimit = false;
    __.text = false;
    __.sides = false;
    __.canvas = false;
    __.id = false;

    __.coordX = 1;
    __.coordY = 1;

    __.width = 0;
    __.height = 0;

    __.margX = 10;
    __.margY = 10;

    __.sx = 10;
    __.sy = 10;

    __.fill = function (settings)
    {
        __.visible = true;
        __.opacity = 1;

        for (var key in settings)
            __[key] = settings[key];

        __.isImage = __.imgUrl !== false;
        __.isText = __.text !== false;
        __.isRect = __.classType == 'Rectangle';

        if (!__.isImage && !__.isText && !__.isRect) {
            __.isPoly = __.sides !== false;
        }

        if (__.isImage) {
            __.loadImageAndDraw();
        } else {
            __.draw();            
        }
    };

    __.loadImageAndDraw = function()
    {
        var imgLoader = new Image();
        imgLoader.src = __.imgUrl;
        imgLoader.onload = function () {
            __.height = imgLoader.height;
            __.width = imgLoader.width;

            __.minX = __.coordX - (__.width / 2);
            __.maxX = __.coordX + (__.width / 2);
            __.minY = __.coordY - (__.height / 2);
            __.maxY = __.coordY + (__.height / 2);

            __.draw();
        };
    };

    __.draw = function ()
    {
        if (__.isImage) {
            // cl('Init IMG:' + __.id);
            __.drawImage();
        } else if (__.isText) {
            // cl('Init TXT:' + __.id);
            __.drawTxt();
        } else if(__.isPoly) {
            // console.log('Init Poly:' + __.id);
            __.drawPolygon();
        } else if(__.isRect) {
            // console.log('Init Rect:' + __.id);
            __.drawRectangle();
        } else {
            // cl('Init SPACE:' + __.id);
            __.drawTxt();
        }
    };

    __.drawPolygon = function()
    {
        __.canvas.drawPolygon({
            layer: true,
            name: __.id,
            fillStyle: __.fillStyle,
            strokeStyle: __.strokeStyle,
            x: __.coordX, y: __.coordY,
            radius: __.radius,
            sides: __.sides,
            fromCenter: false,
            opacity: __.opacity,
            rotate: __.rotate
        });
    }

    __.drawRectangle = function()
    {
        __.canvas.drawRect({
            layer: true,
            name: __.id,
            fillStyle: __.fillStyle,
            strokeStyle: __.strokeStyle,
            x: __.coordX, y: __.coordY,
            width: __.width,
            height: __.height,
            fromCenter: false,
            opacity: __.opacity,
            rotate: __.rotate,
            click: function (layer) {
                if (!window.initBlock) 
                __.click(layer);
            },
            dragstop: function (layer) {
                if (!window.initBlock) {
                    __.dragstop(layer);
                } else {
                    __.backToOryginalPosition(layer);
                }
            },
            mouseover: function (layer) {
                __.mouseover(layer);
            },
            mouseout: function (layer) {
                __.mouseout(layer);
            },
        });
    }

    __.drawImage = function()
    {
        __.canvas.drawImage({
            layer: true,
            name: __.id,
            source: __.imgUrl,
            x: __.coordX, y: __.coordY,
            sWidth: __.width,
            sHeight: __.height,
            sx: __.sx, sy: __.sy,
            draggable: __.draggable,
            bringToFront: __.bringToFront,
            fromCenter: false,
            opacity: __.opacity,
            visible: __.visible,
            click: function (layer) {
                if (!window.initBlock || __.noLimit) {
                    __.click(layer);
                }
            },
            dragstop: function (layer) {
                if (!window.initBlock) {
                    __.dragstop(layer);
                } else {
                    __.backToOryginalPosition(layer);
                }
            },
            mouseover: function (layer) {
                __.mouseover(layer);
            },
            mouseout: function (layer) {
                __.mouseout(layer);
            }
        });
    };

    __.drawTxt = function()
    {
        __.canvas.drawText({
            layer: true,
            name: __.id,

            fillStyle: __.fillStyle,
            strokeStyle: __.strokeStyle,
            fontStyle: __.fontStyle,
            fontSize: __.fontSize,
            fontFamily: __.fontFamily,
            text: __.text,
            align: __.align,
            fromCenter: false,
            draggable: __.draggable,
            bringToFront: __.bringToFront,
            x: __.coordX, 
            y: __.coordY,
            sx: __.sx, 
            sy: __.sy,
            opacity: __.opacity,
            visible: __.visible,
            click: function (layer) {
                if (!window.initBlock) 
                    __.click(layer);
            },
            dragstop: function (layer) {
                if (!window.initBlock) {
                    __.dragstop(layer);
                } else {
                    __.backToOryginalPosition(layer);
                }
            },
            mouseover: function (layer) {
                __.mouseover(layer);
            },
            mouseout: function (layer) {
                __.mouseout(layer);
            }
        });
    };

    __.getType = function (elemenet)
    {
        if (elemenet.get(0))
            return elemenet.get(0).tagName.toLowerCase();
    };


    __.backToOryginalPosition = function (layer)
    {
        var xVar = __.coordX - layer.x;
        var xStr = (xVar < 0) ? '-=' + (xVar * -1) : '+=' + xVar;

        var yVar = __.coordY - layer.y;
        var yStr = (yVar < 0) ? '-=' + (yVar * -1) : '+=' + yVar;

        __.animateToPosition(layer, xStr, yStr);
    };
    
    __.animateToPosition = function(layer, x, y, speed) {
        var speed = typeof speed !== 'undefined' ? speed : 1000;
        __.canvas.animateLayer(__.id, {
            x: x,
            y: y
        }, speed, function (layer) {
            if(typeof __.animateToPositionCallback === 'function') {
                __.animateToPositionCallback(layer);
            }    
        });
    };

    __.isOn = function(layer, apro)
    {
        var apro = typeof apro !== 'undefined' ? apro : 0;
        var X = layer.x;
        var Y = layer.y;

        var goodX = X >= __.minX - apro && X <= __.maxX + apro;
        var goodY = Y >= __.minY - apro && Y <= __.maxY + apro;

        return goodX && goodY;
    };

    __.hide = function(hideSpeed)
    {
        __.hideSpeed = typeof hideSpeed !== 'undefined' ? hideSpeed : 100;
        __.canvas.animateLayer(__.id, {
            opacity: 0,
            visible: false
        }, __.hideSpeed, function (layer) {
            __.visible = false;
            __.opacity = 0;
        });
    };
    __.show = function(showSpeed, opacity)
    {
        __.showSpeed = typeof showSpeed !== 'undefined' ? showSpeed : 100;
        opacity = typeof opacity !== 'undefined' ? opacity : 1;
        __.canvas.animateLayer(__.id, {
            opacity: opacity,
            visible: true
        }, __.showSpeed, function (layer) {
            __.visible = true;
            __.opacity = 1;
        });
    };

    __.swing = function(degree)
    {
        __.degree = typeof degree !== 'undefined' ? degree : 50;
        __.canvas.animateLayer(__.id, {
            rotate: __.degree
        }, 'slow', function (layer) {
            __.canvas.animateLayer(__.id, {
                rotate: -1 * __.degree
            }, 'slow', function (layer) {
                __.canvas.animateLayer(__.id, {
                    rotate: 0
                }, 'slow', 'swing');
            });
        });
    };

    __.set = function(name, value)
    {
        prop = {};
        prop[name] = value;
        __.canvas.animateLayer(__.id, prop, 10, 'swing');
    }

};