var Item = function (settings)
{
    var __ = this;
    
    __.stepLengthX = 65;
    __.stepLengthY = __.stepLengthX;
    __.moveSpeed = 400;
    __.marked = false;

    __.init = function ()
    {
        BaseEntity.call(this);
        Item.prototype = new BaseEntity();
        Item.prototype.constructor = Item;

        __.fill(settings);
    };
    __.click = function () {};

    __.mouseover = function () {
        __.canvas.css('cursor', 'pointer');
    };

    __.mouseout = function () {};
    __.dragstop = function (layer) {};
    __.good = function (layer) {};
    __.error = function (layer) {};

    __.move = function(directory, stepLength)
    {
        stepLength = typeof stepLength !== 'undefined' ? stepLength : 1;
        directory = typeof directory !== 'undefined' ? directory : 'up';

        var change = {x: false, y: false};

        var diff = {
            x: __.stepLengthX * stepLength,
            y: __.stepLengthY * stepLength
        };

        switch(directory) {
            case 'up':
                change.y = '-=' + diff.y;
                break;
            case 'down':
                change.y = '+=' + diff.y;
                break;
            case 'left':
                change.x = '-=' + diff.x;
                break;
            case 'right':
                change.x = '+=' + diff.x;
                break;
        }

        var animationConfigObject = {};
        for(var coord in diff) {
            if (change[coord]) {
                animationConfigObject[coord] = change[coord];
            }
        }

        __.canvas.animateLayer(__.id, animationConfigObject, __.moveSpeed, 'swing');
    };

    __.mark = function()
    {
        __.marked = true;
        __.canvas.animateLayer(__.id, {
            opacity: 0.5
        }, 'slow', 'swing');
    };
    __.unMark = function()
    {
        __.marked = false;
        __.canvas.animateLayer(__.id, {
            opacity: 1
        }, 'slow', 'swing');
    };
    __.isMark = function()
    {
        return __.marked;
    };
};
