
var Kid = function (settings)
{
    var __ = this;

    __.talking = false;
    __.positionExtra = false;
    __.talkingSpeed = 500;
    __.isLoaded = false;

    __.init = function ()
    {
        BaseEntity.call(this);
        Kid.prototype = new BaseEntity();
        Kid.prototype.constructor = Kid;

        __.fill(settings);

        setTimeout(function () {
            __.loadEyes();
            __.blink();
            __.loadMouth();
        }, 200);
    };

    __.click = function () {
    };
    __.dragstop = function () {
    };

    __.mouseover = function () {
    };
    __.mouseout = function () {
    };
//#######################################################################################


    __.loadEyes = function ()
    {
        var imgLoader = new Image();
        imgLoader.src = '../../img/kids/' + __.id + 'Eyes.png';
        imgLoader.onload = function () {

            var x = __.coordX + imgLoader.width / 3;
            var y = __.coordY + 3 * imgLoader.height;

            if (gameId === 'A') {
                if (__.id === 'kid1') {
                    x += 14;
                    y += 6;
                }
                if (__.id === 'kid2') {
                    x += 14;
                    y += 14;
                }
            } else {
                if (__.id === 'kid1') {
                    y -= 12;
                }
                if (__.id === 'kid2') {
                    x -= 4;
                    y -= 4;
                }
            }
            

            __.canvas.drawImage({
                layer: true,
                name: 'eyes_' + __.id,
                source: imgLoader.src,
                x: x, y: y,
                sWidth: imgLoader.width / 2,
                sHeight: imgLoader.height,
                sx: 0, sy: 0,
                fromCenter: false,
                bringToFront: true
            });
        };
    };

    __.loadMouth = function ()
    {
        var imgLoader = new Image();
        imgLoader.src = '../../img/kids/' + __.id + 'Usta.png';

        imgLoader.onload = function () {
            if (gameId === 'A') {
                if (__.id === 'kid1') {
                    var width = 21;
                    var x = __.coordX + width + 25;
                    var y = __.coordY + 63;
                }
                
                if (__.id === 'kid2') {
                    var width = 21;
                    var x = __.coordX + width + 20;
                    var y = __.coordY + 68;
                }
            } else {
                if (__.id === 'kid1') {
                    var width = 21;
                    var x = __.coordX + width + 9;
                    var y = __.coordY + 42;
                }
                
                if (__.id === 'kid2') {
                    var width = 21;
                    var x = __.coordX + width + 3;
                    var y = __.coordY + 51;
                }
            }

            __.mouthHeight = imgLoader.height;
            __.mouthWight = imgLoader.width / 6;

            __.mouthX = x;
            __.mouthY = y;

            __.canvas.drawImage({
                layer: true,
                name: 'usta_' + __.id,
                source: imgLoader.src,
                x: x, y: y,
                sWidth: width,
                sHeight: imgLoader.height,
                sx: 0, sy: 0,
                fromCenter: false,
                bringToFront: true
            });

            __.isLoaded = 1;
        };
    };

    __.blink = function () {
        __.closeEyes();

    };

    __.closeEyes = function () {
        __.canvas.animateLayer('eyes_' + __.id, {
            sx: 70, sy: 0
        }, 20);
        setTimeout(function () {
            __.openEyes();
        }, 100);
    };
    __.openEyes = function () {
        __.canvas.animateLayer('eyes_' + __.id, {
            sx: 0, sy: 0
        }, 20);
        setTimeout(function () {
            __.closeEyes();
        }, rand(4) * 700);
    };


    __.talk = function ()
    {
        if (!__.isLoaded) {
            setTimeout(function () {
                __.talk();
            }, 200);
            return;
        }

        __.openMouth();
        __.talking = setTimeout(function () {
            __.talk();
        }, __.talkingSpeed);
    };

    __.openMouth = function ()
    {
        __.canvas.animateLayer('usta_' + __.id, {
            sx: __.mouthWight, sy: 0
        }, 15);
        __.canvas.animateLayer('usta_' + __.id, {
            sx: __.mouthWight*2, sy: 0
        }, 15);
        __.canvas.animateLayer('usta_' + __.id, {
            sx: __.mouthWight*3, sy: 0
        }, 15);


        setTimeout(function () {
            __.closeMouth();
        }, __.talkingSpeed);
    };

    __.closeMouth = function ()
    {
        __.canvas.animateLayer('usta_' + __.id, {
            sx: __.mouthWight*2, sy: 0
        }, 15);
        __.canvas.animateLayer('usta_' + __.id, {
            sx: __.mouthWight*1, sy: 0
        }, 15);
    };

    /**
     * Stopping talking
     */
    __.stopTalk = function ()
    {
        clearTimeout(__.talking);
    };


    __.talkFor = function (s)
    {
        __.talk();
        setTimeout(function () {
            __.stopTalk();
        }, s * 1000);
    };




};