$(document).ready(function () {
    $('#game').Game();
});

gameId = 'A';
gameNr = 1;

(function ($, f) {

    if (!$)
        return f;

    var Game = function ()
    {
        var __ = this;
        __.canvas = false;

        this.init = function (el)
        {
            window.bootstrap();

            if (typeof el === 'undefined')
                return f;

            __.canvas = el;
            __.cWidth = parseInt(__.canvas.css('width'));
            __.cHeight = parseInt(__.canvas.css('height'));

            __.gameId = window.gameId;
            __.gameNr = window.gameNr;

            initBackground(__);
            loadAudioForGame(__);
            loadBgAudio(__);
            __.initKids();

            /*~~~~~~~~~~~~~~~~~~~~~~~*/

            window.aCount = 0;

            __.initElements();

            /*~~~~~~~~~~~~~~~~~~~~~~~*/

            setTimeout(function () {
                initButtons(__);
                initHelp(__);
            }, 300);

            if(window.enableInitSounds) {
                playInitAudio(__);
            }
        };

        this.initKids = function ()
        {
            var kid1Path = 'zosia.png';
            var kid2Path = 'stas.png';
            __.kid1 = initKid(__, 'kid1', kid1Path, 7, 426);
            __.kid2 = initKid(__, 'kid2', kid2Path, 85, 416);

            var Kids = new Object();
            Kids.kid1 = __.kid1;
            Kids.kid2 = __.kid2;
            window.kids = Kids;
        };
        /*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/

        this.initElements = function()
        {
            __.shadows = {};   
            __.animals = {};   

            var shadowsData = new Array();
            shadowsData.push({x: 10, y: 160, img: 's1', draggable: false}); 
            shadowsData.push({x: 310, y: 70, img: 's2', draggable: false}); 
            shadowsData.push({x: 210, y: 10, img: 's3', draggable: false}); 
            shadowsData.push({x: 150, y: 350, img: 's4', draggable: false}); 
            shadowsData.push({x: 590, y: 10, img: 's5', draggable: false}); 
            shadowsData.push({x: 390, y: 510, img: 's6', draggable: false}); 

            var animData = new Array();
            animData.push({x: 563, y: 163, img: 'i1', draggable: true}); 
            animData.push({x: 755, y: 78, img: 'i2', draggable: true}); 
            animData.push({x: 590, y: 294, img: 'i3', draggable: true}); 
            animData.push({x: 477, y: 359, img: 'i4', draggable: true}); 
            animData.push({x: 482, y: 257, img: 'i5', draggable: true}); 
            animData.push({x: 38, y: 227, img: 'i6', draggable: true}); 

            for (index in shadowsData) {
                var shadowData = shadowsData[index];
                var aData = animData[index];

                aData.goodX = shadowData.x;
                aData.goodY = shadowData.y;

                if (index == 3){
                    aData.goodY -= 3;
                    aData.goodX += 2;
                }

                if (index == 1){
                    aData.goodY -= 3;
                    aData.goodX += 0;
                }

                __.createItem(shadowData.img, shadowData, 'shadows');
                __.createAnimal('a' + aData.img, aData, 'animals');
            }
        }

        __.createItem = function(id, data, collection)
        {   
            cl(data);
             __[collection][id] = new Item({
                canvas: __.canvas,
                id: id,
                imgUrl: '../../img/' + __.gameId + '/' + __.gameNr + '/' + data.img + '.png',
                coordX: data.x,
                coordY: data.y,
                draggable: data.draggable,
                bringToFront: true
            });
            __[collection][id].init();

            __[collection][id].dragstop = function(layer) {};
        }

        __.createAnimal = function(id, data, collection)
        {   
            cl(data);
             __[collection][id] = new Material({
                canvas: __.canvas,
                id: id,
                imgUrl: '../../img/' + __.gameId + '/' + __.gameNr + '/' + data.img + '.png',
                coordX: data.x,
                coordY: data.y,
                draggable: data.draggable,
                bringToFront: true,
                goodPosition: {x: data.goodX, y: data.goodY}
            });
            __[collection][id].init();

            __[collection][id].dragstop = function(layer) {

                if (this.isOnPosition(layer)) {
                    this.good(layer);
                    this.set('draggable', false);
                    this.animateToPosition(layer, this.goodPosition['x'], this.goodPosition['y']);
                } else {
                    this.error(layer);
                }
            };

            __[collection][id].good = function(layer) {
                window.aCount++;
                if (window.aCount >= 6) {
                    cl('end');
                    play('koniec-stas', __.kid2, 'game2.html');
                } else {
                    play('poprawnie-zosia', __.kid1);
                }
            };
            __[collection][id].error = function(layer) {
                this.backToOryginalPosition(layer);
                play('blad-zosia', __.kid1);
            };
        }
    };

    $.fn.Game = function ()
    {
        var instance = (new Game).init();
        var len = this.length;
        return this.each(function (index) {
            var me = $(this);
            var instance = (new Game).init(me);
            me.data('Game' + (len > 1 ? '-' + (index + 1) : ''), instance);
        });

    };
})(window.jQuery, false);