$(document).ready(function () {
    $('#game').Game();
});

gameId = 'A';
gameNr = 2;

(function ($, f) {

    if (!$)
        return f;

    var Game = function ()
    {
        var __ = this;
        __.canvas = false;

        this.init = function (el)
        {
            window.bootstrap();

            if (typeof el === 'undefined')
                return f;

            __.canvas = el;
            __.cWidth = parseInt(__.canvas.css('width'));
            __.cHeight = parseInt(__.canvas.css('height'));

            __.gameId = window.gameId;
            __.gameNr = window.gameNr;

            initBackground(__);
            loadAudioForGame(__);
            loadBgAudio(__);
            __.initKids();

            /*~~~~~~~~~~~~~~~~~~~~~~~*/


            window.aCount = 0;
            __.initBgs();
            __.initItems();

            /*~~~~~~~~~~~~~~~~~~~~~~~*/

            setTimeout(function () {
                initButtons(__);
                initHelp(__);
            }, 200);

            if(window.enableInitSounds) {
                playInitAudio(__);
            }
        };

        this.initKids = function ()
        {
            var kid1Path = 'zosia.png';
            var kid2Path = 'stas.png';
            __.kid1 = initKid(__, 'kid1', kid1Path, 7, 426);
            __.kid2 = initKid(__, 'kid2', kid2Path, 85, 416);

            var Kids = new Object();
            Kids.kid1 = __.kid1;
            Kids.kid2 = __.kid2;
            window.kids = Kids;
        };
        /*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/

        this.initBgs = function ()
        {
            __.bags = {};
            __.birds = {};
            __.bagsCount = 5;

            __.startPositions = new Object();
            for (nr = 1; nr <= __.bagsCount; nr++) {
                __.startPositions[nr] = new Array();
            }
            __.startPositions[1]['x'] = 200;
            __.startPositions[1]['y'] = 170;
            __.startPositions[2]['x'] = 420;
            __.startPositions[2]['y'] = 173;

            __.startPositions[3]['x'] = 60;
            __.startPositions[3]['y'] = 360;
            __.startPositions[4]['x'] = 300;
            __.startPositions[4]['y'] = 360;
            __.startPositions[5]['x'] = 550;
            __.startPositions[5]['y'] = 360;

            for (nr = 1; nr <= __.bagsCount; nr++) {
                var id = 'bag_' + nr;
                __.bags[id] = new Bag({
                    canvas: __.canvas,
                    id: id,
                    opacity: 1,
                    imgUrl: '../../img/' + __.gameId + '/' + __.gameNr + '/row/r' + nr + '.png',
                    coordX: __.startPositions[nr]['x'],
                    coordY: __.startPositions[nr]['y'],
                    draggable: false,
                    bringToFront: true
                });
                __.bags[id].init();

                __.canvas.animateLayer('bag_' + nr, {
                    opacity: 0.3
                }, 100, 'swing');

                __.bags[id].error = function (layer) {
                };
                __.bags[id].good = function (layer) {
                };


                __.birds[id] = new Item({
                    canvas: __.canvas,
                    id: 'bird_' + id,
                    imgUrl: '../../img/' + __.gameId + '/' + __.gameNr + '/closed.png',
                    coordX: __.startPositions[nr]['x'],
                    coordY: __.startPositions[nr]['y']-178,
                    draggable: false,
                    bringToFront: true
                });
                __.birds[id].init();

                __.birds['p'+id] = new Item({
                    canvas: __.canvas,
                    id: 'birdp_' + id,
                    imgUrl: '../../img/' + __.gameId + '/' + __.gameNr + '/open.png',
                    coordX: __.startPositions[nr]['x']+1,
                    coordY: __.startPositions[nr]['y']-180,
                    draggable: false,
                    bringToFront: true,
                    visible: false
                });
                __.birds['p'+id].init();
            }
        };

        this.initItems = function ()
        {
            __.items = {};
            var itemsData = new Array();
            itemsData.push({x: 702, y:87 , img: '2', draggable: true, goodX: 186, goodY:170}); 
            itemsData.push({x: 683, y:169, img: '5', draggable: true, goodX: 467, goodY:170 }); 
            itemsData.push({x: 765, y:182, img: '12', draggable: true, goodX: 48, goodY:358}); 
            itemsData.push({x: 721, y:143 , img: '8', draggable: true, goodX: 348, goodY:360 }); 
            itemsData.push({x: 826, y:119, img: '17', draggable: true, goodX: 538, goodY:359 }); 

            for (index in itemsData) {
                var itemData = itemsData[index];

                var id = 'item_' + index;

                __.items[id] = new Material({
                    canvas: __.canvas,
                    id: id,
                    imgUrl: '../../img/' + __.gameId + '/' + __.gameNr + '/counts/' + itemData.img + '.png',
                    coordX: itemData.x,
                    coordY: itemData.y,
                    draggable: itemData.draggable,
                    bringToFront: true,
                    goodPosition: {x: itemData.goodX, y: itemData.goodY}
                });
                __.items[id].init();

                __.items[id].dragstop = function(layer) {

                    cl(', goodX: ' + layer.x + ', goodY:' + layer.y);

                    if (this.isOnPosition(layer)) {
                        this.good(layer);
                        this.set('draggable', false);
                        this.animateToPosition(layer, this.goodPosition['x'], this.goodPosition['y']);
                    } else {
                        this.error(layer);
                    }
                };

                __.items[id].good = function(layer) {
                    window.aCount++;

                    var xid = parseInt(this.id.replace('item_', '')) + 1;
                    __.birds['bag_' + xid].hide(100);
                    __.birds['pbag_' + xid].show(100);

                    if (window.aCount >= 5) {
                        cl('end');
                        play('koniec-zosia', __.kid1, 'game3.html');
                    } else {
                        play('poprawnie-zosia', __.kid1);
                    }
                };
                __.items[id].error = function(layer) {
                    this.backToOryginalPosition(layer);
                    play('blad-stas', __.kid2);
                };
            }
        };
    };

    $.fn.Game = function ()
    {
        var instance = (new Game).init();
        var len = this.length;
        return this.each(function (index) {
            var me = $(this);
            var instance = (new Game).init(me);
            me.data('Game' + (len > 1 ? '-' + (index + 1) : ''), instance);
        });

    };
})(window.jQuery, false);