$(document).ready(function () {
    $('#game').Game();
});

gameId = 'A';
gameNr = 3;

(function ($, f) {

    if (!$)
        return f;

    var Game = function ()
    {
        var __ = this;
        __.canvas = false;

        this.init = function (el)
        {
            window.bootstrap();

            if (typeof el === 'undefined')
                return f;

            __.canvas = el;
            __.cWidth = parseInt(__.canvas.css('width'));
            __.cHeight = parseInt(__.canvas.css('height'));

            __.gameId = window.gameId;
            __.gameNr = window.gameNr;

            initBackground(__);
            loadAudioForGame(__);
            loadBgAudio(__);
            __.initKids();

            /*~~~~~~~~~~~~~~~~~~~~~~~*/


            window.goodCount = 0;

            window.clicked = {
                    w: false,
                    crd: false,
                    aid: false
            };

            __.initBoard();
            __.initAnimals();

            /*~~~~~~~~~~~~~~~~~~~~~~~*/

            setTimeout(function () {
                initButtons(__);
                initHelp(__);
            }, 200);

            if(window.enableInitSounds) {
                playInitAudio(__);
            }
        };

        this.initKids = function ()
        {
            var kid1Path = 'zosia.png';
            var kid2Path = 'stas.png';
            __.kid1 = initKid(__, 'kid1', kid1Path, 7, 426);
            __.kid2 = initKid(__, 'kid2', kid2Path, 85, 416);

            var Kids = new Object();
            Kids.kid1 = __.kid1;
            Kids.kid2 = __.kid2;
            window.kids = Kids;
        };
        /*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/

        this.initBoard = function ()
        {
            var id = 'boy';
            __.board = new Item({
                canvas: __.canvas,
                id: id,
                imgUrl: '../../img/' + __.gameId + '/' + __.gameNr + '/board.png',
                coordX: 230,
                coordY: 90,
                draggable: false,
                bringToFront: true,
                step : 1
            });
            __.board.init();
        };

        this.initAnimals = function ()
        {
            __.pool = new Array();

            for(p=1; p<=15; p++) {
                __.pool[p] = 0;
            }

            __.buttons = [];
            for(w=1; w<=5; w++) {
                for(c=1; c<=6; c++) {


                    var aniamID = __.getAnimalId();


                    // return false;

                    var x = 156 + (c * 83);
                    var y = 14 + (w * 83);


                    var id = 'pc_' + w + '_' + c;
                    __.buttons[id] = new Item({
                        canvas: __.canvas,
                        id: id,
                        imgUrl: '../../img/' + __.gameId + '/' + __.gameNr + '/' + 'pyt.png',
                        coordX: x,
                        coordY: y,
                        draggable: false,
                        bringToFront: true,
                        aniamID: aniamID
                    });
                    __.buttons[id].init();

                    var id = 'p_' + w + '_' + c;
                    __.buttons[id] = new Item({
                        canvas: __.canvas,
                        id: id,
                        imgUrl: '../../img/' + __.gameId + '/' + __.gameNr + '/' + 'i'+ aniamID + '.png',
                        coordX: x,
                        coordY: y,
                        draggable: false,
                        visible: false,
                        bringToFront: true,
                        aniamID: aniamID
                    });
                    __.buttons[id].init();

                    __.buttons[id].click = function(layer) {

                    };


                    var id = 'pc_' + w + '_' + c;
                    __.buttons[id].click = function(layer) {

                        var aid = this.id.replace('pc_', 'p_');

                        this.hide(100);
                        __.buttons[aid].show(100);

                        if (window.clicked.aid === false) {
                            window.clicked.aid = this.aniamID;
                            window.clicked.crd = this.id.replace('pc_', '');

                            cl('SETS');
                            cl(window.clicked);
                        } else {

                            cl(this.aniamID +'==='+ window.clicked.aid)

                            if (this.aniamID === window.clicked.aid) {
                                window.goodCount++;

                                if (window.goodCount == 15) {
                                    play('koniec-stas', __.kid1, 'game4.html');
                                    // END
                                } else {
                                    // GOOD
                                    play('poprawnie-stas', __.kid2);
                                }

                            } else {
                                play('blad-stas', __.kid2);
                                // ERROR
                                cl('pc_' + window.clicked.crd);
                                __.buttons['pc_' + window.clicked.crd].show(100);
                                __.buttons['p_' + window.clicked.crd].hide(100);

                                this.show(100);
                                __.buttons[aid].hide(100);
                            }
                            window.clicked.aid = false;
                            window.clicked.crd = false;
                        }
                    };
                }
            }
        };

        this.getAnimalId = function()
        {
            var find = false;
            var ret;
            var i = 0;


            while(!find) {
                var r = rand(15);
                if (__.pool[r] < 2) {
                    __.pool[r]++;
                    find = r;
                    break;
                } 

                i++;
                if (i >= 1000){
                    cl('ERROROOOR! 551');
                    find = 999;
                }
            }
            return find;
        }


    };

    $.fn.Game = function ()
    {
        var instance = (new Game).init();
        var len = this.length;
        return this.each(function (index) {
            var me = $(this);
            var instance = (new Game).init(me);
            me.data('Game' + (len > 1 ? '-' + (index + 1) : ''), instance);
        });

    };
})(window.jQuery, false);