$(document).ready(function () {
    $('#game').Game();
});

gameId = 'B';
gameNr = 1;

(function ($, f) {

    if (!$)
        return f;

    var Game = function ()
    {
        var __ = this;
        __.canvas = false;

        this.init = function (el)
        {
            window.bootstrap();

            if (typeof el === 'undefined')
                return f;

            __.canvas = el;
            __.cWidth = parseInt(__.canvas.css('width'));
            __.cHeight = parseInt(__.canvas.css('height'));

            __.gameId = window.gameId;
            __.gameNr = window.gameNr;

            initBackground(__);
            loadAudioForGame(__);
            loadBgAudio(__);
            __.initKids();

            /*~~~~~~~~~~~~~~~~~~~~~~~*/

            window.countAll = 0;
            __.initItems();

            /*~~~~~~~~~~~~~~~~~~~~~~~*/

            setTimeout(function () {
                initButtons(__);
                initHelp(__);
            }, 300);

            if(window.enableInitSounds) {
                playInitAudio(__);
            }
        };

        this.initKids = function ()
        {
            var kid1Path = '/zosia_nurek.png';
            var kid2Path = '/stas_nurek.png';
            __.kid1 = initKid(__, 'kid1', kid1Path, 12, 406);
            __.kid2 = initKid(__, 'kid2', kid2Path, 7, 136);

            var Kids = new Object();
            Kids.kid1 = __.kid1;
            Kids.kid2 = __.kid2;
            window.kids = Kids;
        };
        /*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/

        this.initItems = function ()
        {
            __.badItems = {};
            __.badItemsData = [];
            __.badItemsData.push({x: 79, y:142});
            __.badItemsData.push({x: 11, y:323});
            __.badItemsData.push({x: 125, y:330});
            __.badItemsData.push({x: 950, y:87});
            __.badItemsData.push({x: 36, y:553 });

            for (index in __.badItemsData) {
                var data = __.badItemsData[index];
                var nr = parseInt(index) + 1;
                var id = 'bad_' + nr;
                __.badItems[id] = new Material({
                    canvas: __.canvas,
                    id: id,
                    imgUrl: getImgDir(__) + 'bitem_' + nr + '.png',
                    coordX: data.x,
                    coordY: data.y,
                    draggable: true,
                    bringToFront: true,
                    goodPosition: {x: -10000, y: -1000}
                });
                __.badItems[id].init();
                __.badItems[id].dragstop = function(l) {
                    cl(this.id +'    x: ' + l.x + ', y:' + l.y);
                    this.backToOryginalPosition(l);
                }
            }

            __.items = {};
            __.itemsData = [];
            __.itemsData.push({x: 166, y:63, gx: 371, gy:322});
            __.itemsData.push({x: 131, y:183, gx: 667, gy:69});
            __.itemsData.push({x: 41, y:362, gx: 636, gy:168});
            __.itemsData.push({x: 4, y:344, gx: 628, gy:190});
            __.itemsData.push({x: 128, y:401, gx: 786, gy:215}); // 5
            __.itemsData.push({x: 76, y:256, gx: 774, gy:220});
            __.itemsData.push({x: 104, y:409, gx: 903, gy:271});
            __.itemsData.push({x: 165, y:43 , gx: 417, gy:313});
            __.itemsData.push({x: 844, y:58, gx: 438, gy:334}); 
            __.itemsData.push({x: 140, y:463, gx: 347, gy:316}); // 10
            __.itemsData.push({x: 102, y:494, gx: 350, gy:239});
            __.itemsData.push({x: 15, y:92, gx: 436, gy:238});
            __.itemsData.push({x: 168, y:499, gx: 528, gy:244});
            __.itemsData.push({x: 235, y:427, gx: 372, gy:193});
            __.itemsData.push({x: 235, y:427, gx: 731, gy:245}); // 15
            __.itemsData.push({x: 186, y:237 , gx: 667, gy:245});
            __.itemsData.push({x: 213, y:295, gx: 599, gy:243});

            for (index in __.itemsData) {
                var data = __.itemsData[index];
                var nr = parseInt(index) + 1;
                var id = 'item_' + nr;
                __.items[id] = new Material({
                    canvas: __.canvas,
                    id: id,
                    imgUrl: getImgDir(__) + 'item_' + nr + '.png',
                    coordX: data.x,
                    coordY: data.y,
                    draggable: true,
                    bringToFront: true,
                    goodPosition: {x: data.gx, y: data.gy}
                });
                __.items[id].init();
                __.items[id].dragstop = function(layer) {
                    cl(this.id +'    gx: ' + layer.x + ', gy:' + layer.y);

                    var goodPositionNow = false;
                    if (
                        this.id === 'item_13' ||
                        this.id === 'item_15' ||
                        this.id === 'item_16' ||
                        this.id === 'item_17'
                    ) {
                        if (
                            this.isOnPosition(layer, __.getFromData(__.itemsData[12])) ||
                            this.isOnPosition(layer, __.getFromData(__.itemsData[14])) ||
                            this.isOnPosition(layer, __.getFromData(__.itemsData[15])) ||
                            this.isOnPosition(layer, __.getFromData(__.itemsData[16]))
                        ) {
                            goodPositionNow = true;
                        }
                    } else {
                        goodPositionNow = this.isOnPosition(layer);
                    }

                    if (this.id === 'item_14') {
                        cl('cliiick');
                        __.items['item_14'].click();
                    }

                    if (goodPositionNow) {
                        window.countAll++;
                        this.set('draggable', false);
                        this.animateToPosition(layer, this.goodPosition['x'], this.goodPosition['y']);

                        cl(window.countAll);
                        if (window.countAll === 17) {
                            play('koniec-zosia', __.kid1, 'game2.html');
                        } else {
                            play('poprawnie-stas', __.kid2);
                        }


                    } else {
                        this.error(layer);
                        this.backToOryginalPosition(layer);
                        play('blad-zosia', __.kid1);
                    }
                }

                __.items[id].go = function()
                {
                    if (this.goodPosition.x > 0) {
                        cl(this.id);
                         // __.canvas.animateLayer(this.id, {x: this.goodPosition.x, y: this.goodPosition.y}, 600, 'swing');
                    }
                }
            }

            setTimeout(function () {
                for (index in __.itemsData) {
                    var data = __.itemsData[index];
                    var nr = parseInt(index) + 1;
                    var id = 'item_' + nr;

                    __.items[id].go();
                }
            }, 300);

        };

        this.getFromData = function(data)
        {
            var r = {};
            r['x'] = data['gx'];
            r['y'] = data['gy'];
            return r;
        }
    };

    $.fn.Game = function ()
    {
        var instance = (new Game).init();
        var len = this.length;
        return this.each(function (index) {
            var me = $(this);
            var instance = (new Game).init(me);
            me.data('Game' + (len > 1 ? '-' + (index + 1) : ''), instance);
        });

    };
})(window.jQuery, false);