$(document).ready(function () {
    $('#game').Game();
});

gameId = 'B';
gameNr = 3;

(function ($, f) {

    if (!$)
        return f;

    var Game = function ()
    {
        var __ = this;
        __.canvas = false;

        this.init = function (el)
        {
            window.bootstrap();

            if (typeof el === 'undefined')
                return f;

            __.canvas = el;
            __.cWidth = parseInt(__.canvas.css('width'));
            __.cHeight = parseInt(__.canvas.css('height'));

            __.gameId = window.gameId;
            __.gameNr = window.gameNr;

            initBackground(__);
            loadAudioForGame(__);
            loadBgAudio(__);
            __.initKids();

            /*~~~~~~~~~~~~~~~~~~~~~~~*/

            // window.initBlock = false;

            // window.clickBlock = false;
            // window.isAnimateOn = true;

            // __.animals = [];
            __.initPhotos();
            __.initFish();
            __.runGame();
            window.useAnimal = 'ryba';
            window.picturesTaken = 0;


            
            // __.initAnimals();
            // __.initButton();
            // __.initPictures();

            /*~~~~~~~~~~~~~~~~~~~~~~~*/

            setTimeout(function () {
                initButtons(__);
                initHelp(__);
            }, 300);

            if(window.enableInitSounds) {
                playInitAudio(__);
            }
        };

        this.clickOnBg = function(layer) {
            // console.log('x:' + layer.eventX + ', y:' + layer.eventY);
        }

        this.initKids = function ()
        {
            var kid1Path = '/zosia_nurek.png';
            var kid2Path = '/stas_nurek.png';
            __.kid1 = initKid(__, 'kid1', kid1Path, 12, 506);
            __.kid2 = initKid(__, 'kid2', kid2Path, 95, 495);

            var Kids = new Object();
            Kids.kid1 = __.kid1;
            Kids.kid2 = __.kid2;
            window.kids = Kids;
        };
        /*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/

        this.initFish = function() {
            __.items = {};

            var id = 'delfin';
            __.items[id] = new Item({
                canvas: __.canvas,
                id: id,
                imgUrl: getImgDir(__) + id + '.png',
                coordX: 600,
                coordY: 300,
                draggable: false,
                bringToFront: true,
                opacity: 0,
                visible: false
            });
            __.items[id].init();

            __.items[id].click = function(layer) {};


            var id = 'ryba';
            __.items[id] = new Item({
                canvas: __.canvas,
                id: id,
                imgUrl: getImgDir(__) + id + '.png',
                coordX: 600,
                coordY: 300,
                draggable: false,
                bringToFront: true,
                opacity: 0,
                visible: false
            });
            __.items[id].init();

            
            for (index in __.items) {
                var fish = __.items[index];

                fish.click = function(layer) {

                    cl(this.clicked);

                    if (this.clicked || this.id !== 'delfin') {
                        return false;
                    }
                    this.clicked = true;

                    window.picturesTaken++;

                    if (window.picturesTaken == 6) {
                        play('koniec-stas', __.kid2, 'game4.html');
                    } else {
                        play('poprawnie-zosia', __.kid1);
                    }


                    __.canvas.animateLayer('frame', {
                        opacity: 1,
                        visible: true
                    }, 400, function (layer) {});
                    
                    __.canvas.animateLayer('frame', {
                        opacity: 0,
                        visible: false
                    }, 400, function (layer) {});
                    
                    __.markPhoto();
                };

                fish.animate = function()
                {
                    this.clicked =  false;
                    __.canvas.animateLayer(this.id, {
                        x: 600,
                        y: 200, 
                        opacity: 1,
                        visible: true,
                        rotate: '+=60'
                    }, 400, function (layer) {});

                    __.canvas.animateLayer(this.id, {
                        x: 400,
                        y: 100, 
                        opacity: 1,
                        visible: true,
                        rotate: '-=60'
                    }, 400, function (layer) {});

                    __.canvas.animateLayer(this.id, {
                        x: 200,
                        y: 200,
                        opacity: 0,
                        visible: false
                    }, 400, function (layer) {});

                    __.canvas.animateLayer(this.id, {
                        x: 600,
                        y: 300, 
                        opacity: 0,
                        visible: false
                    }, 400, function (layer) {});
                    
                };
            }
        };

        this.runGame = function()
        {
            animalId = (window.useAnimal == 'ryba') ? 'delfin' : 'ryba';
            window.useAnimal = animalId;
            __.items[animalId].animate();

            setTimeout(function () {
                __.runGame();
            }, 1200);  
        };


        this.initPhotos = function()
        {

            __.frame = new Item({
                canvas: __.canvas,
                id: 'frame',
                imgUrl: getImgDir(__) + '/frame.png',
                coordX: 1,
                coordY: 1,
                draggable: false,
                bringToFront: true,
                opacity: 0,
                visible: false
            });
            __.frame.init();

            __.pics = {};
            for(p=1; p<=6; p++) {

                var id = 'pic_' + p;
                __.pics[id] = new Item({
                    canvas: __.canvas,
                    id: id,
                    imgUrl: getImgDir(__) + '/pic.png',
                    coordX: 120 + (p * 75),
                    coordY: 20,
                    draggable: false,
                    bringToFront: true,
                    opacity: 0.4,
                    visible: true
                });
                __.pics[id].init();
            }
        };

        this.markPhoto = function()
        {
            for(p=1; p<=6; p++) {
                if (__.pics['pic_'+ p].opacity === 0.4) {
                    __.pics['pic_'+ p].set('opacity', 1);
                    __.pics['pic_'+ p].opacity = 1;
                    return;
                }
            }
        }
    };

    $.fn.Game = function ()
    {
        var instance = (new Game).init();
        var len = this.length;
        return this.each(function (index) {
            var me = $(this);
            var instance = (new Game).init(me);
            me.data('Game' + (len > 1 ? '-' + (index + 1) : ''), instance);
        });

    };
})(window.jQuery, false);